/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.response;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ChatResponseTest {
    ChatResponseTest() {
    }

    @Test
    void should_keep_backward_compatibility() {
        AiMessage aiMessage = AiMessage.from((String)"hi");
        TokenUsage tokenUsage = new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        FinishReason finishReason = FinishReason.STOP;
        ChatResponse chatResponse = ChatResponse.builder().aiMessage(aiMessage).tokenUsage(tokenUsage).finishReason(finishReason).build();
        Assertions.assertThat((Object)chatResponse.aiMessage()).isEqualTo((Object)aiMessage);
        Assertions.assertThat((Object)chatResponse.tokenUsage()).isEqualTo((Object)tokenUsage);
        Assertions.assertThat((Comparable)chatResponse.finishReason()).isEqualTo((Object)finishReason);
    }

    @Test
    void should_set_ai_message_and_response_metadata() {
        AiMessage aiMessage = AiMessage.from((String)"hi");
        TokenUsage tokenUsage = new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        FinishReason finishReason = FinishReason.STOP;
        ChatResponseMetadata metadata = ChatResponseMetadata.builder().tokenUsage(tokenUsage).finishReason(finishReason).build();
        ChatResponse chatResponse = ChatResponse.builder().aiMessage(aiMessage).metadata(metadata).build();
        Assertions.assertThat((Object)chatResponse.aiMessage()).isEqualTo((Object)aiMessage);
        Assertions.assertThat((Object)chatResponse.metadata()).isEqualTo((Object)metadata);
        Assertions.assertThat((Object)chatResponse.tokenUsage()).isEqualTo((Object)tokenUsage);
        Assertions.assertThat((Comparable)chatResponse.finishReason()).isEqualTo((Object)finishReason);
    }

    @Test
    void should_fail_when_both_response_metadata_and_token_usage_are_set() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChatResponse.builder().aiMessage(AiMessage.from((String)"hi")).metadata(ChatResponseMetadata.builder().build()).tokenUsage(new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))).build()).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot set both 'metadata' and 'tokenUsage' on ChatResponse");
    }

    @Test
    void should_fail_when_both_response_metadata_and_finish_reason_are_set() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChatResponse.builder().aiMessage(AiMessage.from((String)"hi")).metadata(ChatResponseMetadata.builder().build()).finishReason(FinishReason.STOP).build()).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot set both 'metadata' and 'finishReason' on ChatResponse");
    }
}

