/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.content;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.rag.content.Content;
import dev.langchain4j.rag.content.ContentMetadata;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class ContentTest {
    ContentTest() {
    }

    @Test
    void create_from_string() {
        String contentText = "content";
        Content content = Content.from((String)contentText);
        Assertions.assertThat((String)content.textSegment().text()).isEqualTo(contentText);
    }

    @Test
    void create_from_text_segment() {
        TextSegment segment = TextSegment.from((String)"text");
        Content content = Content.from((TextSegment)segment);
        Assertions.assertThat((Object)content.textSegment()).isSameAs((Object)segment);
    }

    @Test
    void create_from_embedding_match() {
        TextSegment segment = TextSegment.from((String)"text");
        Map<ContentMetadata, String> metadata = Map.of(ContentMetadata.SCORE, 0.2, ContentMetadata.EMBEDDING_ID, "test-eid");
        Content content = Content.from((TextSegment)segment, metadata);
        Assertions.assertThat((Object)content.textSegment()).isSameAs((Object)segment);
        Assertions.assertThat((Map)content.metadata()).isNotEmpty();
        Assertions.assertThat((Map)content.metadata()).containsExactlyEntriesOf(Map.of(ContentMetadata.SCORE, 0.2, ContentMetadata.EMBEDDING_ID, "test-eid"));
    }

    @Test
    void equals_hash_code() {
        Content content1 = Content.from((TextSegment)TextSegment.from((String)"content"), Map.of(ContentMetadata.SCORE, 1.0));
        Content content2 = Content.from((String)"content 2");
        Content content3 = Content.from((String)"content");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)content1).isNotEqualTo((Object)content2)).doesNotHaveSameHashCodeAs((Object)content2)).isEqualTo((Object)content3)).hasSameHashCodeAs((Object)content3);
    }

    @Test
    void to_string() {
        Content content = Content.from((String)"content");
        Assertions.assertThat((Object)content).hasToString("DefaultContent { textSegment = TextSegment { text = \"content\" metadata = {} }, metadata = {} }");
    }
}

