/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.query.router;

import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.rag.query.Query;
import dev.langchain4j.rag.query.router.DefaultQueryRouter;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DefaultQueryRouterTest {
    DefaultQueryRouterTest() {
    }

    @Test
    void should_route_to_single_retriever() {
        ContentRetriever retriever1 = (ContentRetriever)Mockito.mock(ContentRetriever.class);
        DefaultQueryRouter router = new DefaultQueryRouter(new ContentRetriever[]{retriever1});
        Collection retrievers = router.route(Query.from((String)"query"));
        Assertions.assertThat((Collection)retrievers).containsExactly((Object[])new ContentRetriever[]{retriever1});
    }

    @Test
    void should_route_to_multiple_retrievers() {
        ContentRetriever retriever1 = (ContentRetriever)Mockito.mock(ContentRetriever.class);
        ContentRetriever retriever2 = (ContentRetriever)Mockito.mock(ContentRetriever.class);
        DefaultQueryRouter router = new DefaultQueryRouter(Arrays.asList(retriever1, retriever2));
        Collection retrievers = router.route(Query.from((String)"query"));
        Assertions.assertThat((Collection)retrievers).containsExactly((Object[])new ContentRetriever[]{retriever1, retriever2});
    }

    @Test
    void should_route_to_multiple_retrievers_varargs() {
        ContentRetriever retriever1 = (ContentRetriever)Mockito.mock(ContentRetriever.class);
        ContentRetriever retriever2 = (ContentRetriever)Mockito.mock(ContentRetriever.class);
        DefaultQueryRouter router = new DefaultQueryRouter(new ContentRetriever[]{retriever1, retriever2});
        Collection retrievers = router.route(Query.from((String)"query"));
        Assertions.assertThat((Collection)retrievers).containsExactly((Object[])new ContentRetriever[]{retriever1, retriever2});
    }
}

