/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.web.search;

import dev.langchain4j.web.search.WebSearchRequest;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class WebSearchRequestTest {
    WebSearchRequestTest() {
    }

    @Test
    void should_build_webSearchRequest_with_default_values() {
        WebSearchRequest webSearchRequest = WebSearchRequest.from((String)"query");
        Assertions.assertThat((String)webSearchRequest.searchTerms()).isEqualTo("query");
        Assertions.assertThat((Integer)webSearchRequest.startPage()).isEqualTo(1);
        Assertions.assertThat((Integer)webSearchRequest.maxResults()).isNull();
        Assertions.assertThat((String)webSearchRequest.language()).isNull();
        Assertions.assertThat((String)webSearchRequest.geoLocation()).isNull();
        Assertions.assertThat((Integer)webSearchRequest.startIndex()).isNull();
        Assertions.assertThat((Boolean)webSearchRequest.safeSearch()).isTrue();
        Assertions.assertThat((Map)webSearchRequest.additionalParams()).isEmpty();
        Assertions.assertThat((Object)webSearchRequest).hasToString("WebSearchRequest{searchTerms='query', maxResults=null, language='null', geoLocation='null', startPage=1, startIndex=null, siteRestrict=true, additionalParams={}}");
    }

    @Test
    void should_build_webSearchRequest_with_default_values_builder() {
        WebSearchRequest webSearchRequest = WebSearchRequest.builder().searchTerms("query").build();
        Assertions.assertThat((String)webSearchRequest.searchTerms()).isEqualTo("query");
        Assertions.assertThat((Integer)webSearchRequest.startPage()).isEqualTo(1);
        Assertions.assertThat((Integer)webSearchRequest.maxResults()).isNull();
        Assertions.assertThat((String)webSearchRequest.language()).isNull();
        Assertions.assertThat((String)webSearchRequest.geoLocation()).isNull();
        Assertions.assertThat((Integer)webSearchRequest.startIndex()).isNull();
        Assertions.assertThat((Boolean)webSearchRequest.safeSearch()).isTrue();
        Assertions.assertThat((Map)webSearchRequest.additionalParams()).isEmpty();
        Assertions.assertThat((Object)webSearchRequest).hasToString("WebSearchRequest{searchTerms='query', maxResults=null, language='null', geoLocation='null', startPage=1, startIndex=null, siteRestrict=true, additionalParams={}}");
    }

    @Test
    void should_build_webSearchRequest_with_custom_maxResults() {
        WebSearchRequest webSearchRequest = WebSearchRequest.from((String)"query", (Integer)10);
        Assertions.assertThat((String)webSearchRequest.searchTerms()).isEqualTo("query");
        Assertions.assertThat((Integer)webSearchRequest.startPage()).isEqualTo(1);
        Assertions.assertThat((Integer)webSearchRequest.maxResults()).isEqualTo(10);
        Assertions.assertThat((String)webSearchRequest.language()).isNull();
        Assertions.assertThat((String)webSearchRequest.geoLocation()).isNull();
        Assertions.assertThat((Integer)webSearchRequest.startIndex()).isNull();
        Assertions.assertThat((Boolean)webSearchRequest.safeSearch()).isTrue();
        Assertions.assertThat((Map)webSearchRequest.additionalParams()).isEmpty();
        Assertions.assertThat((Object)webSearchRequest).hasToString("WebSearchRequest{searchTerms='query', maxResults=10, language='null', geoLocation='null', startPage=1, startIndex=null, siteRestrict=true, additionalParams={}}");
    }

    @Test
    void should_build_webSearchRequest_with_custom_maxResults_builder() {
        WebSearchRequest webSearchRequest = WebSearchRequest.builder().searchTerms("query").maxResults(Integer.valueOf(10)).build();
        Assertions.assertThat((String)webSearchRequest.searchTerms()).isEqualTo("query");
        Assertions.assertThat((Integer)webSearchRequest.startPage()).isEqualTo(1);
        Assertions.assertThat((Integer)webSearchRequest.maxResults()).isEqualTo(10);
        Assertions.assertThat((String)webSearchRequest.language()).isNull();
        Assertions.assertThat((String)webSearchRequest.geoLocation()).isNull();
        Assertions.assertThat((Integer)webSearchRequest.startIndex()).isNull();
        Assertions.assertThat((Boolean)webSearchRequest.safeSearch()).isTrue();
        Assertions.assertThat((Map)webSearchRequest.additionalParams()).isEmpty();
        Assertions.assertThat((Object)webSearchRequest).hasToString("WebSearchRequest{searchTerms='query', maxResults=10, language='null', geoLocation='null', startPage=1, startIndex=null, siteRestrict=true, additionalParams={}}");
    }

    @Test
    void equals_and_hash() {
        WebSearchRequest wsr1 = WebSearchRequest.from((String)"query", (Integer)10);
        WebSearchRequest wsr2 = WebSearchRequest.from((String)"query", (Integer)10);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)wsr1).isEqualTo((Object)wsr1)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)wsr2)).hasSameHashCodeAs((Object)wsr2);
        Assertions.assertThat((Object)WebSearchRequest.from((String)"other query", (Integer)10)).isNotEqualTo((Object)wsr1);
        Assertions.assertThat((Object)WebSearchRequest.from((String)"query", (Integer)20)).isNotEqualTo((Object)wsr1);
    }

    @Test
    void should_throw_illegalArgumentException_without_searchTerms() {
        IllegalArgumentException exception = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> WebSearchRequest.builder().build());
        Assertions.assertThat((Throwable)exception).hasMessage("searchTerms cannot be null or blank");
    }
}

