/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.dashscope;

import com.alibaba.dashscope.aigc.conversation.ConversationParam;
import com.alibaba.dashscope.aigc.generation.Generation;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.generation.models.QwenParam;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversation;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationParam;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.protocol.Protocol;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.dashscope.QwenHelper;
import dev.langchain4j.model.dashscope.QwenStreamingResponseBuilder;
import dev.langchain4j.model.dashscope.spi.QwenStreamingChatModelBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.util.Iterator;
import java.util.List;

public class QwenStreamingChatModel
implements StreamingChatLanguageModel {
    private final String apiKey;
    private final String modelName;
    private final Double topP;
    private final Integer topK;
    private final Boolean enableSearch;
    private final Integer seed;
    private final Float repetitionPenalty;
    private final Float temperature;
    private final List<String> stops;
    private final Integer maxTokens;
    private final Generation generation;
    private final MultiModalConversation conv;
    private final boolean isMultimodalModel;

    public QwenStreamingChatModel(String baseUrl, String apiKey, String modelName, Double topP, Integer topK, Boolean enableSearch, Integer seed, Float repetitionPenalty, Float temperature, List<String> stops, Integer maxTokens) {
        if (Utils.isNullOrBlank((String)apiKey)) {
            throw new IllegalArgumentException("DashScope api key must be defined. It can be generated here: https://dashscope.console.aliyun.com/apiKey");
        }
        this.modelName = Utils.isNullOrBlank((String)modelName) ? "qwen-plus" : modelName;
        this.enableSearch = enableSearch != null && enableSearch != false;
        this.apiKey = apiKey;
        this.topP = topP;
        this.topK = topK;
        this.seed = seed;
        this.repetitionPenalty = repetitionPenalty;
        this.temperature = temperature;
        this.stops = stops;
        this.maxTokens = maxTokens;
        this.isMultimodalModel = QwenHelper.isMultimodalModel(modelName);
        if (Utils.isNullOrBlank((String)baseUrl)) {
            this.conv = this.isMultimodalModel ? new MultiModalConversation() : null;
            this.generation = this.isMultimodalModel ? null : new Generation();
        } else if (baseUrl.startsWith("wss://")) {
            this.conv = this.isMultimodalModel ? new MultiModalConversation(Protocol.WEBSOCKET.getValue(), baseUrl) : null;
            this.generation = this.isMultimodalModel ? null : new Generation(Protocol.WEBSOCKET.getValue(), baseUrl);
        } else {
            this.conv = this.isMultimodalModel ? new MultiModalConversation(Protocol.HTTP.getValue(), baseUrl) : null;
            this.generation = this.isMultimodalModel ? null : new Generation(Protocol.HTTP.getValue(), baseUrl);
        }
    }

    public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
        if (this.isMultimodalModel) {
            this.generateByMultimodalModel(messages, handler);
        } else {
            this.generateByNonMultimodalModel(messages, handler);
        }
    }

    private void generateByNonMultimodalModel(List<ChatMessage> messages, final StreamingResponseHandler<AiMessage> handler) {
        try {
            QwenParam.QwenParamBuilder builder = (QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)QwenParam.builder().apiKey(this.apiKey)).model(this.modelName)).topP(this.topP)).topK(this.topK)).enableSearch(this.enableSearch)).seed(this.seed)).repetitionPenalty(this.repetitionPenalty)).temperature(this.temperature)).maxTokens(this.maxTokens)).incrementalOutput(Boolean.valueOf(true))).messages(QwenHelper.toQwenMessages(messages))).resultFormat(ConversationParam.ResultFormat.MESSAGE);
            if (this.stops != null) {
                builder.stopStrings(this.stops);
            }
            final QwenStreamingResponseBuilder responseBuilder = new QwenStreamingResponseBuilder();
            this.generation.streamCall((HalfDuplexServiceParam)builder.build(), (ResultCallback)new ResultCallback<GenerationResult>(){

                public void onEvent(GenerationResult result) {
                    String delta = responseBuilder.append(result);
                    if (Utils.isNotNullOrBlank((String)delta)) {
                        handler.onNext(delta);
                    }
                }

                public void onComplete() {
                    handler.onComplete(responseBuilder.build());
                }

                public void onError(Exception e) {
                    handler.onError((Throwable)e);
                }
            });
        }
        catch (InputRequiredException | NoApiKeyException e) {
            throw new RuntimeException(e);
        }
    }

    private void generateByMultimodalModel(List<ChatMessage> messages, final StreamingResponseHandler<AiMessage> handler) {
        try {
            MultiModalConversationParam param = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)MultiModalConversationParam.builder().apiKey(this.apiKey)).model(this.modelName)).topP(this.topP).topK(this.topK).enableSearch(this.enableSearch).seed(this.seed).temperature(this.temperature).maxLength(this.maxTokens).incrementalOutput(Boolean.valueOf(true)).messages(QwenHelper.toQwenMultiModalMessages(messages)).build();
            final QwenStreamingResponseBuilder responseBuilder = new QwenStreamingResponseBuilder();
            this.conv.streamCall(param, (ResultCallback)new ResultCallback<MultiModalConversationResult>(){

                public void onEvent(MultiModalConversationResult result) {
                    String delta = responseBuilder.append(result);
                    if (Utils.isNotNullOrBlank((String)delta)) {
                        handler.onNext(delta);
                    }
                }

                public void onComplete() {
                    handler.onComplete(responseBuilder.build());
                }

                public void onError(Exception e) {
                    handler.onError((Throwable)e);
                }
            });
        }
        catch (InputRequiredException | NoApiKeyException | UploadFileException e) {
            throw new RuntimeException(e);
        }
    }

    public static QwenStreamingChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(QwenStreamingChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            QwenStreamingChatModelBuilderFactory factory = (QwenStreamingChatModelBuilderFactory)iterator.next();
            return (QwenStreamingChatModelBuilder)factory.get();
        }
        return new QwenStreamingChatModelBuilder();
    }

    public static class QwenStreamingChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Double topP;
        private Integer topK;
        private Boolean enableSearch;
        private Integer seed;
        private Float repetitionPenalty;
        private Float temperature;
        private List<String> stops;
        private Integer maxTokens;

        public QwenStreamingChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public QwenStreamingChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public QwenStreamingChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public QwenStreamingChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public QwenStreamingChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public QwenStreamingChatModelBuilder enableSearch(Boolean enableSearch) {
            this.enableSearch = enableSearch;
            return this;
        }

        public QwenStreamingChatModelBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public QwenStreamingChatModelBuilder repetitionPenalty(Float repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return this;
        }

        public QwenStreamingChatModelBuilder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public QwenStreamingChatModelBuilder stops(List<String> stops) {
            this.stops = stops;
            return this;
        }

        public QwenStreamingChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public QwenStreamingChatModel build() {
            return new QwenStreamingChatModel(this.baseUrl, this.apiKey, this.modelName, this.topP, this.topK, this.enableSearch, this.seed, this.repetitionPenalty, this.temperature, this.stops, this.maxTokens);
        }

        public String toString() {
            return "QwenStreamingChatModel.QwenStreamingChatModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", modelName=" + this.modelName + ", topP=" + this.topP + ", topK=" + this.topK + ", enableSearch=" + this.enableSearch + ", seed=" + this.seed + ", repetitionPenalty=" + this.repetitionPenalty + ", temperature=" + this.temperature + ", stops=" + this.stops + ", maxTokens=" + this.maxTokens + ")";
        }
    }
}

