/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.dashscope;

import com.alibaba.dashscope.aigc.generation.GenerationOutput;
import com.alibaba.dashscope.aigc.generation.GenerationParam;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationOutput;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationParam;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.common.MultiModalMessage;
import com.alibaba.dashscope.common.Role;
import com.alibaba.dashscope.tools.FunctionDefinition;
import com.alibaba.dashscope.tools.ToolBase;
import com.alibaba.dashscope.tools.ToolCallBase;
import com.alibaba.dashscope.tools.ToolCallFunction;
import com.alibaba.dashscope.tools.ToolFunction;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonObject;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolParameters;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.audio.Audio;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.AudioContent;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QwenHelper {
    private static final Logger log = LoggerFactory.getLogger(QwenHelper.class);

    QwenHelper() {
    }

    static List<Message> toQwenMessages(List<ChatMessage> messages) {
        return QwenHelper.sanitizeMessages(messages).stream().map(QwenHelper::toQwenMessage).collect(Collectors.toList());
    }

    static List<Message> toQwenMessages(Iterable<ChatMessage> messages) {
        LinkedList<Message> qwenMessages = new LinkedList<Message>();
        messages.forEach(message -> qwenMessages.add(QwenHelper.toQwenMessage(message)));
        return qwenMessages;
    }

    static Message toQwenMessage(ChatMessage message) {
        return Message.builder().role(QwenHelper.roleFrom(message)).content(QwenHelper.toSingleText(message)).name(QwenHelper.nameFrom(message)).toolCallId(QwenHelper.toolCallIdFrom(message)).toolCalls(QwenHelper.toolCallsFrom(message)).build();
    }

    static String toSingleText(ChatMessage message) {
        switch (message.type()) {
            case USER: {
                return ((UserMessage)message).contents().stream().filter(TextContent.class::isInstance).map(TextContent.class::cast).map(TextContent::text).collect(Collectors.joining("\n"));
            }
            case AI: {
                return ((AiMessage)message).hasToolExecutionRequests() ? "" : ((AiMessage)message).text();
            }
            case SYSTEM: {
                return ((SystemMessage)message).text();
            }
            case TOOL_EXECUTION_RESULT: {
                return ((ToolExecutionResultMessage)message).text();
            }
        }
        return "";
    }

    static String nameFrom(ChatMessage message) {
        switch (message.type()) {
            case USER: {
                return ((UserMessage)message).name();
            }
            case TOOL_EXECUTION_RESULT: {
                return ((ToolExecutionResultMessage)message).toolName();
            }
        }
        return null;
    }

    static String toolCallIdFrom(ChatMessage message) {
        if (message.type() == ChatMessageType.TOOL_EXECUTION_RESULT) {
            return ((ToolExecutionResultMessage)message).id();
        }
        return null;
    }

    static List<ToolCallBase> toolCallsFrom(ChatMessage message) {
        if (message.type() == ChatMessageType.AI && ((AiMessage)message).hasToolExecutionRequests()) {
            return QwenHelper.toToolCalls(((AiMessage)message).toolExecutionRequests());
        }
        return null;
    }

    static List<MultiModalMessage> toQwenMultiModalMessages(List<ChatMessage> messages) {
        return messages.stream().map(QwenHelper::toQwenMultiModalMessage).collect(Collectors.toList());
    }

    static MultiModalMessage toQwenMultiModalMessage(ChatMessage message) {
        return MultiModalMessage.builder().role(QwenHelper.roleFrom(message)).content(QwenHelper.toMultiModalContents(message)).build();
    }

    static List<Map<String, Object>> toMultiModalContents(ChatMessage message) {
        switch (message.type()) {
            case USER: {
                return ((UserMessage)message).contents().stream().map(QwenHelper::toMultiModalContent).collect(Collectors.toList());
            }
            case AI: {
                return Collections.singletonList(Collections.singletonMap("text", ((AiMessage)message).text()));
            }
            case SYSTEM: {
                return Collections.singletonList(Collections.singletonMap("text", ((SystemMessage)message).text()));
            }
            case TOOL_EXECUTION_RESULT: {
                return Collections.singletonList(Collections.singletonMap("text", ((ToolExecutionResultMessage)message).text()));
            }
        }
        return Collections.emptyList();
    }

    static Map<String, Object> toMultiModalContent(Content content) {
        switch (content.type()) {
            case IMAGE: {
                Image image = ((ImageContent)content).image();
                if (image.url() != null) {
                    String imageContent = image.url().toString();
                    return Collections.singletonMap("image", imageContent);
                }
                if (Utils.isNotNullOrBlank((String)image.base64Data())) {
                    String imageContent = QwenHelper.saveDataAsTemporaryFile(image.base64Data(), image.mimeType());
                    HashMap<String, Object> contentMap = new HashMap<String, Object>(1);
                    contentMap.put("image", imageContent);
                    return contentMap;
                }
                return Collections.emptyMap();
            }
            case AUDIO: {
                Audio audio = ((AudioContent)content).audio();
                if (audio.url() != null) {
                    String audioContent = audio.url().toString();
                    return Collections.singletonMap("audio", audioContent);
                }
                if (Utils.isNotNullOrBlank((String)audio.base64Data())) {
                    String audioContent = QwenHelper.saveDataAsTemporaryFile(audio.base64Data(), audio.mimeType());
                    HashMap<String, Object> contentMap = new HashMap<String, Object>(1);
                    contentMap.put("audio", audioContent);
                    return contentMap;
                }
                return Collections.emptyMap();
            }
            case TEXT: {
                return Collections.singletonMap("text", ((TextContent)content).text());
            }
        }
        return Collections.emptyMap();
    }

    static String saveDataAsTemporaryFile(String base64Data, String mimeType) {
        int lastSlashIndex;
        String tmpDir = System.getProperty("java.io.tmpdir", "/tmp");
        String tmpFileName = UUID.randomUUID().toString();
        if (Utils.isNotNullOrBlank((String)mimeType) && (lastSlashIndex = mimeType.lastIndexOf("/")) >= 0 && lastSlashIndex < mimeType.length() - 1) {
            String fileSuffix = mimeType.substring(lastSlashIndex + 1);
            tmpFileName = tmpFileName + "." + fileSuffix;
        }
        Path tmpFilePath = Paths.get(tmpDir, tmpFileName);
        byte[] data = Base64.getDecoder().decode(base64Data);
        try {
            Files.copy(new ByteArrayInputStream(data), tmpFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tmpFilePath.toAbsolutePath().toUri().toString();
    }

    static String roleFrom(ChatMessage message) {
        if (message.type() == ChatMessageType.AI) {
            return Role.ASSISTANT.getValue();
        }
        if (message.type() == ChatMessageType.SYSTEM) {
            return Role.SYSTEM.getValue();
        }
        if (message.type() == ChatMessageType.TOOL_EXECUTION_RESULT) {
            return Role.TOOL.getValue();
        }
        return Role.USER.getValue();
    }

    static boolean hasAnswer(GenerationResult result) {
        return Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getChoices).filter(choices -> !choices.isEmpty()).isPresent();
    }

    static String answerFrom(GenerationResult result) {
        return Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (GenerationOutput.Choice)choices.get(0)).map(GenerationOutput.Choice::getMessage).map(Message::getContent).orElseGet(() -> Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getText).orElse(""));
    }

    static boolean hasAnswer(MultiModalConversationResult result) {
        return Optional.of(result).map(MultiModalConversationResult::getOutput).map(MultiModalConversationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (MultiModalConversationOutput.Choice)choices.get(0)).map(MultiModalConversationOutput.Choice::getMessage).map(MultiModalMessage::getContent).filter(contents -> !contents.isEmpty()).isPresent();
    }

    static String answerFrom(MultiModalConversationResult result) {
        return Optional.of(result).map(MultiModalConversationResult::getOutput).map(MultiModalConversationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (MultiModalConversationOutput.Choice)choices.get(0)).map(MultiModalConversationOutput.Choice::getMessage).map(MultiModalMessage::getContent).filter(contents -> !contents.isEmpty()).map(contents -> (Map)contents.get(0)).map(content -> content.get("text")).map(String.class::cast).orElse("");
    }

    static TokenUsage tokenUsageFrom(GenerationResult result) {
        return Optional.of(result).map(GenerationResult::getUsage).map(usage -> new TokenUsage(usage.getInputTokens(), usage.getOutputTokens())).orElse(null);
    }

    static TokenUsage tokenUsageFrom(MultiModalConversationResult result) {
        return Optional.of(result).map(MultiModalConversationResult::getUsage).map(usage -> new TokenUsage(usage.getInputTokens(), usage.getOutputTokens())).orElse(null);
    }

    static FinishReason finishReasonFrom(GenerationResult result) {
        String finishReason;
        GenerationOutput.Choice choice = (GenerationOutput.Choice)result.getOutput().getChoices().get(0);
        switch (finishReason = Utils.isNullOrEmpty((Collection)choice.getMessage().getToolCalls()) ? choice.getFinishReason() : "tool_calls") {
            case "stop": {
                return FinishReason.STOP;
            }
            case "length": {
                return FinishReason.LENGTH;
            }
            case "tool_calls": {
                return FinishReason.TOOL_EXECUTION;
            }
        }
        return null;
    }

    static FinishReason finishReasonFrom(MultiModalConversationResult result) {
        String finishReason;
        switch (finishReason = Optional.of(result).map(MultiModalConversationResult::getOutput).map(MultiModalConversationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (MultiModalConversationOutput.Choice)choices.get(0)).map(MultiModalConversationOutput.Choice::getFinishReason).orElse("")) {
            case "stop": {
                return FinishReason.STOP;
            }
            case "length": {
                return FinishReason.LENGTH;
            }
        }
        return null;
    }

    public static boolean isMultimodalModel(String modelName) {
        return modelName.contains("-vl-") || modelName.contains("-audio-");
    }

    static List<ToolBase> toToolFunctions(Collection<ToolSpecification> toolSpecifications) {
        if (Utils.isNullOrEmpty(toolSpecifications)) {
            return Collections.emptyList();
        }
        return toolSpecifications.stream().map(QwenHelper::toToolFunction).collect(Collectors.toList());
    }

    static ToolBase toToolFunction(ToolSpecification toolSpecification) {
        FunctionDefinition functionDefinition = FunctionDefinition.builder().name(toolSpecification.name()).description(toolSpecification.description()).parameters(QwenHelper.toParameters(toolSpecification.parameters())).build();
        return ToolFunction.builder().function(functionDefinition).build();
    }

    private static JsonObject toParameters(ToolParameters toolParameters) {
        return toolParameters == null ? JsonUtils.toJsonObject(Collections.emptyMap()) : JsonUtils.toJsonObject((Object)toolParameters);
    }

    static AiMessage aiMessageFrom(GenerationResult result) {
        return QwenHelper.isFunctionToolCalls(result) ? new AiMessage(QwenHelper.functionToolCallsFrom(result)) : new AiMessage(QwenHelper.answerFrom(result));
    }

    private static List<ToolExecutionRequest> functionToolCallsFrom(GenerationResult result) {
        List toolCalls = Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (GenerationOutput.Choice)choices.get(0)).map(GenerationOutput.Choice::getMessage).map(Message::getToolCalls).orElseThrow(IllegalStateException::new);
        return toolCalls.stream().filter(ToolCallFunction.class::isInstance).map(ToolCallFunction.class::cast).map(toolCall -> ToolExecutionRequest.builder().id((String)Utils.getOrDefault((Object)toolCall.getId(), () -> QwenHelper.toolCallIdFromMessage(result))).name(toolCall.getFunction().getName()).arguments(toolCall.getFunction().getArguments()).build()).collect(Collectors.toList());
    }

    static String toolCallIdFromMessage(GenerationResult result) {
        return Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (GenerationOutput.Choice)choices.get(0)).map(GenerationOutput.Choice::getMessage).map(Message::getToolCallId).orElse(null);
    }

    static boolean isFunctionToolCalls(GenerationResult result) {
        Optional<List> toolCallBases = Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (GenerationOutput.Choice)choices.get(0)).map(GenerationOutput.Choice::getMessage).map(Message::getToolCalls);
        return toolCallBases.isPresent() && !Utils.isNullOrEmpty((Collection)toolCallBases.get());
    }

    private static List<ToolCallBase> toToolCalls(Collection<ToolExecutionRequest> toolExecutionRequests) {
        return toolExecutionRequests.stream().map(QwenHelper::toToolCall).collect(Collectors.toList());
    }

    private static ToolCallBase toToolCall(ToolExecutionRequest toolExecutionRequest) {
        ToolCallFunction toolCallFunction = new ToolCallFunction();
        toolCallFunction.setId(toolExecutionRequest.id());
        ToolCallFunction.CallFunction callFunction = new ToolCallFunction.CallFunction(toolCallFunction);
        callFunction.setName(toolExecutionRequest.name());
        callFunction.setArguments(toolExecutionRequest.arguments());
        toolCallFunction.setFunction(callFunction);
        return toolCallFunction;
    }

    static List<ChatMessage> sanitizeMessages(List<ChatMessage> messages) {
        LinkedList<ChatMessage> sanitizedMessages = messages.stream().reduce(new LinkedList(), QwenHelper.messageAccumulator(), QwenHelper.messageCombiner());
        while (!sanitizedMessages.isEmpty() && !QwenHelper.isInputMessageType(sanitizedMessages.getLast().type())) {
            ChatMessage removedMessage = sanitizedMessages.removeLast();
            log.warn("The last message should be a user/tool_execution_result message, but found: {}", (Object)removedMessage);
        }
        return sanitizedMessages;
    }

    private static BiFunction<LinkedList<ChatMessage>, ChatMessage, LinkedList<ChatMessage>> messageAccumulator() {
        return (acc, message) -> {
            ChatMessageType type = message.type();
            if (acc.isEmpty()) {
                if (type == ChatMessageType.SYSTEM || type == ChatMessageType.USER) {
                    acc.add(message);
                } else {
                    log.warn("The first message should be a system message or a user message, but found: {}", message);
                }
                return acc;
            }
            if (type == ChatMessageType.SYSTEM) {
                log.warn("The system message should be the first message. Drop existed messages: {}", acc);
                acc.clear();
                acc.add(message);
                return acc;
            }
            ChatMessageType lastType = ((ChatMessage)acc.getLast()).type();
            if (lastType == ChatMessageType.SYSTEM && type != ChatMessageType.USER) {
                log.warn("The first non-system message must be a user message, but found: {}", message);
                return acc;
            }
            if (QwenHelper.isInputMessageType(type) == QwenHelper.isInputMessageType(lastType)) {
                ChatMessage removedMessage = (ChatMessage)acc.removeLast();
                log.warn("User/Tool-execution-result messages and AI messages should alternate. Drop duplicated message: {}", (Object)removedMessage);
            }
            acc.add(message);
            return acc;
        };
    }

    private static BinaryOperator<LinkedList<ChatMessage>> messageCombiner() {
        return (acc1, acc2) -> {
            throw new UnsupportedOperationException("Parallel stream not supported");
        };
    }

    private static boolean isInputMessageType(ChatMessageType messageType) {
        return messageType == ChatMessageType.USER || messageType == ChatMessageType.TOOL_EXECUTION_RESULT;
    }

    static ChatModelRequest createModelListenerRequest(GenerationParam request, List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        Double temperature = request.getTemperature() != null ? Double.valueOf(request.getTemperature().doubleValue()) : null;
        return ChatModelRequest.builder().model(request.getModel()).temperature(temperature).topP(request.getTopP()).maxTokens(request.getMaxTokens()).messages(messages).toolSpecifications(toolSpecifications).build();
    }

    static ChatModelRequest createModelListenerRequest(MultiModalConversationParam request, List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        Double temperature = request.getTemperature() != null ? Double.valueOf(request.getTemperature().doubleValue()) : null;
        return ChatModelRequest.builder().model(request.getModel()).temperature(temperature).topP(request.getTopP()).maxTokens(request.getMaxLength()).messages(messages).toolSpecifications(toolSpecifications).build();
    }

    static ChatModelResponse createModelListenerResponse(String responseId, String responseModel, Response<AiMessage> response) {
        if (response == null) {
            return null;
        }
        return ChatModelResponse.builder().id(responseId).model(responseModel).tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).aiMessage((AiMessage)response.content()).build();
    }
}

