/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.loader.azure.storage.blob;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.specialized.BlobInputStream;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentLoader;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.DocumentSource;
import dev.langchain4j.data.document.source.azure.storage.blob.AzureBlobStorageSource;
import dev.langchain4j.internal.ValidationUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureBlobStorageDocumentLoader {
    private static final Logger log = LoggerFactory.getLogger(AzureBlobStorageDocumentLoader.class);
    private final BlobServiceClient blobServiceClient;

    public AzureBlobStorageDocumentLoader(BlobServiceClient blobServiceClient) {
        this.blobServiceClient = (BlobServiceClient)ValidationUtils.ensureNotNull((Object)blobServiceClient, (String)"blobServiceClient");
    }

    public Document loadDocument(String containerName, String blobName, DocumentParser parser) {
        BlobClient blobClient = this.blobServiceClient.getBlobContainerClient(containerName).getBlobClient(blobName);
        BlobProperties properties = blobClient.getProperties();
        BlobInputStream blobInputStream = blobClient.openInputStream();
        AzureBlobStorageSource source = new AzureBlobStorageSource((InputStream)blobInputStream, blobClient.getAccountName(), containerName, blobName, properties);
        return DocumentLoader.load((DocumentSource)source, (DocumentParser)parser);
    }

    public List<Document> loadDocuments(String containerName, DocumentParser parser) {
        ArrayList<Document> documents = new ArrayList<Document>();
        this.blobServiceClient.getBlobContainerClient(containerName).listBlobs().forEach(blob -> documents.add(this.loadDocument(containerName, blob.getName(), parser)));
        return documents;
    }
}

