/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.KnnQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.elasticsearch.Document;
import dev.langchain4j.store.embedding.elasticsearch.ElasticsearchConfiguration;
import dev.langchain4j.store.embedding.elasticsearch.ElasticsearchMetadataFilterMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchConfigurationKnn
extends ElasticsearchConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchConfigurationKnn.class);
    private final Integer numCandidates;

    public static Builder builder() {
        return new Builder();
    }

    private ElasticsearchConfigurationKnn(Integer numCandidates) {
        this.numCandidates = numCandidates;
    }

    @Override
    SearchResponse<Document> internalSearch(ElasticsearchClient client, String indexName, EmbeddingSearchRequest embeddingSearchRequest) throws ElasticsearchException, IOException {
        KnnQuery.Builder krb = new KnnQuery.Builder().field("vector").queryVector(embeddingSearchRequest.queryEmbedding().vectorAsList());
        if (embeddingSearchRequest.filter() != null) {
            krb.filter(ElasticsearchMetadataFilterMapper.map(embeddingSearchRequest.filter()), new Query[0]);
        }
        if (this.numCandidates != null) {
            krb.numCandidates(this.numCandidates);
        }
        KnnQuery knn = krb.build();
        log.trace("Searching for embeddings in index [{}] with query [{}].", (Object)indexName, (Object)knn);
        return client.search(sr -> sr.index(indexName, new String[0]).size(Integer.valueOf(embeddingSearchRequest.maxResults())).query(q -> q.knn(knn)).minScore(Double.valueOf(embeddingSearchRequest.minScore())), Document.class);
    }

    public static class Builder {
        private Integer numCandidates;

        public ElasticsearchConfigurationKnn build() {
            return new ElasticsearchConfigurationKnn(this.numCandidates);
        }

        public Builder numCandidates(Integer numCandidates) {
            this.numCandidates = numCandidates;
            return this;
        }
    }
}

