/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.embedding;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.DimensionAwareEmbeddingModel;
import dev.langchain4j.model.embedding.OnnxBertBiEncoder;
import dev.langchain4j.model.embedding.PoolingMode;
import dev.langchain4j.model.embedding.TokenCountEstimator;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public abstract class AbstractInProcessEmbeddingModel
extends DimensionAwareEmbeddingModel
implements TokenCountEstimator {
    protected static OnnxBertBiEncoder loadFromJar(String modelFileName, String tokenizerFileName, PoolingMode poolingMode) {
        InputStream model = Thread.currentThread().getContextClassLoader().getResourceAsStream(modelFileName);
        InputStream tokenizer = Thread.currentThread().getContextClassLoader().getResourceAsStream(tokenizerFileName);
        return new OnnxBertBiEncoder(model, tokenizer, poolingMode);
    }

    static OnnxBertBiEncoder loadFromFileSystem(Path pathToModel, Path pathToTokenizer, PoolingMode poolingMode) {
        try {
            return new OnnxBertBiEncoder(Files.newInputStream(pathToModel, new OpenOption[0]), Files.newInputStream(pathToTokenizer, new OpenOption[0]), poolingMode);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static OnnxBertBiEncoder loadFromFileSystem(Path pathToModel, InputStream tokenizer, PoolingMode poolingMode) {
        try {
            return new OnnxBertBiEncoder(Files.newInputStream(pathToModel, new OpenOption[0]), tokenizer, poolingMode);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract OnnxBertBiEncoder model();

    protected abstract Executor executor();

    public Response<List<Embedding>> embedAll(List<TextSegment> segments) {
        Executor executor = this.executor();
        List futures = segments.stream().map(segment -> CompletableFuture.supplyAsync(() -> this.model().embed(segment.text()), executor)).collect(Collectors.toList());
        int inputTokenCount = 0;
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        for (CompletableFuture future : futures) {
            try {
                OnnxBertBiEncoder.EmbeddingAndTokenCount embeddingAndTokenCount = (OnnxBertBiEncoder.EmbeddingAndTokenCount)future.get();
                embeddings.add(Embedding.from((float[])embeddingAndTokenCount.embedding));
                inputTokenCount += embeddingAndTokenCount.tokenCount - 2;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return Response.from(embeddings, (TokenUsage)new TokenUsage(Integer.valueOf(inputTokenCount)));
    }

    public int estimateTokenCount(String text) {
        return this.model().countTokens(text);
    }
}

