/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.embedding;

import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.embedding.AbstractInProcessEmbeddingModel;
import dev.langchain4j.model.embedding.OnnxBertBiEncoder;
import dev.langchain4j.model.embedding.PoolingMode;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class OnnxEmbeddingModel
extends AbstractInProcessEmbeddingModel {
    private final OnnxBertBiEncoder onnxBertBiEncoder;
    private final Executor executor;

    public OnnxEmbeddingModel(Path pathToModel, Path pathToTokenizer, PoolingMode poolingMode) {
        this(pathToModel, pathToTokenizer, poolingMode, (Executor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
    }

    public OnnxEmbeddingModel(Path pathToModel, Path pathToTokenizer, PoolingMode poolingMode, Executor executor) {
        this.onnxBertBiEncoder = OnnxEmbeddingModel.loadFromFileSystem(pathToModel, pathToTokenizer, poolingMode);
        this.executor = (Executor)ValidationUtils.ensureNotNull((Object)executor, (String)"executor");
    }

    public OnnxEmbeddingModel(String pathToModel, String pathToTokenizer, PoolingMode poolingMode) {
        this(Paths.get(pathToModel, new String[0]), Paths.get(pathToTokenizer, new String[0]), poolingMode);
    }

    public OnnxEmbeddingModel(String pathToModel, String pathToTokenizer, PoolingMode poolingMode, Executor executor) {
        this(Paths.get(pathToModel, new String[0]), Paths.get(pathToTokenizer, new String[0]), poolingMode, executor);
    }

    @Deprecated
    public OnnxEmbeddingModel(Path pathToModel) {
        this.onnxBertBiEncoder = OnnxEmbeddingModel.loadFromFileSystem(pathToModel, OnnxEmbeddingModel.class.getResourceAsStream("/tokenizer.json"), PoolingMode.MEAN);
        this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    @Deprecated
    public OnnxEmbeddingModel(String pathToModel) {
        this(Paths.get(pathToModel, new String[0]));
    }

    @Override
    protected OnnxBertBiEncoder model() {
        return this.onnxBertBiEncoder;
    }

    @Override
    protected Executor executor() {
        return this.executor;
    }
}

