/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.googleaigemini.spring;

import dev.langchain4j.googleaigemini.spring.ChatModelProperties;
import dev.langchain4j.googleaigemini.spring.EmbeddingModelProperties;
import dev.langchain4j.googleaigemini.spring.Properties;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.googleai.GeminiHarmBlockThreshold;
import dev.langchain4j.model.googleai.GeminiHarmCategory;
import dev.langchain4j.model.googleai.GoogleAiEmbeddingModel;
import dev.langchain4j.model.googleai.GoogleAiGeminiChatModel;
import dev.langchain4j.model.googleai.GoogleAiGeminiStreamingChatModel;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={Properties.class})
class AutoConfig {
    AutoConfig() {
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.google-ai-gemini.chat-model.api-key", "langchain4j.google-ai-gemini.chat-model.model-name"})
    GoogleAiGeminiChatModel googleAiGeminiChatModel(Properties properties, ObjectProvider<ChatModelListener> listeners) {
        ChatModelProperties chatModelProperties = properties.getChatModel();
        GoogleAiGeminiChatModel.GoogleAiGeminiChatModelBuilder builder = GoogleAiGeminiChatModel.builder().apiKey(chatModelProperties.apiKey()).modelName(chatModelProperties.modelName()).maxRetries(chatModelProperties.maxRetries()).temperature(chatModelProperties.temperature()).topK(chatModelProperties.topK()).topP(chatModelProperties.topP()).maxOutputTokens(chatModelProperties.maxOutputTokens()).timeout(chatModelProperties.timeout()).logRequestsAndResponses(chatModelProperties.logRequestsAndResponses()).listeners(listeners.orderedStream().toList());
        if (chatModelProperties.safetySetting() != null && !chatModelProperties.safetySetting().isEmpty()) {
            builder.safetySettings(this.convertSafetySettings(chatModelProperties.safetySetting()));
        }
        if (chatModelProperties.functionCallingConfig() != null) {
            builder.toolConfig(chatModelProperties.functionCallingConfig().geminiMode(), chatModelProperties.functionCallingConfig().allowedFunctionNames().toArray(new String[0]));
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.google-ai-gemini.streaming-chat-model.api-key", "langchain4j.google-ai-gemini.streaming-chat-model.model-name"})
    GoogleAiGeminiStreamingChatModel googleAiGeminiStreamingChatModel(Properties properties, ObjectProvider<ChatModelListener> listeners) {
        ChatModelProperties chatModelProperties = properties.getStreamingChatModel();
        GoogleAiGeminiStreamingChatModel.GoogleAiGeminiStreamingChatModelBuilder builder = GoogleAiGeminiStreamingChatModel.builder().apiKey(chatModelProperties.apiKey()).modelName(chatModelProperties.modelName()).temperature(chatModelProperties.temperature()).topK(chatModelProperties.topK()).topP(chatModelProperties.topP()).maxOutputTokens(chatModelProperties.maxOutputTokens()).timeout(chatModelProperties.timeout()).logRequestsAndResponses(chatModelProperties.logRequestsAndResponses()).listeners(listeners.orderedStream().toList()).maxRetries(chatModelProperties.maxRetries());
        if (chatModelProperties.safetySetting() != null && !chatModelProperties.safetySetting().isEmpty()) {
            builder.safetySettings(this.convertSafetySettings(chatModelProperties.safetySetting()));
        }
        if (chatModelProperties.functionCallingConfig() != null) {
            builder.toolConfig(chatModelProperties.functionCallingConfig().geminiMode(), chatModelProperties.functionCallingConfig().allowedFunctionNames().toArray(new String[0]));
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.google-ai-gemini.embedding-model.api-key", "langchain4j.google-ai-gemini.embedding-model.model-name"})
    GoogleAiEmbeddingModel googleAiEmbeddingModel(Properties properties) {
        EmbeddingModelProperties embeddingModelProperties = properties.getEmbeddingModel();
        return GoogleAiEmbeddingModel.builder().modelName(embeddingModelProperties.modelName()).apiKey(embeddingModelProperties.apiKey()).maxRetries(embeddingModelProperties.maxRetries()).taskType(embeddingModelProperties.taskType()).titleMetadataKey(embeddingModelProperties.titleMetadataKey()).outputDimensionality(embeddingModelProperties.outputDimensionality()).timeout(embeddingModelProperties.timeout()).logRequestsAndResponses(embeddingModelProperties.logRequestsAndResponses()).build();
    }

    private Map<GeminiHarmCategory, GeminiHarmBlockThreshold> convertSafetySettings(Map<String, String> map) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> GeminiHarmCategory.valueOf((String)((String)e.getKey())), e -> GeminiHarmBlockThreshold.valueOf((String)((String)e.getValue()))));
    }
}

