/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import com.google.gson.Gson;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolParameters;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.model.googleai.GeminiCodeExecution;
import dev.langchain4j.model.googleai.GeminiFunctionCall;
import dev.langchain4j.model.googleai.GeminiFunctionDeclaration;
import dev.langchain4j.model.googleai.GeminiSchema;
import dev.langchain4j.model.googleai.GeminiTool;
import dev.langchain4j.model.googleai.GeminiType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class FunctionMapper {
    private static final Gson GSON = new Gson();

    FunctionMapper() {
    }

    static GeminiTool fromToolSepcsToGTool(List<ToolSpecification> specifications, boolean allowCodeExecution) {
        GeminiTool.GeminiToolBuilder tool = GeminiTool.builder();
        if (allowCodeExecution) {
            tool.codeExecution(new GeminiCodeExecution());
        }
        if (specifications == null || specifications.isEmpty()) {
            if (allowCodeExecution) {
                return tool.build();
            }
            return null;
        }
        List<GeminiFunctionDeclaration> functionDeclarations = specifications.stream().map(specification -> {
            GeminiFunctionDeclaration.GeminiFunctionDeclarationBuilder fnBuilder = GeminiFunctionDeclaration.builder();
            if (specification.name() != null) {
                fnBuilder.name(specification.name());
            }
            if (specification.description() != null) {
                fnBuilder.description(specification.description());
            }
            if (specification.parameters() != null) {
                ToolParameters parameters = specification.parameters();
                String[] propName = new String[]{""};
                fnBuilder.parameters(GeminiSchema.builder().type(GeminiType.OBJECT).properties(parameters.properties().entrySet().stream().map(prop -> {
                    propName[0] = (String)prop.getKey();
                    Map propAttributes = (Map)prop.getValue();
                    String typeString = propAttributes.getOrDefault("type", "string");
                    GeminiType type = GeminiType.valueOf(typeString.toUpperCase());
                    String description = propAttributes.getOrDefault("description", null);
                    return GeminiSchema.builder().description(description).type(type).build();
                }).collect(Collectors.toMap(schema -> propName[0], schema -> schema))).build());
            }
            return fnBuilder.build();
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!functionDeclarations.isEmpty()) {
            tool.functionDeclarations(functionDeclarations);
        }
        return tool.build();
    }

    static List<ToolExecutionRequest> fromToolExecReqToGFunCall(List<GeminiFunctionCall> functionCalls) {
        return functionCalls.stream().map(functionCall -> ToolExecutionRequest.builder().name(functionCall.getName()).arguments(GSON.toJson(functionCall.getArgs())).build()).collect(Collectors.toList());
    }
}

