/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.model.googleai.GeminiContent;
import dev.langchain4j.model.googleai.GeminiGenerationConfig;
import dev.langchain4j.model.googleai.GeminiSafetySetting;
import dev.langchain4j.model.googleai.GeminiTool;
import dev.langchain4j.model.googleai.GeminiToolConfig;
import java.util.List;

class GeminiGenerateContentRequest {
    private List<GeminiContent> contents;
    private GeminiTool tools;
    private GeminiToolConfig toolConfig;
    private List<GeminiSafetySetting> safetySettings;
    private GeminiContent systemInstruction;
    private GeminiGenerationConfig generationConfig;
    private String cachedContent;

    GeminiGenerateContentRequest(List<GeminiContent> contents, GeminiTool tools, GeminiToolConfig toolConfig, List<GeminiSafetySetting> safetySettings, GeminiContent systemInstruction, GeminiGenerationConfig generationConfig, String cachedContent) {
        this.contents = contents;
        this.tools = tools;
        this.toolConfig = toolConfig;
        this.safetySettings = safetySettings;
        this.systemInstruction = systemInstruction;
        this.generationConfig = generationConfig;
        this.cachedContent = cachedContent;
    }

    public static GeminiGenerateContentRequestBuilder builder() {
        return new GeminiGenerateContentRequestBuilder();
    }

    public List<GeminiContent> getContents() {
        return this.contents;
    }

    public GeminiTool getTools() {
        return this.tools;
    }

    public GeminiToolConfig getToolConfig() {
        return this.toolConfig;
    }

    public List<GeminiSafetySetting> getSafetySettings() {
        return this.safetySettings;
    }

    public GeminiContent getSystemInstruction() {
        return this.systemInstruction;
    }

    public GeminiGenerationConfig getGenerationConfig() {
        return this.generationConfig;
    }

    public String getCachedContent() {
        return this.cachedContent;
    }

    public void setContents(List<GeminiContent> contents) {
        this.contents = contents;
    }

    public void setTools(GeminiTool tools) {
        this.tools = tools;
    }

    public void setToolConfig(GeminiToolConfig toolConfig) {
        this.toolConfig = toolConfig;
    }

    public void setSafetySettings(List<GeminiSafetySetting> safetySettings) {
        this.safetySettings = safetySettings;
    }

    public void setSystemInstruction(GeminiContent systemInstruction) {
        this.systemInstruction = systemInstruction;
    }

    public void setGenerationConfig(GeminiGenerationConfig generationConfig) {
        this.generationConfig = generationConfig;
    }

    public void setCachedContent(String cachedContent) {
        this.cachedContent = cachedContent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeminiGenerateContentRequest)) {
            return false;
        }
        GeminiGenerateContentRequest other = (GeminiGenerateContentRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<GeminiContent> this$contents = this.getContents();
        List<GeminiContent> other$contents = other.getContents();
        if (this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents)) {
            return false;
        }
        GeminiTool this$tools = this.getTools();
        GeminiTool other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        GeminiToolConfig this$toolConfig = this.getToolConfig();
        GeminiToolConfig other$toolConfig = other.getToolConfig();
        if (this$toolConfig == null ? other$toolConfig != null : !((Object)this$toolConfig).equals(other$toolConfig)) {
            return false;
        }
        List<GeminiSafetySetting> this$safetySettings = this.getSafetySettings();
        List<GeminiSafetySetting> other$safetySettings = other.getSafetySettings();
        if (this$safetySettings == null ? other$safetySettings != null : !((Object)this$safetySettings).equals(other$safetySettings)) {
            return false;
        }
        GeminiContent this$systemInstruction = this.getSystemInstruction();
        GeminiContent other$systemInstruction = other.getSystemInstruction();
        if (this$systemInstruction == null ? other$systemInstruction != null : !((Object)this$systemInstruction).equals(other$systemInstruction)) {
            return false;
        }
        GeminiGenerationConfig this$generationConfig = this.getGenerationConfig();
        GeminiGenerationConfig other$generationConfig = other.getGenerationConfig();
        if (this$generationConfig == null ? other$generationConfig != null : !((Object)this$generationConfig).equals(other$generationConfig)) {
            return false;
        }
        String this$cachedContent = this.getCachedContent();
        String other$cachedContent = other.getCachedContent();
        return !(this$cachedContent == null ? other$cachedContent != null : !this$cachedContent.equals(other$cachedContent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeminiGenerateContentRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<GeminiContent> $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
        GeminiTool $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        GeminiToolConfig $toolConfig = this.getToolConfig();
        result = result * 59 + ($toolConfig == null ? 43 : ((Object)$toolConfig).hashCode());
        List<GeminiSafetySetting> $safetySettings = this.getSafetySettings();
        result = result * 59 + ($safetySettings == null ? 43 : ((Object)$safetySettings).hashCode());
        GeminiContent $systemInstruction = this.getSystemInstruction();
        result = result * 59 + ($systemInstruction == null ? 43 : ((Object)$systemInstruction).hashCode());
        GeminiGenerationConfig $generationConfig = this.getGenerationConfig();
        result = result * 59 + ($generationConfig == null ? 43 : ((Object)$generationConfig).hashCode());
        String $cachedContent = this.getCachedContent();
        result = result * 59 + ($cachedContent == null ? 43 : $cachedContent.hashCode());
        return result;
    }

    public String toString() {
        return "GeminiGenerateContentRequest(contents=" + this.getContents() + ", tools=" + this.getTools() + ", toolConfig=" + this.getToolConfig() + ", safetySettings=" + this.getSafetySettings() + ", systemInstruction=" + this.getSystemInstruction() + ", generationConfig=" + this.getGenerationConfig() + ", cachedContent=" + this.getCachedContent() + ")";
    }

    public static class GeminiGenerateContentRequestBuilder {
        private List<GeminiContent> contents;
        private GeminiTool tools;
        private GeminiToolConfig toolConfig;
        private List<GeminiSafetySetting> safetySettings;
        private GeminiContent systemInstruction;
        private GeminiGenerationConfig generationConfig;
        private String cachedContent;

        GeminiGenerateContentRequestBuilder() {
        }

        public GeminiGenerateContentRequestBuilder contents(List<GeminiContent> contents) {
            this.contents = contents;
            return this;
        }

        public GeminiGenerateContentRequestBuilder tools(GeminiTool tools) {
            this.tools = tools;
            return this;
        }

        public GeminiGenerateContentRequestBuilder toolConfig(GeminiToolConfig toolConfig) {
            this.toolConfig = toolConfig;
            return this;
        }

        public GeminiGenerateContentRequestBuilder safetySettings(List<GeminiSafetySetting> safetySettings) {
            this.safetySettings = safetySettings;
            return this;
        }

        public GeminiGenerateContentRequestBuilder systemInstruction(GeminiContent systemInstruction) {
            this.systemInstruction = systemInstruction;
            return this;
        }

        public GeminiGenerateContentRequestBuilder generationConfig(GeminiGenerationConfig generationConfig) {
            this.generationConfig = generationConfig;
            return this;
        }

        public GeminiGenerateContentRequestBuilder cachedContent(String cachedContent) {
            this.cachedContent = cachedContent;
            return this;
        }

        public GeminiGenerateContentRequest build() {
            return new GeminiGenerateContentRequest(this.contents, this.tools, this.toolConfig, this.safetySettings, this.systemInstruction, this.generationConfig, this.cachedContent);
        }

        public String toString() {
            return "GeminiGenerateContentRequest.GeminiGenerateContentRequestBuilder(contents=" + this.contents + ", tools=" + this.tools + ", toolConfig=" + this.toolConfig + ", safetySettings=" + this.safetySettings + ", systemInstruction=" + this.systemInstruction + ", generationConfig=" + this.generationConfig + ", cachedContent=" + this.cachedContent + ")";
        }
    }
}

