/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import com.google.gson.Gson;
import dev.langchain4j.Experimental;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.googleai.FinishReasonMapper;
import dev.langchain4j.model.googleai.FunctionMapper;
import dev.langchain4j.model.googleai.GeminiCandidate;
import dev.langchain4j.model.googleai.GeminiContent;
import dev.langchain4j.model.googleai.GeminiError;
import dev.langchain4j.model.googleai.GeminiErrorContainer;
import dev.langchain4j.model.googleai.GeminiFunctionCallingConfig;
import dev.langchain4j.model.googleai.GeminiGenerateContentRequest;
import dev.langchain4j.model.googleai.GeminiGenerateContentResponse;
import dev.langchain4j.model.googleai.GeminiGenerationConfig;
import dev.langchain4j.model.googleai.GeminiHarmBlockThreshold;
import dev.langchain4j.model.googleai.GeminiHarmCategory;
import dev.langchain4j.model.googleai.GeminiMode;
import dev.langchain4j.model.googleai.GeminiRole;
import dev.langchain4j.model.googleai.GeminiSafetySetting;
import dev.langchain4j.model.googleai.GeminiSchema;
import dev.langchain4j.model.googleai.GeminiService;
import dev.langchain4j.model.googleai.GeminiToolConfig;
import dev.langchain4j.model.googleai.GeminiUsageMetadata;
import dev.langchain4j.model.googleai.PartsAndContentsMapper;
import dev.langchain4j.model.googleai.SchemaMapper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Experimental
public class GoogleAiGeminiChatModel
implements ChatLanguageModel {
    private static final String GEMINI_AI_ENDPOINT = "https://generativelanguage.googleapis.com/v1beta/";
    private static Gson GSON = new Gson();
    private final String apiKey;
    private final String modelName;
    private final Double temperature;
    private final Integer topK;
    private final Double topP;
    private final Integer maxOutputTokens;
    private final List<String> stopSequences;
    private final Integer candidateCount;
    private final String responseMimeType;
    private final ResponseFormat responseFormat;
    private final GeminiFunctionCallingConfig toolConfig;
    private final Boolean logRequestsAndResponses;
    private final boolean allowCodeExecution;
    private final boolean includeCodeExecutionOutput;
    private final List<GeminiSafetySetting> safetySettings;

    public GoogleAiGeminiChatModel(String apiKey, String modelName, Double temperature, Integer topK, Double topP, Integer maxOutputTokens, Integer candidateCount, String responseMimeType, ResponseFormat responseFormat, List<String> stopSequences, GeminiFunctionCallingConfig toolConfig, Boolean allowCodeExecution, Boolean includeCodeExecutionOutput, Boolean logRequestsAndResponses, List<GeminiSafetySetting> safetySettings) {
        this.apiKey = ValidationUtils.ensureNotBlank((String)apiKey, (String)"apiKey");
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)1.0);
        this.topK = (Integer)Utils.getOrDefault((Object)topK, (Object)64);
        this.topP = (Double)Utils.getOrDefault((Object)topP, (Object)0.95);
        this.maxOutputTokens = (Integer)Utils.getOrDefault((Object)maxOutputTokens, (Object)8192);
        this.candidateCount = (Integer)Utils.getOrDefault((Object)candidateCount, (Object)1);
        this.stopSequences = (List)Utils.getOrDefault(stopSequences, Collections.emptyList());
        this.toolConfig = toolConfig;
        this.allowCodeExecution = allowCodeExecution != null ? allowCodeExecution : false;
        this.includeCodeExecutionOutput = includeCodeExecutionOutput != null ? includeCodeExecutionOutput : false;
        this.safetySettings = Utils.copyIfNotNull(safetySettings);
        this.responseFormat = responseFormat;
        this.responseMimeType = responseFormat != null ? (responseFormat.type().equals((Object)ResponseFormatType.JSON) ? "application/json" : "text/plain") : (responseMimeType != null ? responseMimeType : "text/plain");
        this.logRequestsAndResponses = (Boolean)Utils.getOrDefault((Object)logRequestsAndResponses, (Object)false);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        ChatRequest request = ChatRequest.builder().messages(messages).build();
        ChatResponse response = this.chat(request);
        return Response.from((Object)response.aiMessage(), (TokenUsage)response.tokenUsage(), (FinishReason)response.finishReason());
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        return this.generate(messages, Collections.singletonList(toolSpecification));
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        ChatRequest request = ChatRequest.builder().messages(messages).toolSpecifications(toolSpecifications).build();
        ChatResponse response = this.chat(request);
        return Response.from((Object)response.aiMessage(), (TokenUsage)response.tokenUsage(), (FinishReason)response.finishReason());
    }

    public ChatResponse chat(ChatRequest chatRequest) {
        GeminiGenerateContentResponse geminiResponse;
        block10: {
            GeminiSchema schema;
            GeminiService geminiModel = this.getGeminiService();
            GeminiContent systemInstruction = new GeminiContent(GeminiRole.MODEL.toString());
            List<GeminiContent> geminiContentList = PartsAndContentsMapper.fromMessageToGContent(chatRequest.messages(), systemInstruction);
            List toolSpecifications = chatRequest.toolSpecifications();
            String responseMimeType = this.responseMimeType;
            if (chatRequest.responseFormat() != null) {
                schema = SchemaMapper.fromJsonSchemaToGSchema(chatRequest.responseFormat().jsonSchema());
                responseMimeType = chatRequest.responseFormat().type().equals((Object)ResponseFormatType.JSON) ? "application/json" : "text/plain";
            } else {
                schema = this.responseFormat != null ? SchemaMapper.fromJsonSchemaToGSchema(this.responseFormat.jsonSchema()) : null;
            }
            GeminiGenerateContentRequest request = GeminiGenerateContentRequest.builder().contents(geminiContentList).systemInstruction(!systemInstruction.getParts().isEmpty() ? systemInstruction : null).generationConfig(GeminiGenerationConfig.builder().candidateCount(this.candidateCount).maxOutputTokens(this.maxOutputTokens).responseMimeType(responseMimeType).responseSchema(schema).stopSequences(this.stopSequences).temperature(this.temperature).topK(this.topK).topP(this.topP).build()).safetySettings(this.safetySettings).tools(FunctionMapper.fromToolSepcsToGTool(toolSpecifications, this.allowCodeExecution)).toolConfig(new GeminiToolConfig(this.toolConfig)).build();
            Call<GeminiGenerateContentResponse> responseCall = geminiModel.generateContent(this.modelName, this.apiKey, request);
            try {
                retrofit2.Response executed = responseCall.execute();
                geminiResponse = (GeminiGenerateContentResponse)executed.body();
                if (executed.code() < 300) break block10;
                ResponseBody errorBody = executed.errorBody();
                try {
                    GeminiError error = ((GeminiErrorContainer)GSON.fromJson(errorBody.string(), GeminiErrorContainer.class)).getError();
                    throw new RuntimeException(String.format("%s (code %d) %s", error.getStatus(), error.getCode(), error.getMessage()));
                }
                catch (Throwable error) {
                    if (errorBody != null) {
                        try {
                            errorBody.close();
                        }
                        catch (Throwable throwable) {
                            error.addSuppressed(throwable);
                        }
                    }
                    throw error;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("An error occurred when calling the Gemini API endpoint.", e);
            }
        }
        if (geminiResponse != null) {
            GeminiCandidate firstCandidate = geminiResponse.getCandidates().get(0);
            GeminiUsageMetadata tokenCounts = geminiResponse.getUsageMetadata();
            FinishReason finishReason = FinishReasonMapper.fromGFinishReasonToFinishReason(firstCandidate.getFinishReason());
            AiMessage aiMessage = firstCandidate.getContent() == null ? AiMessage.from((String)("No text was returned by the model. The model finished generating because of the following reason: " + finishReason)) : PartsAndContentsMapper.fromGPartsToAiMessage(firstCandidate.getContent().getParts(), this.includeCodeExecutionOutput);
            return ChatResponse.builder().aiMessage(aiMessage).finishReason(finishReason).tokenUsage(new TokenUsage(tokenCounts.getPromptTokenCount(), tokenCounts.getCandidatesTokenCount(), tokenCounts.getTotalTokenCount())).build();
        }
        throw new RuntimeException("Gemini response was null");
    }

    private GeminiService getGeminiService() {
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(GEMINI_AI_ENDPOINT).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        if (this.logRequestsAndResponses.booleanValue()) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
            logging.setLevel(HttpLoggingInterceptor.Level.BODY);
            retrofitBuilder.client(new OkHttpClient.Builder().addInterceptor((Interceptor)logging).build());
        }
        Retrofit retrofit = retrofitBuilder.build();
        return (GeminiService)retrofit.create(GeminiService.class);
    }

    public static GoogleAiGeminiChatModelBuilder builder() {
        return new GoogleAiGeminiChatModelBuilder();
    }

    public static class GoogleAiGeminiChatModelBuilder {
        private String apiKey;
        private String modelName;
        private Double temperature;
        private Integer topK;
        private Double topP;
        private Integer maxOutputTokens;
        private Integer candidateCount;
        private String responseMimeType;
        private ResponseFormat responseFormat;
        private List<String> stopSequences;
        private GeminiFunctionCallingConfig toolConfig;
        private Boolean allowCodeExecution;
        private Boolean includeCodeExecutionOutput;
        private Boolean logRequestsAndResponses;
        private List<GeminiSafetySetting> safetySettings;

        public GoogleAiGeminiChatModelBuilder toolConfig(GeminiMode mode, String ... allowedFunctionNames) {
            this.toolConfig = new GeminiFunctionCallingConfig(mode, Arrays.asList(allowedFunctionNames));
            return this;
        }

        public GoogleAiGeminiChatModelBuilder responseSchema(JsonSchema schema) {
            this.responseMimeType = "application/json";
            this.responseFormat = ResponseFormat.builder().type(ResponseFormatType.JSON).jsonSchema(schema).build();
            return this;
        }

        public GoogleAiGeminiChatModelBuilder safetySettings(Map<GeminiHarmCategory, GeminiHarmBlockThreshold> safetySettingMap) {
            this.safetySettings = safetySettingMap.entrySet().stream().map(entry -> new GeminiSafetySetting((GeminiHarmCategory)((Object)((Object)entry.getKey())), (GeminiHarmBlockThreshold)((Object)((Object)entry.getValue())))).collect(Collectors.toList());
            return this;
        }

        GoogleAiGeminiChatModelBuilder() {
        }

        public GoogleAiGeminiChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder candidateCount(Integer candidateCount) {
            this.candidateCount = candidateCount;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder responseMimeType(String responseMimeType) {
            this.responseMimeType = responseMimeType;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder allowCodeExecution(Boolean allowCodeExecution) {
            this.allowCodeExecution = allowCodeExecution;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder includeCodeExecutionOutput(Boolean includeCodeExecutionOutput) {
            this.includeCodeExecutionOutput = includeCodeExecutionOutput;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder logRequestsAndResponses(Boolean logRequestsAndResponses) {
            this.logRequestsAndResponses = logRequestsAndResponses;
            return this;
        }

        public GoogleAiGeminiChatModel build() {
            return new GoogleAiGeminiChatModel(this.apiKey, this.modelName, this.temperature, this.topK, this.topP, this.maxOutputTokens, this.candidateCount, this.responseMimeType, this.responseFormat, this.stopSequences, this.toolConfig, this.allowCodeExecution, this.includeCodeExecutionOutput, this.logRequestsAndResponses, this.safetySettings);
        }

        public String toString() {
            return "GoogleAiGeminiChatModel.GoogleAiGeminiChatModelBuilder(apiKey=" + this.apiKey + ", modelName=" + this.modelName + ", temperature=" + this.temperature + ", topK=" + this.topK + ", topP=" + this.topP + ", maxOutputTokens=" + this.maxOutputTokens + ", candidateCount=" + this.candidateCount + ", responseMimeType=" + this.responseMimeType + ", responseFormat=" + this.responseFormat + ", stopSequences=" + this.stopSequences + ", toolConfig=" + this.toolConfig + ", allowCodeExecution=" + this.allowCodeExecution + ", includeCodeExecutionOutput=" + this.includeCodeExecutionOutput + ", logRequestsAndResponses=" + this.logRequestsAndResponses + ", safetySettings=" + this.safetySettings + ")";
        }
    }
}

