/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import com.google.gson.Gson;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.model.googleai.GeminiCodeExecution;
import dev.langchain4j.model.googleai.GeminiFunctionCall;
import dev.langchain4j.model.googleai.GeminiFunctionDeclaration;
import dev.langchain4j.model.googleai.GeminiSchema;
import dev.langchain4j.model.googleai.GeminiTool;
import dev.langchain4j.model.googleai.GeminiType;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class FunctionMapper {
    private static final Gson GSON = new Gson();

    FunctionMapper() {
    }

    static GeminiTool fromToolSepcsToGTool(List<ToolSpecification> specifications, boolean allowCodeExecution) {
        GeminiTool.GeminiToolBuilder tool = GeminiTool.builder();
        if (allowCodeExecution) {
            tool.codeExecution(new GeminiCodeExecution());
        }
        if (specifications == null || specifications.isEmpty()) {
            if (allowCodeExecution) {
                return tool.build();
            }
            return null;
        }
        List<GeminiFunctionDeclaration> functionDeclarations = specifications.stream().map(specification -> {
            GeminiFunctionDeclaration.GeminiFunctionDeclarationBuilder fnBuilder = GeminiFunctionDeclaration.builder();
            if (specification.name() != null) {
                fnBuilder.name(specification.name());
            }
            if (specification.description() != null) {
                fnBuilder.description(specification.description());
            }
            if (specification.parameters() != null) {
                Map properties = specification.parameters().properties();
                String type = "object";
                String description = specification.description();
                fnBuilder.parameters(FunctionMapper.fromMap(type, null, null, properties));
            }
            return fnBuilder.build();
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!functionDeclarations.isEmpty()) {
            tool.functionDeclarations(functionDeclarations);
        }
        return tool.build();
    }

    private static GeminiSchema fromMap(String type, String arrayType, String description, Map<String, Map<String, Object>> obj) {
        GeminiSchema.GeminiSchemaBuilder schemaBuilder = GeminiSchema.builder();
        schemaBuilder.type(GeminiType.valueOf(type.toUpperCase()));
        schemaBuilder.description(description);
        if (type.equals("array")) {
            Map arrayObj = (Map)obj.values().iterator().next().get("properties");
            schemaBuilder.items(FunctionMapper.fromMap(arrayType, null, description, arrayObj));
        } else {
            LinkedHashMap<String, GeminiSchema> props = new LinkedHashMap<String, GeminiSchema>();
            if (obj != null) {
                for (Map.Entry<String, Map<String, Object>> oneProperty : obj.entrySet()) {
                    String propName = oneProperty.getKey();
                    Map<String, Object> propAttributes = oneProperty.getValue();
                    String propTypeString = (String)propAttributes.getOrDefault("type", "string");
                    String propDescription = propAttributes.getOrDefault("description", null);
                    Map<String, Map<String, Object>> childProps = propAttributes.getOrDefault("properties", Collections.emptyMap());
                    Map items = (Map)propAttributes.get("items");
                    HashMap<String, Map<String, Object>> singleProp = new HashMap<String, Map<String, Object>>();
                    singleProp.put(propName, items);
                    if (items != null) {
                        String itemsType = items.get("type").toString();
                        props.put(propName, FunctionMapper.fromMap(propTypeString, itemsType, propDescription, singleProp));
                        continue;
                    }
                    props.put(propName, FunctionMapper.fromMap(propTypeString, null, propDescription, childProps));
                }
            }
            schemaBuilder.properties(props);
        }
        return schemaBuilder.build();
    }

    static List<ToolExecutionRequest> fromToolExecReqToGFunCall(List<GeminiFunctionCall> functionCalls) {
        return functionCalls.stream().map(functionCall -> ToolExecutionRequest.builder().name(functionCall.getName()).arguments(GSON.toJson(functionCall.getArgs())).build()).collect(Collectors.toList());
    }
}

