/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.model.googleai.GeminiCountTokensRequest;
import dev.langchain4j.model.googleai.GeminiCountTokensResponse;
import dev.langchain4j.model.googleai.GeminiGenerateContentRequest;
import dev.langchain4j.model.googleai.GeminiGenerateContentResponse;
import dev.langchain4j.model.googleai.GoogleAiBatchEmbeddingRequest;
import dev.langchain4j.model.googleai.GoogleAiBatchEmbeddingResponse;
import dev.langchain4j.model.googleai.GoogleAiEmbeddingRequest;
import dev.langchain4j.model.googleai.GoogleAiEmbeddingResponse;
import java.time.Duration;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;

interface GeminiService {
    public static final String GEMINI_AI_ENDPOINT = "https://generativelanguage.googleapis.com/v1beta/";
    public static final String API_KEY_HEADER_NAME = "x-goog-api-key";
    public static final String USER_AGENT = "User-Agent: LangChain4j";

    public static GeminiService getGeminiService(Logger logger, Duration timeout) {
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(GEMINI_AI_ENDPOINT).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().callTimeout(timeout);
        if (logger != null) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor(arg_0 -> ((Logger)logger).debug(arg_0));
            logging.redactHeader(API_KEY_HEADER_NAME);
            logging.setLevel(HttpLoggingInterceptor.Level.BODY);
            clientBuilder.addInterceptor((Interceptor)logging);
        }
        retrofitBuilder.client(clientBuilder.build());
        Retrofit retrofit = retrofitBuilder.build();
        return (GeminiService)retrofit.create(GeminiService.class);
    }

    @POST(value="models/{model}:generateContent")
    @Headers(value={"User-Agent: LangChain4j"})
    public Call<GeminiGenerateContentResponse> generateContent(@Path(value="model") String var1, @Header(value="x-goog-api-key") String var2, @Body GeminiGenerateContentRequest var3);

    @POST(value="models/{model}:countTokens")
    @Headers(value={"User-Agent: LangChain4j"})
    public Call<GeminiCountTokensResponse> countTokens(@Path(value="model") String var1, @Header(value="x-goog-api-key") String var2, @Body GeminiCountTokensRequest var3);

    @POST(value="models/{model}:embedContent")
    @Headers(value={"User-Agent: LangChain4j"})
    public Call<GoogleAiEmbeddingResponse> embed(@Path(value="model") String var1, @Header(value="x-goog-api-key") String var2, @Body GoogleAiEmbeddingRequest var3);

    @POST(value="models/{model}:batchEmbedContents")
    @Headers(value={"User-Agent: LangChain4j"})
    public Call<GoogleAiBatchEmbeddingResponse> batchEmbed(@Path(value="model") String var1, @Header(value="x-goog-api-key") String var2, @Body GoogleAiBatchEmbeddingRequest var3);
}

