/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import com.google.gson.Gson;
import dev.langchain4j.Experimental;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.TokenCountEstimator;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.json.JsonEnumSchema;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.googleai.FinishReasonMapper;
import dev.langchain4j.model.googleai.FunctionMapper;
import dev.langchain4j.model.googleai.GeminiCandidate;
import dev.langchain4j.model.googleai.GeminiContent;
import dev.langchain4j.model.googleai.GeminiError;
import dev.langchain4j.model.googleai.GeminiErrorContainer;
import dev.langchain4j.model.googleai.GeminiFunctionCallingConfig;
import dev.langchain4j.model.googleai.GeminiGenerateContentRequest;
import dev.langchain4j.model.googleai.GeminiGenerateContentResponse;
import dev.langchain4j.model.googleai.GeminiGenerationConfig;
import dev.langchain4j.model.googleai.GeminiHarmBlockThreshold;
import dev.langchain4j.model.googleai.GeminiHarmCategory;
import dev.langchain4j.model.googleai.GeminiMode;
import dev.langchain4j.model.googleai.GeminiRole;
import dev.langchain4j.model.googleai.GeminiSafetySetting;
import dev.langchain4j.model.googleai.GeminiSchema;
import dev.langchain4j.model.googleai.GeminiService;
import dev.langchain4j.model.googleai.GeminiToolConfig;
import dev.langchain4j.model.googleai.GeminiUsageMetadata;
import dev.langchain4j.model.googleai.GoogleAiGeminiTokenizer;
import dev.langchain4j.model.googleai.PartsAndContentsMapper;
import dev.langchain4j.model.googleai.SchemaMapper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;

@Experimental
public class GoogleAiGeminiChatModel
implements ChatLanguageModel,
TokenCountEstimator {
    private static final Logger log = LoggerFactory.getLogger(GoogleAiGeminiChatModel.class);
    private static final Gson GSON = new Gson();
    private final GeminiService geminiService;
    private final String apiKey;
    private final String modelName;
    private final Integer maxRetries;
    private final Double temperature;
    private final Integer topK;
    private final Double topP;
    private final Integer maxOutputTokens;
    private final List<String> stopSequences;
    private final Integer candidateCount;
    private final ResponseFormat responseFormat;
    private final GeminiFunctionCallingConfig toolConfig;
    private final boolean allowCodeExecution;
    private final boolean includeCodeExecutionOutput;
    private final Boolean logRequestsAndResponses;
    private final List<GeminiSafetySetting> safetySettings;
    private final List<ChatModelListener> listeners;
    private final GoogleAiGeminiTokenizer geminiTokenizer;

    public GoogleAiGeminiChatModel(String apiKey, String modelName, Integer maxRetries, Double temperature, Integer topK, Double topP, Integer maxOutputTokens, Integer candidateCount, Duration timeout, ResponseFormat responseFormat, List<String> stopSequences, GeminiFunctionCallingConfig toolConfig, Boolean allowCodeExecution, Boolean includeCodeExecutionOutput, Boolean logRequestsAndResponses, List<GeminiSafetySetting> safetySettings, List<ChatModelListener> listeners) {
        this.apiKey = ValidationUtils.ensureNotBlank((String)apiKey, (String)"apiKey");
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)1.0);
        this.topK = (Integer)Utils.getOrDefault((Object)topK, (Object)64);
        this.topP = (Double)Utils.getOrDefault((Object)topP, (Object)0.95);
        this.maxOutputTokens = (Integer)Utils.getOrDefault((Object)maxOutputTokens, (Object)8192);
        this.candidateCount = (Integer)Utils.getOrDefault((Object)candidateCount, (Object)1);
        this.stopSequences = (List)Utils.getOrDefault(stopSequences, Collections.emptyList());
        this.toolConfig = toolConfig;
        this.allowCodeExecution = allowCodeExecution != null ? allowCodeExecution : false;
        this.includeCodeExecutionOutput = includeCodeExecutionOutput != null ? includeCodeExecutionOutput : false;
        this.logRequestsAndResponses = (Boolean)Utils.getOrDefault((Object)logRequestsAndResponses, (Object)false);
        this.safetySettings = Utils.copyIfNotNull(safetySettings);
        this.responseFormat = responseFormat;
        ArrayList<ChatModelListener> arrayList = this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
        this.geminiService = GeminiService.getGeminiService(((Boolean)Utils.getOrDefault((Object)logRequestsAndResponses, (Object)false)).booleanValue() ? log : null, (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L)));
        this.geminiTokenizer = GoogleAiGeminiTokenizer.builder().modelName(this.modelName).apiKey(this.apiKey).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).maxRetries(this.maxRetries).logRequestsAndResponses(this.logRequestsAndResponses).build();
    }

    private static String computeMimeType(ResponseFormat responseFormat) {
        if (responseFormat == null || ResponseFormatType.TEXT.equals((Object)responseFormat.type())) {
            return "text/plain";
        }
        if (ResponseFormatType.JSON.equals((Object)responseFormat.type()) && responseFormat.jsonSchema() != null && responseFormat.jsonSchema().rootElement() != null && responseFormat.jsonSchema().rootElement() instanceof JsonEnumSchema) {
            return "text/x.enum";
        }
        return "application/json";
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        ChatRequest request = ChatRequest.builder().messages(messages).build();
        ChatResponse response = this.chat(request);
        return Response.from((Object)response.aiMessage(), (TokenUsage)response.tokenUsage(), (FinishReason)response.finishReason());
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        return this.generate(messages, Collections.singletonList(toolSpecification));
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        ChatRequest request = ChatRequest.builder().messages(messages).toolSpecifications(toolSpecifications).build();
        ChatResponse response = this.chat(request);
        return Response.from((Object)response.aiMessage(), (TokenUsage)response.tokenUsage(), (FinishReason)response.finishReason());
    }

    public ChatResponse chat(ChatRequest chatRequest) {
        GeminiGenerateContentResponse geminiResponse;
        ConcurrentHashMap listenerAttributes;
        ChatModelRequest chatModelRequest;
        block9: {
            GeminiContent systemInstruction = new GeminiContent(GeminiRole.MODEL.toString());
            List<GeminiContent> geminiContentList = PartsAndContentsMapper.fromMessageToGContent(chatRequest.messages(), systemInstruction);
            List toolSpecifications = chatRequest.toolSpecifications();
            ResponseFormat format = chatRequest.responseFormat() != null ? chatRequest.responseFormat() : this.responseFormat;
            GeminiSchema schema = null;
            String responseMimeType = GoogleAiGeminiChatModel.computeMimeType(format);
            if (format != null && format.jsonSchema() != null) {
                schema = SchemaMapper.fromJsonSchemaToGSchema(format.jsonSchema());
            }
            GeminiGenerateContentRequest request = GeminiGenerateContentRequest.builder().contents(geminiContentList).systemInstruction(!systemInstruction.getParts().isEmpty() ? systemInstruction : null).generationConfig(GeminiGenerationConfig.builder().candidateCount(this.candidateCount).maxOutputTokens(this.maxOutputTokens).responseMimeType(responseMimeType).responseSchema(schema).stopSequences(this.stopSequences).temperature(this.temperature).topK(this.topK).topP(this.topP).build()).safetySettings(this.safetySettings).tools(FunctionMapper.fromToolSepcsToGTool(toolSpecifications, this.allowCodeExecution)).toolConfig(new GeminiToolConfig(this.toolConfig)).build();
            chatModelRequest = ChatModelRequest.builder().model(this.modelName).temperature(this.temperature).topP(this.topP).maxTokens(this.maxOutputTokens).messages(chatRequest.messages()).toolSpecifications(chatRequest.toolSpecifications()).build();
            listenerAttributes = new ConcurrentHashMap();
            ChatModelRequestContext chatModelRequestContext = new ChatModelRequestContext(chatModelRequest, listenerAttributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onRequest(chatModelRequestContext);
                }
                catch (Exception e) {
                    log.warn("Exception while calling model listener (onRequest)", (Throwable)e);
                }
            });
            Call responseCall = (Call)RetryUtils.withRetry(() -> this.geminiService.generateContent(this.modelName, this.apiKey, request), (int)this.maxRetries);
            try {
                retrofit2.Response executed = responseCall.execute();
                geminiResponse = (GeminiGenerateContentResponse)executed.body();
                if (executed.code() < 300) break block9;
                ResponseBody errorBody = executed.errorBody();
                try {
                    GeminiError error = ((GeminiErrorContainer)GSON.fromJson(errorBody.string(), GeminiErrorContainer.class)).getError();
                    RuntimeException runtimeException = new RuntimeException(String.format("%s (code %d) %s", error.getStatus(), error.getCode(), error.getMessage()));
                    ChatModelErrorContext chatModelErrorContext = new ChatModelErrorContext((Throwable)runtimeException, chatModelRequest, null, listenerAttributes);
                    this.listeners.forEach(listener -> {
                        try {
                            listener.onError(chatModelErrorContext);
                        }
                        catch (Exception e) {
                            log.warn("Exception while calling model listener (onError)", (Throwable)e);
                        }
                    });
                    throw runtimeException;
                }
                catch (Throwable error) {
                    if (errorBody != null) {
                        try {
                            errorBody.close();
                        }
                        catch (Throwable runtimeException) {
                            error.addSuppressed(runtimeException);
                        }
                    }
                    throw error;
                }
            }
            catch (IOException e) {
                RuntimeException runtimeException = new RuntimeException("An error occurred when calling the Gemini API endpoint.", e);
                ChatModelErrorContext chatModelErrorContext = new ChatModelErrorContext((Throwable)e, chatModelRequest, null, listenerAttributes);
                this.listeners.forEach(listener -> {
                    try {
                        listener.onError(chatModelErrorContext);
                    }
                    catch (Exception ex) {
                        log.warn("Exception while calling model listener (onError)", (Throwable)ex);
                    }
                });
                throw runtimeException;
            }
        }
        if (geminiResponse != null) {
            GeminiCandidate firstCandidate = geminiResponse.getCandidates().get(0);
            GeminiUsageMetadata tokenCounts = geminiResponse.getUsageMetadata();
            FinishReason finishReason = FinishReasonMapper.fromGFinishReasonToFinishReason(firstCandidate.getFinishReason());
            AiMessage aiMessage = firstCandidate.getContent() == null ? AiMessage.from((String)("No text was returned by the model. The model finished generating because of the following reason: " + finishReason)) : PartsAndContentsMapper.fromGPartsToAiMessage(firstCandidate.getContent().getParts(), this.includeCodeExecutionOutput);
            TokenUsage tokenUsage = new TokenUsage(tokenCounts.getPromptTokenCount(), tokenCounts.getCandidatesTokenCount(), tokenCounts.getTotalTokenCount());
            ChatModelResponse chatModelResponse = ChatModelResponse.builder().model(this.modelName).tokenUsage(tokenUsage).finishReason(finishReason).aiMessage(aiMessage).build();
            ChatModelResponseContext chatModelResponseContext = new ChatModelResponseContext(chatModelResponse, chatModelRequest, listenerAttributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onResponse(chatModelResponseContext);
                }
                catch (Exception e) {
                    log.warn("Exception while calling model listener (onResponse)", (Throwable)e);
                }
            });
            return ChatResponse.builder().aiMessage(aiMessage).finishReason(finishReason).tokenUsage(tokenUsage).build();
        }
        throw new RuntimeException("Gemini response was null");
    }

    public int estimateTokenCount(List<ChatMessage> messages) {
        return this.geminiTokenizer.estimateTokenCountInMessages(messages);
    }

    public Set<Capability> supportedCapabilities() {
        HashSet<Capability> capabilities = new HashSet<Capability>();
        if (this.responseFormat != null && ResponseFormatType.JSON.equals((Object)this.responseFormat.type())) {
            capabilities.add(Capability.RESPONSE_FORMAT_JSON_SCHEMA);
        }
        return capabilities;
    }

    public static GoogleAiGeminiChatModelBuilder builder() {
        return new GoogleAiGeminiChatModelBuilder();
    }

    public static class GoogleAiGeminiChatModelBuilder {
        private String apiKey;
        private String modelName;
        private Integer maxRetries;
        private Double temperature;
        private Integer topK;
        private Double topP;
        private Integer maxOutputTokens;
        private Integer candidateCount;
        private Duration timeout;
        private ResponseFormat responseFormat;
        private List<String> stopSequences;
        private GeminiFunctionCallingConfig toolConfig;
        private Boolean allowCodeExecution;
        private Boolean includeCodeExecutionOutput;
        private Boolean logRequestsAndResponses;
        private List<GeminiSafetySetting> safetySettings;
        private List<ChatModelListener> listeners;

        public GoogleAiGeminiChatModelBuilder toolConfig(GeminiMode mode, String ... allowedFunctionNames) {
            this.toolConfig = new GeminiFunctionCallingConfig(mode, Arrays.asList(allowedFunctionNames));
            return this;
        }

        public GoogleAiGeminiChatModelBuilder safetySettings(Map<GeminiHarmCategory, GeminiHarmBlockThreshold> safetySettingMap) {
            this.safetySettings = safetySettingMap.entrySet().stream().map(entry -> new GeminiSafetySetting((GeminiHarmCategory)((Object)((Object)entry.getKey())), (GeminiHarmBlockThreshold)((Object)((Object)entry.getValue())))).collect(Collectors.toList());
            return this;
        }

        GoogleAiGeminiChatModelBuilder() {
        }

        public GoogleAiGeminiChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder candidateCount(Integer candidateCount) {
            this.candidateCount = candidateCount;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder allowCodeExecution(Boolean allowCodeExecution) {
            this.allowCodeExecution = allowCodeExecution;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder includeCodeExecutionOutput(Boolean includeCodeExecutionOutput) {
            this.includeCodeExecutionOutput = includeCodeExecutionOutput;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder logRequestsAndResponses(Boolean logRequestsAndResponses) {
            this.logRequestsAndResponses = logRequestsAndResponses;
            return this;
        }

        public GoogleAiGeminiChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public GoogleAiGeminiChatModel build() {
            return new GoogleAiGeminiChatModel(this.apiKey, this.modelName, this.maxRetries, this.temperature, this.topK, this.topP, this.maxOutputTokens, this.candidateCount, this.timeout, this.responseFormat, this.stopSequences, this.toolConfig, this.allowCodeExecution, this.includeCodeExecutionOutput, this.logRequestsAndResponses, this.safetySettings, this.listeners);
        }

        public String toString() {
            return "GoogleAiGeminiChatModel.GoogleAiGeminiChatModelBuilder(apiKey=" + this.apiKey + ", modelName=" + this.modelName + ", maxRetries=" + this.maxRetries + ", temperature=" + this.temperature + ", topK=" + this.topK + ", topP=" + this.topP + ", maxOutputTokens=" + this.maxOutputTokens + ", candidateCount=" + this.candidateCount + ", timeout=" + this.timeout + ", responseFormat=" + this.responseFormat + ", stopSequences=" + this.stopSequences + ", toolConfig=" + this.toolConfig + ", allowCodeExecution=" + this.allowCodeExecution + ", includeCodeExecutionOutput=" + this.includeCodeExecutionOutput + ", logRequestsAndResponses=" + this.logRequestsAndResponses + ", safetySettings=" + this.safetySettings + ", listeners=" + this.listeners + ")";
        }
    }
}

