/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.Experimental;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.googleai.GeminiContent;
import dev.langchain4j.model.googleai.GeminiPart;
import dev.langchain4j.model.googleai.GeminiService;
import dev.langchain4j.model.googleai.GoogleAiBatchEmbeddingRequest;
import dev.langchain4j.model.googleai.GoogleAiBatchEmbeddingResponse;
import dev.langchain4j.model.googleai.GoogleAiEmbeddingRequest;
import dev.langchain4j.model.googleai.GoogleAiEmbeddingResponse;
import dev.langchain4j.model.output.Response;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class GoogleAiEmbeddingModel
implements EmbeddingModel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GoogleAiEmbeddingModel.class);
    private static final int MAX_NUMBER_OF_SEGMENTS_PER_BATCH = 100;
    private final GeminiService geminiService;
    private final String modelName;
    private final String apiKey;
    private final Integer maxRetries;
    private final TaskType taskType;
    private final String titleMetadataKey;
    private final Integer outputDimensionality;

    public GoogleAiEmbeddingModel(String modelName, String apiKey, Integer maxRetries, TaskType taskType, String titleMetadataKey, Integer outputDimensionality, Duration timeout, Boolean logRequestsAndResponses) {
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.apiKey = ValidationUtils.ensureNotBlank((String)apiKey, (String)"apiKey");
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.taskType = taskType;
        this.titleMetadataKey = (String)Utils.getOrDefault((Object)titleMetadataKey, (Object)"title");
        this.outputDimensionality = outputDimensionality;
        Duration timeout1 = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        boolean logRequestsAndResponses1 = logRequestsAndResponses != null && logRequestsAndResponses != false;
        this.geminiService = new GeminiService((Logger)(logRequestsAndResponses1 ? log : null), timeout1);
    }

    public Response<Embedding> embed(TextSegment textSegment) {
        GoogleAiEmbeddingRequest embeddingRequest = this.getGoogleAiEmbeddingRequest(textSegment);
        GoogleAiEmbeddingResponse geminiResponse = (GoogleAiEmbeddingResponse)RetryUtils.withRetry(() -> this.geminiService.embed(this.modelName, this.apiKey, embeddingRequest), (int)this.maxRetries);
        if (geminiResponse != null) {
            return Response.from((Object)Embedding.from(geminiResponse.getEmbedding().getValues()));
        }
        throw new RuntimeException("Gemini embedding response was null (embed)");
    }

    public Response<Embedding> embed(String text) {
        return this.embed(TextSegment.from((String)text));
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        List embeddingRequests = textSegments.stream().map(this::getGoogleAiEmbeddingRequest).collect(Collectors.toList());
        ArrayList allEmbeddings = new ArrayList();
        int numberOfEmbeddings = embeddingRequests.size();
        int numberOfBatches = 1 + numberOfEmbeddings / 100;
        for (int i = 0; i < numberOfBatches; ++i) {
            int startIndex = 100 * i;
            int lastIndex = Math.min(startIndex + 100, numberOfEmbeddings);
            if (startIndex >= numberOfEmbeddings) break;
            GoogleAiBatchEmbeddingRequest batchEmbeddingRequest = new GoogleAiBatchEmbeddingRequest();
            batchEmbeddingRequest.setRequests(embeddingRequests.subList(startIndex, lastIndex));
            GoogleAiBatchEmbeddingResponse geminiResponse = (GoogleAiBatchEmbeddingResponse)RetryUtils.withRetry(() -> this.geminiService.batchEmbed(this.modelName, this.apiKey, batchEmbeddingRequest));
            if (geminiResponse == null) {
                throw new RuntimeException("Gemini embedding response was null (embedAll)");
            }
            allEmbeddings.addAll(geminiResponse.getEmbeddings().stream().map(values -> Embedding.from(values.getValues())).collect(Collectors.toList()));
        }
        return Response.from(allEmbeddings);
    }

    private GoogleAiEmbeddingRequest getGoogleAiEmbeddingRequest(TextSegment textSegment) {
        GeminiPart geminiPart = GeminiPart.builder().text(textSegment.text()).build();
        GeminiContent content = new GeminiContent(Collections.singletonList(geminiPart), null);
        String title = null;
        if (TaskType.RETRIEVAL_DOCUMENT.equals((Object)this.taskType) && textSegment.metadata() != null && textSegment.metadata().getString(this.titleMetadataKey) != null) {
            title = textSegment.metadata().getString(this.titleMetadataKey);
        }
        return new GoogleAiEmbeddingRequest("models/" + this.modelName, content, this.taskType, title, this.outputDimensionality);
    }

    public int dimension() {
        return (Integer)Utils.getOrDefault((Object)this.outputDimensionality, (Object)768);
    }

    @Generated
    public static GoogleAiEmbeddingModelBuilder builder() {
        return new GoogleAiEmbeddingModelBuilder();
    }

    public static enum TaskType {
        RETRIEVAL_QUERY,
        RETRIEVAL_DOCUMENT,
        SEMANTIC_SIMILARITY,
        CLASSIFICATION,
        CLUSTERING,
        QUESTION_ANSWERING,
        FACT_VERIFICATION;

    }

    @Generated
    public static class GoogleAiEmbeddingModelBuilder {
        @Generated
        private String modelName;
        @Generated
        private String apiKey;
        @Generated
        private Integer maxRetries;
        @Generated
        private TaskType taskType;
        @Generated
        private String titleMetadataKey;
        @Generated
        private Integer outputDimensionality;
        @Generated
        private Duration timeout;
        @Generated
        private Boolean logRequestsAndResponses;

        @Generated
        GoogleAiEmbeddingModelBuilder() {
        }

        @Generated
        public GoogleAiEmbeddingModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @Generated
        public GoogleAiEmbeddingModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public GoogleAiEmbeddingModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Generated
        public GoogleAiEmbeddingModelBuilder taskType(TaskType taskType) {
            this.taskType = taskType;
            return this;
        }

        @Generated
        public GoogleAiEmbeddingModelBuilder titleMetadataKey(String titleMetadataKey) {
            this.titleMetadataKey = titleMetadataKey;
            return this;
        }

        @Generated
        public GoogleAiEmbeddingModelBuilder outputDimensionality(Integer outputDimensionality) {
            this.outputDimensionality = outputDimensionality;
            return this;
        }

        @Generated
        public GoogleAiEmbeddingModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public GoogleAiEmbeddingModelBuilder logRequestsAndResponses(Boolean logRequestsAndResponses) {
            this.logRequestsAndResponses = logRequestsAndResponses;
            return this;
        }

        @Generated
        public GoogleAiEmbeddingModel build() {
            return new GoogleAiEmbeddingModel(this.modelName, this.apiKey, this.maxRetries, this.taskType, this.titleMetadataKey, this.outputDimensionality, this.timeout, this.logRequestsAndResponses);
        }

        @Generated
        public String toString() {
            return "GoogleAiEmbeddingModel.GoogleAiEmbeddingModelBuilder(modelName=" + this.modelName + ", apiKey=" + this.apiKey + ", maxRetries=" + this.maxRetries + ", taskType=" + String.valueOf((Object)this.taskType) + ", titleMetadataKey=" + this.titleMetadataKey + ", outputDimensionality=" + this.outputDimensionality + ", timeout=" + String.valueOf(this.timeout) + ", logRequestsAndResponses=" + this.logRequestsAndResponses + ")";
        }
    }
}

