/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.model.googleai.GeminiSchema;
import java.util.List;

class GeminiGenerationConfig {
    private List<String> stopSequences;
    private String responseMimeType;
    private GeminiSchema responseSchema;
    private Integer candidateCount = 1;
    private Integer maxOutputTokens = 8192;
    private Double temperature = 1.0;
    private Integer topK = 64;
    private Double topP = 0.95;

    GeminiGenerationConfig(List<String> stopSequences, String responseMimeType, GeminiSchema responseSchema, Integer candidateCount, Integer maxOutputTokens, Double temperature, Integer topK, Double topP) {
        this.stopSequences = stopSequences;
        this.responseMimeType = responseMimeType;
        this.responseSchema = responseSchema;
        this.candidateCount = candidateCount;
        this.maxOutputTokens = maxOutputTokens;
        this.temperature = temperature;
        this.topK = topK;
        this.topP = topP;
    }

    public static GeminiGenerationConfigBuilder builder() {
        return new GeminiGenerationConfigBuilder();
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public String getResponseMimeType() {
        return this.responseMimeType;
    }

    public GeminiSchema getResponseSchema() {
        return this.responseSchema;
    }

    public Integer getCandidateCount() {
        return this.candidateCount;
    }

    public Integer getMaxOutputTokens() {
        return this.maxOutputTokens;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    public void setResponseMimeType(String responseMimeType) {
        this.responseMimeType = responseMimeType;
    }

    public void setResponseSchema(GeminiSchema responseSchema) {
        this.responseSchema = responseSchema;
    }

    public void setCandidateCount(Integer candidateCount) {
        this.candidateCount = candidateCount;
    }

    public void setMaxOutputTokens(Integer maxOutputTokens) {
        this.maxOutputTokens = maxOutputTokens;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeminiGenerationConfig)) {
            return false;
        }
        GeminiGenerationConfig other = (GeminiGenerationConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$stopSequences = this.getStopSequences();
        List<String> other$stopSequences = other.getStopSequences();
        if (this$stopSequences == null ? other$stopSequences != null : !((Object)this$stopSequences).equals(other$stopSequences)) {
            return false;
        }
        String this$responseMimeType = this.getResponseMimeType();
        String other$responseMimeType = other.getResponseMimeType();
        if (this$responseMimeType == null ? other$responseMimeType != null : !this$responseMimeType.equals(other$responseMimeType)) {
            return false;
        }
        GeminiSchema this$responseSchema = this.getResponseSchema();
        GeminiSchema other$responseSchema = other.getResponseSchema();
        if (this$responseSchema == null ? other$responseSchema != null : !((Object)this$responseSchema).equals(other$responseSchema)) {
            return false;
        }
        Integer this$candidateCount = this.getCandidateCount();
        Integer other$candidateCount = other.getCandidateCount();
        if (this$candidateCount == null ? other$candidateCount != null : !((Object)this$candidateCount).equals(other$candidateCount)) {
            return false;
        }
        Integer this$maxOutputTokens = this.getMaxOutputTokens();
        Integer other$maxOutputTokens = other.getMaxOutputTokens();
        if (this$maxOutputTokens == null ? other$maxOutputTokens != null : !((Object)this$maxOutputTokens).equals(other$maxOutputTokens)) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Integer this$topK = this.getTopK();
        Integer other$topK = other.getTopK();
        if (this$topK == null ? other$topK != null : !((Object)this$topK).equals(other$topK)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        return !(this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeminiGenerationConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $stopSequences = this.getStopSequences();
        result = result * 59 + ($stopSequences == null ? 43 : ((Object)$stopSequences).hashCode());
        String $responseMimeType = this.getResponseMimeType();
        result = result * 59 + ($responseMimeType == null ? 43 : $responseMimeType.hashCode());
        GeminiSchema $responseSchema = this.getResponseSchema();
        result = result * 59 + ($responseSchema == null ? 43 : ((Object)$responseSchema).hashCode());
        Integer $candidateCount = this.getCandidateCount();
        result = result * 59 + ($candidateCount == null ? 43 : ((Object)$candidateCount).hashCode());
        Integer $maxOutputTokens = this.getMaxOutputTokens();
        result = result * 59 + ($maxOutputTokens == null ? 43 : ((Object)$maxOutputTokens).hashCode());
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Integer $topK = this.getTopK();
        result = result * 59 + ($topK == null ? 43 : ((Object)$topK).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        return result;
    }

    public String toString() {
        return "GeminiGenerationConfig(stopSequences=" + String.valueOf(this.getStopSequences()) + ", responseMimeType=" + this.getResponseMimeType() + ", responseSchema=" + String.valueOf(this.getResponseSchema()) + ", candidateCount=" + this.getCandidateCount() + ", maxOutputTokens=" + this.getMaxOutputTokens() + ", temperature=" + this.getTemperature() + ", topK=" + this.getTopK() + ", topP=" + this.getTopP() + ")";
    }

    public static class GeminiGenerationConfigBuilder {
        private List<String> stopSequences;
        private String responseMimeType;
        private GeminiSchema responseSchema;
        private Integer candidateCount;
        private Integer maxOutputTokens;
        private Double temperature;
        private Integer topK;
        private Double topP;

        GeminiGenerationConfigBuilder() {
        }

        public GeminiGenerationConfigBuilder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        public GeminiGenerationConfigBuilder responseMimeType(String responseMimeType) {
            this.responseMimeType = responseMimeType;
            return this;
        }

        public GeminiGenerationConfigBuilder responseSchema(GeminiSchema responseSchema) {
            this.responseSchema = responseSchema;
            return this;
        }

        public GeminiGenerationConfigBuilder candidateCount(Integer candidateCount) {
            this.candidateCount = candidateCount;
            return this;
        }

        public GeminiGenerationConfigBuilder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        public GeminiGenerationConfigBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public GeminiGenerationConfigBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public GeminiGenerationConfigBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public GeminiGenerationConfig build() {
            return new GeminiGenerationConfig(this.stopSequences, this.responseMimeType, this.responseSchema, this.candidateCount, this.maxOutputTokens, this.temperature, this.topK, this.topP);
        }

        public String toString() {
            return "GeminiGenerationConfig.GeminiGenerationConfigBuilder(stopSequences=" + String.valueOf(this.stopSequences) + ", responseMimeType=" + this.responseMimeType + ", responseSchema=" + String.valueOf(this.responseSchema) + ", candidateCount=" + this.candidateCount + ", maxOutputTokens=" + this.maxOutputTokens + ", temperature=" + this.temperature + ", topK=" + this.topK + ", topP=" + this.topP + ")";
        }
    }
}

