/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.request.json.JsonEnumSchema;
import dev.langchain4j.model.googleai.FunctionMapper;
import dev.langchain4j.model.googleai.GeminiContent;
import dev.langchain4j.model.googleai.GeminiFunctionCallingConfig;
import dev.langchain4j.model.googleai.GeminiGenerateContentRequest;
import dev.langchain4j.model.googleai.GeminiGenerationConfig;
import dev.langchain4j.model.googleai.GeminiMode;
import dev.langchain4j.model.googleai.GeminiRole;
import dev.langchain4j.model.googleai.GeminiSafetySetting;
import dev.langchain4j.model.googleai.GeminiSchema;
import dev.langchain4j.model.googleai.GeminiService;
import dev.langchain4j.model.googleai.GeminiThinkingConfig;
import dev.langchain4j.model.googleai.GeminiToolConfig;
import dev.langchain4j.model.googleai.PartsAndContentsMapper;
import dev.langchain4j.model.googleai.SchemaMapper;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

abstract class BaseGeminiChatModel {
    protected final GeminiService geminiService;
    protected final String apiKey;
    protected final GeminiFunctionCallingConfig functionCallingConfig;
    protected final boolean allowCodeExecution;
    protected final boolean includeCodeExecutionOutput;
    protected final List<GeminiSafetySetting> safetySettings;
    protected final List<ChatModelListener> listeners;
    protected final Integer maxRetries;
    protected final GeminiThinkingConfig thinkingConfig;
    protected final Integer seed;
    protected final ChatRequestParameters defaultRequestParameters;

    protected BaseGeminiChatModel(HttpClientBuilder httpClientBuilder, String apiKey, String modelName, Double temperature, Integer topK, Integer seed, Double topP, Double frequencyPenalty, Double presencePenalty, Integer maxOutputTokens, Duration timeout, ResponseFormat responseFormat, List<String> stopSequences, GeminiFunctionCallingConfig functionCallingConfig, Boolean allowCodeExecution, Boolean includeCodeExecutionOutput, Boolean logRequestsAndResponses, List<GeminiSafetySetting> safetySettings, List<ChatModelListener> listeners, Integer maxRetries, GeminiThinkingConfig thinkingConfig, ChatRequestParameters defaultRequestParameters) {
        this.apiKey = ValidationUtils.ensureNotBlank((String)apiKey, (String)"apiKey");
        this.functionCallingConfig = functionCallingConfig;
        this.allowCodeExecution = (Boolean)Utils.getOrDefault((Object)allowCodeExecution, (Object)false);
        this.includeCodeExecutionOutput = (Boolean)Utils.getOrDefault((Object)includeCodeExecutionOutput, (Object)false);
        this.safetySettings = Utils.copyIfNotNull(safetySettings);
        this.listeners = Utils.copy(listeners);
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)2);
        this.thinkingConfig = thinkingConfig;
        this.seed = seed;
        this.geminiService = new GeminiService(httpClientBuilder, (Boolean)Utils.getOrDefault((Object)logRequestsAndResponses, (Object)false), timeout);
        ChatRequestParameters parameters = defaultRequestParameters != null ? defaultRequestParameters : DefaultChatRequestParameters.EMPTY;
        this.defaultRequestParameters = ChatRequestParameters.builder().modelName((String)Utils.getOrDefault((Object)modelName, (Object)parameters.modelName())).temperature((Double)Utils.getOrDefault((Object)temperature, (Object)parameters.temperature())).topP((Double)Utils.getOrDefault((Object)topP, (Object)parameters.topP())).topK((Integer)Utils.getOrDefault((Object)topK, (Object)parameters.topK())).frequencyPenalty((Double)Utils.getOrDefault((Object)frequencyPenalty, (Object)parameters.frequencyPenalty())).presencePenalty((Double)Utils.getOrDefault((Object)presencePenalty, (Object)parameters.presencePenalty())).maxOutputTokens((Integer)Utils.getOrDefault((Object)maxOutputTokens, (Object)parameters.maxOutputTokens())).stopSequences(Utils.getOrDefault(stopSequences, (List)parameters.stopSequences())).toolSpecifications(parameters.toolSpecifications()).toolChoice((ToolChoice)Utils.getOrDefault((Object)BaseGeminiChatModel.toToolChoice(functionCallingConfig), (Object)parameters.toolChoice())).responseFormat((ResponseFormat)Utils.getOrDefault((Object)responseFormat, (Object)parameters.responseFormat())).build();
    }

    protected GeminiGenerateContentRequest createGenerateContentRequest(ChatRequest chatRequest) {
        ChatRequestParameters parameters = chatRequest.parameters();
        GeminiContent systemInstruction = new GeminiContent(GeminiRole.MODEL.toString());
        List<GeminiContent> geminiContentList = PartsAndContentsMapper.fromMessageToGContent(chatRequest.messages(), systemInstruction);
        ResponseFormat responseFormat = chatRequest.responseFormat();
        GeminiSchema schema = null;
        if (responseFormat != null && responseFormat.jsonSchema() != null) {
            schema = SchemaMapper.fromJsonSchemaToGSchema(responseFormat.jsonSchema());
        }
        return GeminiGenerateContentRequest.builder().model(chatRequest.modelName()).contents(geminiContentList).systemInstruction(!systemInstruction.getParts().isEmpty() ? systemInstruction : null).generationConfig(GeminiGenerationConfig.builder().candidateCount(1).maxOutputTokens(parameters.maxOutputTokens()).responseMimeType(BaseGeminiChatModel.computeMimeType(responseFormat)).responseSchema(schema).stopSequences(parameters.stopSequences()).temperature(parameters.temperature()).topK(parameters.topK()).seed(this.seed).topP(parameters.topP()).presencePenalty(parameters.presencePenalty()).frequencyPenalty(parameters.frequencyPenalty()).thinkingConfig(this.thinkingConfig).build()).safetySettings(this.safetySettings).tools(FunctionMapper.fromToolSepcsToGTool(chatRequest.toolSpecifications(), this.allowCodeExecution)).toolConfig(this.toToolConfig(parameters.toolChoice(), this.functionCallingConfig)).build();
    }

    private GeminiToolConfig toToolConfig(ToolChoice toolChoice, GeminiFunctionCallingConfig functionCallingConfig) {
        if (toolChoice == null && functionCallingConfig == null) {
            return null;
        }
        GeminiMode geminiMode = Optional.ofNullable(functionCallingConfig).map(GeminiFunctionCallingConfig::getMode).orElse(null);
        List allowedFunctionNames = Optional.ofNullable(functionCallingConfig).map(GeminiFunctionCallingConfig::getAllowedFunctionNames).orElse(null);
        if (toolChoice != null) {
            geminiMode = BaseGeminiChatModel.toGeminiMode(toolChoice);
        }
        return new GeminiToolConfig(new GeminiFunctionCallingConfig(geminiMode, allowedFunctionNames));
    }

    protected static String computeMimeType(ResponseFormat responseFormat) {
        if (responseFormat == null || ResponseFormatType.TEXT.equals((Object)responseFormat.type())) {
            return "text/plain";
        }
        if (ResponseFormatType.JSON.equals((Object)responseFormat.type()) && responseFormat.jsonSchema() != null && responseFormat.jsonSchema().rootElement() != null && responseFormat.jsonSchema().rootElement() instanceof JsonEnumSchema) {
            return "text/x.enum";
        }
        return "application/json";
    }

    private static GeminiMode toGeminiMode(ToolChoice toolChoice) {
        return switch (toolChoice) {
            default -> throw new IncompatibleClassChangeError();
            case ToolChoice.AUTO -> GeminiMode.AUTO;
            case ToolChoice.REQUIRED -> GeminiMode.ANY;
        };
    }

    private static ToolChoice toToolChoice(GeminiFunctionCallingConfig config) {
        if (config == null || config.getMode() == null) {
            return null;
        }
        return switch (config.getMode()) {
            default -> throw new IncompatibleClassChangeError();
            case GeminiMode.AUTO -> ToolChoice.AUTO;
            case GeminiMode.ANY -> ToolChoice.REQUIRED;
            case GeminiMode.NONE -> null;
        };
    }
}

