/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.HttpClientBuilderLoader;
import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.log.LoggingHttpClient;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.internal.ExceptionMapper;
import dev.langchain4j.internal.InternalStreamingChatResponseHandlerUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.googleai.GeminiCountTokensRequest;
import dev.langchain4j.model.googleai.GeminiCountTokensResponse;
import dev.langchain4j.model.googleai.GeminiGenerateContentRequest;
import dev.langchain4j.model.googleai.GeminiGenerateContentResponse;
import dev.langchain4j.model.googleai.GeminiStreamingResponseBuilder;
import dev.langchain4j.model.googleai.GoogleAiBatchEmbeddingRequest;
import dev.langchain4j.model.googleai.GoogleAiBatchEmbeddingResponse;
import dev.langchain4j.model.googleai.GoogleAiEmbeddingRequest;
import dev.langchain4j.model.googleai.GoogleAiEmbeddingResponse;
import dev.langchain4j.model.googleai.Json;
import java.time.Duration;
import java.util.Optional;

class GeminiService {
    private static final String GEMINI_AI_ENDPOINT = "https://generativelanguage.googleapis.com/v1beta";
    private static final String API_KEY_HEADER_NAME = "x-goog-api-key";
    private final HttpClient httpClient;

    GeminiService(HttpClientBuilder httpClientBuilder, boolean logRequestsAndResponses, Duration timeout) {
        httpClientBuilder = (HttpClientBuilder)Utils.getOrDefault((Object)httpClientBuilder, HttpClientBuilderLoader::loadHttpClientBuilder);
        HttpClient httpClient = httpClientBuilder.connectTimeout((Duration)Utils.getOrDefault((Object)((Duration)Utils.getOrDefault((Object)timeout, (Object)httpClientBuilder.connectTimeout())), (Object)Duration.ofSeconds(15L))).readTimeout((Duration)Utils.getOrDefault((Object)((Duration)Utils.getOrDefault((Object)timeout, (Object)httpClientBuilder.readTimeout())), (Object)Duration.ofSeconds(60L))).build();
        this.httpClient = logRequestsAndResponses ? new LoggingHttpClient(httpClient, Boolean.valueOf(true), Boolean.valueOf(true)) : httpClient;
    }

    GeminiGenerateContentResponse generateContent(String modelName, String apiKey, GeminiGenerateContentRequest request) {
        String url = String.format("%s/models/%s:generateContent", GEMINI_AI_ENDPOINT, modelName);
        return this.sendRequest(url, apiKey, request, GeminiGenerateContentResponse.class);
    }

    GeminiCountTokensResponse countTokens(String modelName, String apiKey, GeminiCountTokensRequest request) {
        String url = String.format("%s/models/%s:countTokens", GEMINI_AI_ENDPOINT, modelName);
        return this.sendRequest(url, apiKey, request, GeminiCountTokensResponse.class);
    }

    GoogleAiEmbeddingResponse embed(String modelName, String apiKey, GoogleAiEmbeddingRequest request) {
        String url = String.format("%s/models/%s:embedContent", GEMINI_AI_ENDPOINT, modelName);
        return this.sendRequest(url, apiKey, request, GoogleAiEmbeddingResponse.class);
    }

    GoogleAiBatchEmbeddingResponse batchEmbed(String modelName, String apiKey, GoogleAiBatchEmbeddingRequest request) {
        String url = String.format("%s/models/%s:batchEmbedContents", GEMINI_AI_ENDPOINT, modelName);
        return this.sendRequest(url, apiKey, request, GoogleAiBatchEmbeddingResponse.class);
    }

    void generateContentStream(String modelName, String apiKey, GeminiGenerateContentRequest request, boolean includeCodeExecutionOutput, StreamingChatResponseHandler handler) {
        String url = String.format("%s/models/%s:streamGenerateContent?alt=sse", GEMINI_AI_ENDPOINT, modelName);
        this.streamRequest(url, apiKey, request, includeCodeExecutionOutput, handler);
    }

    private <T> T sendRequest(String url, String apiKey, Object requestBody, Class<T> responseType) {
        String jsonBody = Json.toJson(requestBody);
        HttpRequest request = this.buildHttpRequest(url, apiKey, jsonBody);
        SuccessfulHttpResponse response = this.httpClient.execute(request);
        return Json.fromJson(response.body(), responseType);
    }

    private void streamRequest(String url, String apiKey, Object requestBody, boolean includeCodeExecutionOutput, final StreamingChatResponseHandler handler) {
        String jsonBody = Json.toJson(requestBody);
        HttpRequest httpRequest = this.buildHttpRequest(url, apiKey, jsonBody);
        final GeminiStreamingResponseBuilder responseBuilder = new GeminiStreamingResponseBuilder(includeCodeExecutionOutput);
        this.httpClient.execute(httpRequest, new ServerSentEventListener(){

            public void onEvent(ServerSentEvent event) {
                GeminiGenerateContentResponse response = Json.fromJson(event.data(), GeminiGenerateContentResponse.class);
                Optional<String> maybeText = responseBuilder.append(response);
                maybeText.ifPresent(text -> {
                    try {
                        handler.onPartialResponse(text);
                    }
                    catch (Exception e) {
                        InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)e));
                    }
                });
            }

            public void onClose() {
                ChatResponse chatResponse = responseBuilder.build();
                try {
                    handler.onCompleteResponse(chatResponse);
                }
                catch (Exception e) {
                    InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)e));
                }
            }

            public void onError(Throwable error) {
                RuntimeException mappedError = ExceptionMapper.DEFAULT.mapException(error);
                InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)mappedError));
            }
        });
    }

    private HttpRequest buildHttpRequest(String url, String apiKey, String jsonBody) {
        return HttpRequest.builder().method(HttpMethod.POST).url(url).addHeader("Content-Type", new String[]{"application/json"}).addHeader("User-Agent", new String[]{"LangChain4j"}).addHeader(API_KEY_HEADER_NAME, new String[]{apiKey}).body(jsonBody).build();
    }
}

