/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.AudioContent;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.PdfFileContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.message.VideoContent;
import dev.langchain4j.data.pdf.PdfFile;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.CustomMimeTypesFileTypeDetector;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.googleai.FunctionMapper;
import dev.langchain4j.model.googleai.GeminiBlob;
import dev.langchain4j.model.googleai.GeminiCodeExecutionResult;
import dev.langchain4j.model.googleai.GeminiContent;
import dev.langchain4j.model.googleai.GeminiExecutableCode;
import dev.langchain4j.model.googleai.GeminiFileData;
import dev.langchain4j.model.googleai.GeminiFunctionCall;
import dev.langchain4j.model.googleai.GeminiFunctionResponse;
import dev.langchain4j.model.googleai.GeminiOutcome;
import dev.langchain4j.model.googleai.GeminiPart;
import dev.langchain4j.model.googleai.GeminiRole;
import dev.langchain4j.model.googleai.Json;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class PartsAndContentsMapper {
    static final String THINKING_SIGNATURE_KEY = "thinking_signature";
    private static final CustomMimeTypesFileTypeDetector mimeTypeDetector = new CustomMimeTypesFileTypeDetector();

    PartsAndContentsMapper() {
    }

    static GeminiPart fromContentToGPart(Content content) {
        if (content instanceof TextContent) {
            TextContent textContent = (TextContent)content;
            return GeminiPart.builder().text(textContent.text()).build();
        }
        if (content instanceof ImageContent) {
            ImageContent imageContent = (ImageContent)content;
            Image image = imageContent.image();
            if (!Utils.isNullOrBlank((String)image.base64Data())) {
                return GeminiPart.builder().inlineData(GeminiBlob.builder().mimeType(image.mimeType()).data(image.base64Data()).build()).build();
            }
            if (image.url() != null) {
                URI url = image.url();
                if (url.getScheme() != null && url.getScheme().startsWith("http")) {
                    byte[] imageBytes = Utils.readBytes((String)url.toString());
                    String base64Data = Base64.getEncoder().encodeToString(imageBytes);
                    return GeminiPart.builder().inlineData(GeminiBlob.builder().mimeType((String)Utils.getOrDefault((Object)image.mimeType(), (Object)mimeTypeDetector.probeContentType(url))).data(base64Data).build()).build();
                }
                return GeminiPart.builder().fileData(GeminiFileData.builder().fileUri(url.toString()).mimeType((String)Utils.getOrDefault((Object)image.mimeType(), (Object)mimeTypeDetector.probeContentType(url))).build()).build();
            }
            throw new IllegalArgumentException("Image should contain either base64 data or url");
        }
        if (content instanceof AudioContent) {
            AudioContent audioContent = (AudioContent)content;
            URI uri = audioContent.audio().url();
            if (uri != null) {
                return GeminiPart.builder().fileData(GeminiFileData.builder().fileUri(uri.toString()).mimeType(mimeTypeDetector.probeContentType(uri)).build()).build();
            }
            return GeminiPart.builder().inlineData(GeminiBlob.builder().mimeType(audioContent.audio().mimeType()).data(audioContent.audio().base64Data()).build()).build();
        }
        if (content instanceof VideoContent) {
            VideoContent videoContent = (VideoContent)content;
            URI uri = videoContent.video().url();
            if (uri != null) {
                return GeminiPart.builder().fileData(GeminiFileData.builder().fileUri(uri.toString()).mimeType(mimeTypeDetector.probeContentType(uri)).build()).build();
            }
            return GeminiPart.builder().inlineData(GeminiBlob.builder().mimeType(videoContent.video().mimeType()).data(videoContent.video().base64Data()).build()).build();
        }
        if (content instanceof PdfFileContent) {
            PdfFileContent pdfFileContent = (PdfFileContent)content;
            PdfFile pdfFile = pdfFileContent.pdfFile();
            URI uri = pdfFile.url();
            if (uri != null) {
                return GeminiPart.builder().fileData(GeminiFileData.builder().fileUri(uri.toString()).mimeType(mimeTypeDetector.probeContentType(uri)).build()).build();
            }
            return GeminiPart.builder().inlineData(GeminiBlob.builder().mimeType(pdfFile.mimeType()).data(pdfFile.base64Data()).build()).build();
        }
        throw new UnsupportedFeatureException("Unsupported content type: " + String.valueOf(content.type()));
    }

    static AiMessage fromGPartsToAiMessage(List<GeminiPart> parts, boolean includeCodeExecutionOutput, Boolean returnThinking) {
        List<GeminiPart> safeParts = Objects.requireNonNullElse(parts, List.of());
        StringBuilder fullText = new StringBuilder();
        ArrayList<String> thoughts = new ArrayList<String>();
        ArrayList<String> thoughtSignatures = new ArrayList<String>();
        ArrayList<GeminiFunctionCall> functionCalls = new ArrayList<GeminiFunctionCall>();
        for (GeminiPart part : safeParts) {
            String text;
            GeminiCodeExecutionResult codeExecutionResult;
            GeminiExecutableCode executableCode = part.getExecutableCode();
            if (executableCode != null && includeCodeExecutionOutput) {
                fullText.append("Code executed:\n").append("```python").append(executableCode.getProgrammingLanguage() != null ? executableCode.getProgrammingLanguage().toString() : "").append(executableCode.getCode()).append("```\n");
            }
            if ((codeExecutionResult = part.getCodeExecutionResult()) != null && includeCodeExecutionOutput) {
                GeminiOutcome outcome = codeExecutionResult.getOutcome();
                if (outcome != GeminiOutcome.OUTCOME_OK) {
                    fullText.append("Code execution failed: **").append(outcome.name()).append("**\n").append(part.getText() != null ? part.getText() : "");
                } else {
                    fullText.append("Output:\n").append("```\n").append(codeExecutionResult.getOutput()).append("```\n");
                }
            }
            if (Utils.isNotNullOrEmpty((String)(text = part.getText()))) {
                if (Boolean.TRUE.equals(part.isThought())) {
                    if (Boolean.TRUE.equals(returnThinking)) {
                        thoughts.add(text);
                    } else if (returnThinking == null) {
                        if (!fullText.isEmpty()) {
                            fullText.append("\n\n");
                        }
                        fullText.append(text);
                    }
                } else {
                    if (!fullText.isEmpty()) {
                        fullText.append("\n\n");
                    }
                    fullText.append(text);
                }
            }
            String thoughtSignature = part.getThoughtSignature();
            if (Boolean.TRUE.equals(returnThinking) && Utils.isNotNullOrEmpty((String)thoughtSignature)) {
                thoughtSignatures.add(thoughtSignature);
            }
            if (part.getFunctionCall() == null) continue;
            functionCalls.add(part.getFunctionCall());
        }
        String text = fullText.toString();
        String thinking = thoughts.stream().collect(Collectors.joining("\n\n"));
        String thinkingSignature = thoughtSignatures.stream().collect(Collectors.joining("\n\n"));
        return AiMessage.builder().text(Utils.isNullOrEmpty((String)text) ? null : text).thinking(Utils.isNullOrEmpty((String)thinking) ? null : thinking).toolExecutionRequests(FunctionMapper.toToolExecutionRequests(functionCalls)).attributes(Utils.isNullOrEmpty((String)thinkingSignature) ? null : Map.of(THINKING_SIGNATURE_KEY, thinkingSignature)).build();
    }

    static List<GeminiContent> fromMessageToGContent(List<ChatMessage> messages, GeminiContent systemInstruction, boolean sendThinking) {
        return messages.stream().map(msg -> {
            switch (msg.type()) {
                case SYSTEM: {
                    SystemMessage systemMessage = (SystemMessage)msg;
                    if (systemInstruction != null) {
                        systemInstruction.addPart(GeminiPart.builder().text(systemMessage.text()).build());
                    }
                    return null;
                }
                case AI: {
                    AiMessage aiMessage = (AiMessage)msg;
                    ArrayList<GeminiPart> parts = new ArrayList<GeminiPart>();
                    if (sendThinking && Utils.isNotNullOrEmpty((String)aiMessage.thinking())) {
                        parts.add(GeminiPart.builder().text(aiMessage.thinking()).thought(true).build());
                    }
                    if (Utils.isNotNullOrEmpty((String)aiMessage.text())) {
                        parts.add(GeminiPart.builder().text(aiMessage.text()).build());
                    }
                    if (aiMessage.hasToolExecutionRequests()) {
                        String thoughtSignature = null;
                        if (sendThinking) {
                            thoughtSignature = (String)aiMessage.attribute(THINKING_SIGNATURE_KEY, String.class);
                        }
                        parts.addAll(PartsAndContentsMapper.toGeminiParts(aiMessage.toolExecutionRequests(), thoughtSignature));
                    }
                    return GeminiContent.builder().role(GeminiRole.MODEL.toString()).parts(parts).build();
                }
                case USER: {
                    UserMessage userMessage = (UserMessage)msg;
                    return GeminiContent.builder().role(GeminiRole.USER.toString()).parts(userMessage.contents().stream().map(PartsAndContentsMapper::fromContentToGPart).collect(Collectors.toList())).build();
                }
                case TOOL_EXECUTION_RESULT: {
                    ToolExecutionResultMessage toolResultMessage = (ToolExecutionResultMessage)msg;
                    return GeminiContent.builder().role(GeminiRole.USER.toString()).parts(List.of(GeminiPart.builder().functionResponse(GeminiFunctionResponse.builder().name(toolResultMessage.toolName()).response(Map.of("response", toolResultMessage.text())).build()).build())).build();
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<GeminiPart> toGeminiParts(List<ToolExecutionRequest> toolExecutionRequests, String thoughtSignature) {
        ArrayList<GeminiPart> geminiParts = new ArrayList<GeminiPart>();
        for (int i = 0; i < toolExecutionRequests.size(); ++i) {
            ToolExecutionRequest toolExecutionRequest = toolExecutionRequests.get(i);
            boolean shouldAddThoughtSignature = i == 0 && Utils.isNotNullOrEmpty((String)thoughtSignature);
            GeminiPart geminiPart = GeminiPart.builder().functionCall(GeminiFunctionCall.builder().name(toolExecutionRequest.name()).args(Json.fromJson(toolExecutionRequest.arguments(), Map.class)).build()).thoughtSignature(shouldAddThoughtSignature ? thoughtSignature : null).build();
            geminiParts.add(geminiPart);
        }
        return geminiParts;
    }
}

