/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.http.client;

import dev.langchain4j.Experimental;
import dev.langchain4j.internal.ValidationUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Experimental
public class SuccessfulHttpResponse {
    private final int statusCode;
    private final Map<String, List<String>> headers;
    private final String body;

    public SuccessfulHttpResponse(Builder builder) {
        this.statusCode = ValidationUtils.ensureBetween((Integer)builder.statusCode, (int)200, (int)299, (String)"statusCode");
        this.headers = builder.headers == null ? Collections.emptyMap() : new HashMap<String, List<String>>(builder.headers);
        this.body = builder.body;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public String body() {
        return this.body;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int statusCode;
        private Map<String, List<String>> headers;
        private String body;

        private Builder() {
        }

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public SuccessfulHttpResponse build() {
            return new SuccessfulHttpResponse(this);
        }
    }
}

