/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.http.client;

import dev.langchain4j.exception.HttpException;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.sse.DefaultServerSentEventParser;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.http.client.sse.ServerSentEventParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

@EnabledIfEnvironmentVariable(named="OPENAI_API_KEY", matches=".+")
public abstract class HttpClientIT {
    private static final String OPENAI_API_KEY = System.getenv("OPENAI_API_KEY");

    protected abstract List<HttpClient> clients();

    @Test
    void should_return_successful_http_response_sync() {
        for (HttpClient client : this.clients()) {
            HttpRequest request = HttpRequest.builder().method(HttpMethod.POST).url("https://api.openai.com/v1/chat/completions").addHeader("Authorization", new String[]{"Bearer " + OPENAI_API_KEY}).addHeader("Content-Type", new String[]{"application/json"}).body("{\n    \"model\": \"gpt-4o-mini\",\n    \"messages\": [\n        {\n            \"role\" : \"user\",\n            \"content\" : \"What is the capital of Germany?\"\n        }\n    ]\n}\n").build();
            SuccessfulHttpResponse response = client.execute(request);
            Assertions.assertThat((int)response.statusCode()).isEqualTo(200);
            Assertions.assertThat((Map)response.headers()).isNotEmpty();
            Assertions.assertThat((String)response.body()).contains(new CharSequence[]{"Berlin"});
        }
    }

    @Test
    void should_throw_400_sync() {
        for (HttpClient client : this.clients()) {
            String invalidBody = "{\n    \"model\": \"gpt-4o-mini\"\n}\n";
            HttpRequest request = HttpRequest.builder().method(HttpMethod.POST).url("https://api.openai.com/v1/chat/completions").addHeader("Authorization", new String[]{"Bearer " + OPENAI_API_KEY}).addHeader("Content-Type", new String[]{"application/json"}).body(invalidBody).build();
            try {
                client.execute(request);
                Assertions.fail((String)"Should have thrown an exception");
            }
            catch (Exception e) {
                Assertions.assertThat((Throwable)e).isExactlyInstanceOf(HttpException.class);
                HttpException httpException = (HttpException)e;
                Assertions.assertThat((int)httpException.statusCode()).isEqualTo(400);
                Assertions.assertThat((String)httpException.getMessage()).contains(new CharSequence[]{"Missing required parameter: 'messages'"});
            }
        }
    }

    @Test
    void should_throw_401_sync() {
        for (HttpClient client : this.clients()) {
            String incorrectApiKey = "banana";
            HttpRequest request = HttpRequest.builder().method(HttpMethod.POST).url("https://api.openai.com/v1/chat/completions").addHeader("Authorization", new String[]{"Bearer " + incorrectApiKey}).addHeader("Content-Type", new String[]{"application/json"}).body("{\n    \"model\": \"gpt-4o-mini\",\n    \"messages\": [\n        {\n            \"role\" : \"user\",\n            \"content\" : \"What is the capital of Germany?\"\n        }\n    ]\n}\n").build();
            try {
                client.execute(request);
                Assertions.fail((String)"Should have thrown an exception");
            }
            catch (Exception e) {
                Assertions.assertThat((Throwable)e).isExactlyInstanceOf(HttpException.class);
                HttpException httpException = (HttpException)e;
                Assertions.assertThat((int)httpException.statusCode()).isEqualTo(401);
                Assertions.assertThat((String)httpException.getMessage()).contains(new CharSequence[]{"Incorrect API key provided"});
            }
        }
    }

    @Test
    void should_return_successful_http_response_async() throws Exception {
        for (HttpClient client : this.clients()) {
            HttpRequest request = HttpRequest.builder().method(HttpMethod.POST).url("https://api.openai.com/v1/chat/completions").addHeader("Authorization", new String[]{"Bearer " + OPENAI_API_KEY}).addHeader("Content-Type", new String[]{"application/json"}).body("{\n    \"model\": \"gpt-4o-mini\",\n    \"messages\": [\n        {\n            \"role\" : \"user\",\n            \"content\" : \"What is the capital of Germany?\"\n        }\n    ],\n    \"stream\": true\n}\n").build();
            final CompletableFuture completableFuture = new CompletableFuture();
            ServerSentEventListener listener = new ServerSentEventListener(){
                private final AtomicReference<SuccessfulHttpResponse> response = new AtomicReference();
                private final List<ServerSentEvent> events = new ArrayList<ServerSentEvent>();
                private final Set<Thread> threads = new HashSet<Thread>();

                public void onOpen(SuccessfulHttpResponse successfulHttpResponse) {
                    this.threads.add(Thread.currentThread());
                    this.response.set(successfulHttpResponse);
                }

                public void onEvent(ServerSentEvent event) {
                    this.threads.add(Thread.currentThread());
                    this.events.add(event);
                }

                public void onError(Throwable throwable) {
                    this.threads.add(Thread.currentThread());
                    completableFuture.completeExceptionally(throwable);
                }

                public void onClose() {
                    this.threads.add(Thread.currentThread());
                    record StreamingResult(SuccessfulHttpResponse response, List<ServerSentEvent> events, Set<Thread> threads) {
                    }
                    completableFuture.complete(new StreamingResult(this.response.get(), this.events, this.threads));
                }
            };
            ServerSentEventListener spyListener = (ServerSentEventListener)Mockito.spy((Object)listener);
            client.execute(request, (ServerSentEventParser)new DefaultServerSentEventParser(), spyListener);
            StreamingResult streamingResult = (StreamingResult)completableFuture.get(30L, TimeUnit.SECONDS);
            Assertions.assertThat((Object)streamingResult.response()).isNotNull();
            Assertions.assertThat((int)streamingResult.response().statusCode()).isEqualTo(200);
            Assertions.assertThat((Map)streamingResult.response().headers()).isNotEmpty();
            Assertions.assertThat((String)streamingResult.response().body()).isNull();
            Assertions.assertThat(streamingResult.events()).isNotEmpty();
            Assertions.assertThat((String)streamingResult.events().stream().map(ServerSentEvent::data).collect(Collectors.joining(""))).contains(new CharSequence[]{"Berlin"});
            Assertions.assertThat(streamingResult.threads()).hasSize(1);
            Assertions.assertThat((Object)streamingResult.threads().iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{spyListener});
            ((ServerSentEventListener)inOrder.verify((Object)spyListener, Mockito.times((int)1))).onOpen((SuccessfulHttpResponse)ArgumentMatchers.any());
            ((ServerSentEventListener)inOrder.verify((Object)spyListener, Mockito.atLeastOnce())).onEvent((ServerSentEvent)ArgumentMatchers.any());
            ((ServerSentEventListener)inOrder.verify((Object)spyListener, Mockito.times((int)1))).onClose();
            inOrder.verifyNoMoreInteractions();
        }
    }

    @Test
    void should_return_successful_http_response_with_double_newline_async() throws Exception {
        for (HttpClient client : this.clients()) {
            HttpRequest request = HttpRequest.builder().method(HttpMethod.POST).url("https://api.openai.com/v1/chat/completions").addHeader("Authorization", new String[]{"Bearer " + OPENAI_API_KEY}).addHeader("Content-Type", new String[]{"application/json"}).body("{\n    \"model\": \"gpt-4o-mini\",\n    \"messages\": [\n        {\n            \"role\" : \"user\",\n            \"content\" : \"What is the capital of Germany? What is a capital of France? Your answers must be separated by a double newline!\"\n        }\n    ],\n    \"temperature\": 0.0,\n    \"stream\": true\n}\n").build();
            final CompletableFuture completableFuture = new CompletableFuture();
            ServerSentEventListener listener = new ServerSentEventListener(){
                private final AtomicReference<SuccessfulHttpResponse> response = new AtomicReference();
                private final List<ServerSentEvent> events = new ArrayList<ServerSentEvent>();
                private final Set<Thread> threads = new HashSet<Thread>();

                public void onOpen(SuccessfulHttpResponse successfulHttpResponse) {
                    this.threads.add(Thread.currentThread());
                    this.response.set(successfulHttpResponse);
                }

                public void onEvent(ServerSentEvent event) {
                    this.threads.add(Thread.currentThread());
                    this.events.add(event);
                }

                public void onError(Throwable throwable) {
                    this.threads.add(Thread.currentThread());
                    completableFuture.completeExceptionally(throwable);
                }

                public void onClose() {
                    this.threads.add(Thread.currentThread());
                    record StreamingResult(SuccessfulHttpResponse response, List<ServerSentEvent> events, Set<Thread> threads) {
                    }
                    completableFuture.complete(new StreamingResult(this.response.get(), this.events, this.threads));
                }
            };
            ServerSentEventListener spyListener = (ServerSentEventListener)Mockito.spy((Object)listener);
            client.execute(request, (ServerSentEventParser)new DefaultServerSentEventParser(), spyListener);
            StreamingResult streamingResult = (StreamingResult)completableFuture.get(30L, TimeUnit.SECONDS);
            Assertions.assertThat((Object)streamingResult.response()).isNotNull();
            Assertions.assertThat((int)streamingResult.response().statusCode()).isEqualTo(200);
            Assertions.assertThat((Map)streamingResult.response().headers()).isNotEmpty();
            Assertions.assertThat((String)streamingResult.response().body()).isNull();
            Assertions.assertThat(streamingResult.events()).isNotEmpty();
            Assertions.assertThat((String)streamingResult.events().stream().map(ServerSentEvent::data).collect(Collectors.joining(""))).contains(new CharSequence[]{"Berlin", "Paris", "\\n\\n"});
            Assertions.assertThat(streamingResult.threads()).hasSize(1);
            Assertions.assertThat((Object)streamingResult.threads().iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{spyListener});
            ((ServerSentEventListener)inOrder.verify((Object)spyListener, Mockito.times((int)1))).onOpen((SuccessfulHttpResponse)ArgumentMatchers.any());
            ((ServerSentEventListener)inOrder.verify((Object)spyListener, Mockito.atLeastOnce())).onEvent((ServerSentEvent)ArgumentMatchers.any());
            ((ServerSentEventListener)inOrder.verify((Object)spyListener, Mockito.times((int)1))).onClose();
            inOrder.verifyNoMoreInteractions();
        }
    }

    @Test
    void should_throw_400_async() throws Exception {
        for (HttpClient client : this.clients()) {
            String invalidBody = "{\n    \"model\": \"gpt-4o-mini\",\n    \"stream\": true\n}\n";
            HttpRequest request = HttpRequest.builder().method(HttpMethod.POST).url("https://api.openai.com/v1/chat/completions").addHeader("Authorization", new String[]{"Bearer " + OPENAI_API_KEY}).addHeader("Content-Type", new String[]{"application/json"}).body(invalidBody).build();
            final CompletableFuture completableFuture = new CompletableFuture();
            ServerSentEventListener listener = new ServerSentEventListener(){
                private final Set<Thread> threads = new HashSet<Thread>();

                public void onOpen(SuccessfulHttpResponse successfulHttpResponse) {
                    completableFuture.completeExceptionally(new IllegalStateException("onOpen() should not be called"));
                }

                public void onEvent(ServerSentEvent event) {
                    completableFuture.completeExceptionally(new IllegalStateException("onEvent() should not be called"));
                }

                public void onError(Throwable throwable) {
                    this.threads.add(Thread.currentThread());
                    record StreamingResult(Throwable throwable, Set<Thread> threads) {
                    }
                    completableFuture.complete(new StreamingResult(throwable, this.threads));
                }

                public void onClose() {
                    completableFuture.completeExceptionally(new IllegalStateException("onClose() should not be called"));
                }
            };
            ServerSentEventListener spyListener = (ServerSentEventListener)Mockito.spy((Object)listener);
            client.execute(request, (ServerSentEventParser)new DefaultServerSentEventParser(), spyListener);
            StreamingResult streamingResult = (StreamingResult)completableFuture.get(30L, TimeUnit.SECONDS);
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)streamingResult.throwable()).isExactlyInstanceOf(HttpException.class)).extracting("statusCode").isEqualTo((Object)400);
            Assertions.assertThat((Throwable)streamingResult.throwable()).hasMessageContaining("Missing required parameter: 'messages'");
            Assertions.assertThat(streamingResult.threads()).hasSize(1);
            Assertions.assertThat((Object)streamingResult.threads().iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{spyListener});
            ((ServerSentEventListener)inOrder.verify((Object)spyListener, Mockito.times((int)1))).onError((Throwable)ArgumentMatchers.any());
            inOrder.verifyNoMoreInteractions();
        }
    }

    @Test
    void should_fail_when_listener_onOpen_throws_exception() throws Exception {
        for (HttpClient client : this.clients()) {
            HttpRequest request = HttpRequest.builder().method(HttpMethod.POST).url("https://api.openai.com/v1/chat/completions").addHeader("Authorization", new String[]{"Bearer " + OPENAI_API_KEY}).addHeader("Content-Type", new String[]{"application/json"}).body("{\n    \"model\": \"gpt-4o-mini\",\n    \"messages\": [\n        {\n            \"role\" : \"user\",\n            \"content\" : \"What is the capital of Germany?\"\n        }\n    ],\n    \"stream\": true\n}\n").build();
            final AtomicReference response = new AtomicReference();
            final List events = Collections.synchronizedList(new ArrayList());
            final List errors = Collections.synchronizedList(new ArrayList());
            final Set threads = Collections.synchronizedSet(new HashSet());
            ServerSentEventListener listener = new ServerSentEventListener(){

                public void onOpen(SuccessfulHttpResponse successfulHttpResponse) {
                    response.set(successfulHttpResponse);
                    threads.add(Thread.currentThread());
                    throw new RuntimeException("Unexpected exception in onOpen()");
                }

                public void onEvent(ServerSentEvent event) {
                    events.add(event);
                    threads.add(Thread.currentThread());
                }

                public void onError(Throwable throwable) {
                    errors.add(throwable);
                    threads.add(Thread.currentThread());
                }

                public void onClose() {
                    threads.add(Thread.currentThread());
                }
            };
            ServerSentEventListener spyListener = (ServerSentEventListener)Mockito.spy((Object)listener);
            client.execute(request, (ServerSentEventParser)new DefaultServerSentEventParser(), spyListener);
            Thread.sleep(5000L);
            Assertions.assertThat((Object)((SuccessfulHttpResponse)response.get())).isNotNull();
            Assertions.assertThat(events).isEmpty();
            Assertions.assertThat(errors).isEmpty();
            Assertions.assertThat(threads).hasSize(1);
            Assertions.assertThat((Object)((Thread)threads.iterator().next())).isNotEqualTo((Object)Thread.currentThread());
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{spyListener});
            ((ServerSentEventListener)inOrder.verify((Object)spyListener, Mockito.times((int)1))).onOpen((SuccessfulHttpResponse)ArgumentMatchers.any());
            inOrder.verifyNoMoreInteractions();
        }
    }

    @Test
    void should_fail_when_listener_onEvent_throws_exception() throws Exception {
        for (HttpClient client : this.clients()) {
            HttpRequest request = HttpRequest.builder().method(HttpMethod.POST).url("https://api.openai.com/v1/chat/completions").addHeader("Authorization", new String[]{"Bearer " + OPENAI_API_KEY}).addHeader("Content-Type", new String[]{"application/json"}).body("{\n    \"model\": \"gpt-4o-mini\",\n    \"messages\": [\n        {\n            \"role\" : \"user\",\n            \"content\" : \"What is the capital of Germany?\"\n        }\n    ],\n    \"stream\": true\n}\n").build();
            final AtomicReference response = new AtomicReference();
            final List events = Collections.synchronizedList(new ArrayList());
            final List errors = Collections.synchronizedList(new ArrayList());
            final Set threads = Collections.synchronizedSet(new HashSet());
            ServerSentEventListener listener = new ServerSentEventListener(){

                public void onOpen(SuccessfulHttpResponse successfulHttpResponse) {
                    response.set(successfulHttpResponse);
                    threads.add(Thread.currentThread());
                }

                public void onEvent(ServerSentEvent event) {
                    events.add(event);
                    threads.add(Thread.currentThread());
                    throw new RuntimeException("Unexpected exception in onEvent()");
                }

                public void onError(Throwable throwable) {
                    errors.add(throwable);
                    threads.add(Thread.currentThread());
                }

                public void onClose() {
                    threads.add(Thread.currentThread());
                }
            };
            ServerSentEventListener spyListener = (ServerSentEventListener)Mockito.spy((Object)listener);
            client.execute(request, (ServerSentEventParser)new DefaultServerSentEventParser(), spyListener);
            Thread.sleep(5000L);
            Assertions.assertThat((Object)((SuccessfulHttpResponse)response.get())).isNotNull();
            Assertions.assertThat(events).hasSize(1);
            Assertions.assertThat(errors).isEmpty();
            Assertions.assertThat(threads).hasSize(1);
            Assertions.assertThat((Object)((Thread)threads.iterator().next())).isNotEqualTo((Object)Thread.currentThread());
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{spyListener});
            ((ServerSentEventListener)inOrder.verify((Object)spyListener, Mockito.times((int)1))).onOpen((SuccessfulHttpResponse)ArgumentMatchers.any());
            ((ServerSentEventListener)inOrder.verify((Object)spyListener, Mockito.times((int)1))).onEvent((ServerSentEvent)ArgumentMatchers.any());
            inOrder.verifyNoMoreInteractions();
        }
    }

    @Test
    void should_fail_when_listener_onError_throws_exception() throws Exception {
        for (HttpClient client : this.clients()) {
            String incorrectApiKey = "banana";
            HttpRequest request = HttpRequest.builder().method(HttpMethod.POST).url("https://api.openai.com/v1/chat/completions").addHeader("Authorization", new String[]{"Bearer " + incorrectApiKey}).addHeader("Content-Type", new String[]{"application/json"}).body("{\n    \"model\": \"gpt-4o-mini\",\n    \"messages\": [\n        {\n            \"role\" : \"user\",\n            \"content\" : \"What is the capital of Germany?\"\n        }\n    ],\n    \"stream\": true\n}\n").build();
            final AtomicReference response = new AtomicReference();
            final List events = Collections.synchronizedList(new ArrayList());
            final List errors = Collections.synchronizedList(new ArrayList());
            final Set threads = Collections.synchronizedSet(new HashSet());
            ServerSentEventListener listener = new ServerSentEventListener(){

                public void onOpen(SuccessfulHttpResponse successfulHttpResponse) {
                    response.set(successfulHttpResponse);
                    threads.add(Thread.currentThread());
                }

                public void onEvent(ServerSentEvent event) {
                    events.add(event);
                    threads.add(Thread.currentThread());
                }

                public void onError(Throwable throwable) {
                    errors.add(throwable);
                    threads.add(Thread.currentThread());
                    throw new RuntimeException("Unexpected exception in onError()");
                }

                public void onClose() {
                    threads.add(Thread.currentThread());
                }
            };
            ServerSentEventListener spyListener = (ServerSentEventListener)Mockito.spy((Object)listener);
            client.execute(request, (ServerSentEventParser)new DefaultServerSentEventParser(), spyListener);
            Thread.sleep(5000L);
            Assertions.assertThat((Object)((SuccessfulHttpResponse)response.get())).isNull();
            Assertions.assertThat(events).isEmpty();
            Assertions.assertThat(errors).hasSize(1);
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)((Throwable)errors.get(0))).isExactlyInstanceOf(HttpException.class)).hasMessageContaining("Incorrect API key provided");
            Assertions.assertThat(threads).hasSize(1);
            Assertions.assertThat((Object)((Thread)threads.iterator().next())).isNotEqualTo((Object)Thread.currentThread());
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{spyListener});
            ((ServerSentEventListener)inOrder.verify((Object)spyListener, Mockito.times((int)1))).onError((Throwable)ArgumentMatchers.any());
            inOrder.verifyNoMoreInteractions();
        }
    }
}

