/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.http.client.sse;

import dev.langchain4j.http.client.sse.DefaultServerSentEventParser;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.http.client.sse.ServerSentEventParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class DefaultServerSentEventParserTest {
    private final ServerSentEventParser parser = new DefaultServerSentEventParser();
    @Mock
    private ServerSentEventListener listener;

    DefaultServerSentEventParserTest() {
    }

    @AfterEach
    void afterEach() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener});
    }

    @ParameterizedTest
    @ValueSource(strings={"data: Simple message", "data: Simple message\n", "\ndata: Simple message", "\ndata: Simple message\n", "\n\ndata: Simple message", "data: Simple message\n\n", "\n\ndata: Simple message\n\n"})
    void shouldParseSimpleSingleLineEvent(String input) {
        ByteArrayInputStream stream = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
        this.parser.parse((InputStream)stream, this.listener);
        ((ServerSentEventListener)Mockito.verify((Object)this.listener)).onEvent(new ServerSentEvent(null, "Simple message"));
    }

    @Test
    void shouldParseMultiLineDataEvent() {
        String input = "data: First line\ndata: Second line\ndata: Third line\n\n";
        ByteArrayInputStream stream = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
        this.parser.parse((InputStream)stream, this.listener);
        ((ServerSentEventListener)Mockito.verify((Object)this.listener)).onEvent(new ServerSentEvent(null, "First line\nSecond line\nThird line"));
    }

    @Test
    void shouldParseEventWithAllFields() {
        String input = "id: msg-123\nevent: custom-event\ndata: Message content\nretry: 5000\n\n";
        ByteArrayInputStream stream = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
        this.parser.parse((InputStream)stream, this.listener);
        ((ServerSentEventListener)Mockito.verify((Object)this.listener)).onEvent(new ServerSentEvent("custom-event", "Message content"));
    }

    @Test
    void shouldParseMultipleEvents() {
        String input = "data: First event\n\ndata: Second event\n\ndata: Third event\n\n";
        ByteArrayInputStream stream = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
        this.parser.parse((InputStream)stream, this.listener);
        ((ServerSentEventListener)Mockito.verify((Object)this.listener)).onEvent(new ServerSentEvent(null, "First event"));
        ((ServerSentEventListener)Mockito.verify((Object)this.listener)).onEvent(new ServerSentEvent(null, "Second event"));
        ((ServerSentEventListener)Mockito.verify((Object)this.listener)).onEvent(new ServerSentEvent(null, "Third event"));
    }

    @Test
    void shouldIgnoreCommentsAndEmptyLines() {
        String input = ": this is a comment\n\ndata: actual message\n\n";
        ByteArrayInputStream stream = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
        this.parser.parse((InputStream)stream, this.listener);
        ((ServerSentEventListener)Mockito.verify((Object)this.listener)).onEvent(new ServerSentEvent(null, "actual message"));
    }

    @Test
    void shouldHandleStreamWithNoEvents() {
        String input = "";
        ByteArrayInputStream stream = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
        this.parser.parse((InputStream)stream, this.listener);
        ((ServerSentEventListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onEvent((ServerSentEvent)ArgumentMatchers.any());
    }

    @Test
    void shouldHandleIOException() {
        InputStream mockStream = (InputStream)Mockito.mock(InputStream.class);
        IOException simulatedIoException = new IOException("Simulated IO exception");
        Assertions.assertDoesNotThrow(() -> Mockito.when((Object)mockStream.read((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{simulatedIoException}), (String)"Mock setup failed");
        this.parser.parse(mockStream, this.listener);
        ((ServerSentEventListener)Mockito.verify((Object)this.listener)).onError((Throwable)simulatedIoException);
    }
}

