/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.huggingface;

import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.huggingface.ApiKeyInsertingInterceptor;
import dev.langchain4j.model.huggingface.HuggingFaceApi;
import dev.langchain4j.model.huggingface.client.EmbeddingRequest;
import dev.langchain4j.model.huggingface.client.HuggingFaceClient;
import dev.langchain4j.model.huggingface.client.TextGenerationRequest;
import dev.langchain4j.model.huggingface.client.TextGenerationResponse;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

class DefaultHuggingFaceClient
implements HuggingFaceClient {
    private static final String BASE_URL = "https://api-inference.huggingface.co/";
    private final HuggingFaceApi huggingFaceApi;
    private final String modelId;

    DefaultHuggingFaceClient(String baseUrl, String apiKey, String modelId, Duration timeout) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new ApiKeyInsertingInterceptor(apiKey)).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(Objects.isNull(baseUrl) ? BASE_URL : baseUrl).client(okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
        this.huggingFaceApi = (HuggingFaceApi)retrofit.create(HuggingFaceApi.class);
        this.modelId = ValidationUtils.ensureNotBlank((String)modelId, (String)"modelId");
    }

    @Override
    public TextGenerationResponse chat(TextGenerationRequest request) {
        return this.generate(request);
    }

    @Override
    public TextGenerationResponse generate(TextGenerationRequest request) {
        try {
            Response retrofitResponse = this.huggingFaceApi.generate(request, this.modelId).execute();
            if (retrofitResponse.isSuccessful()) {
                return DefaultHuggingFaceClient.toOneResponse((Response<List<TextGenerationResponse>>)retrofitResponse);
            }
            throw DefaultHuggingFaceClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static TextGenerationResponse toOneResponse(Response<List<TextGenerationResponse>> retrofitResponse) {
        List responses = (List)retrofitResponse.body();
        if (responses != null && responses.size() == 1) {
            return (TextGenerationResponse)responses.get(0);
        }
        throw new RuntimeException("Expected only one generated_text, but was: " + (responses == null ? 0 : responses.size()));
    }

    @Override
    public List<float[]> embed(EmbeddingRequest request) {
        try {
            Response retrofitResponse = this.huggingFaceApi.embed(request, this.modelId).execute();
            if (retrofitResponse.isSuccessful()) {
                return (List)retrofitResponse.body();
            }
            throw DefaultHuggingFaceClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static RuntimeException toException(Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }
}

