/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.jlama;

import com.github.tjake.jlama.model.AbstractModel;
import com.github.tjake.jlama.model.ModelSupport;
import com.github.tjake.jlama.safetensors.DType;
import com.github.tjake.jlama.safetensors.SafeTensorSupport;
import dev.langchain4j.model.jlama.JlamaModelRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;

class JlamaModel {
    private final JlamaModelRegistry registry;
    private final ModelSupport.ModelType modelType;
    private final String modelName;
    private final Optional<String> owner;
    private final String modelId;
    private final boolean isLocal;

    public JlamaModel(JlamaModelRegistry registry, ModelSupport.ModelType modelType, String modelName, Optional<String> owner, String modelId, boolean isLocal) {
        this.registry = registry;
        this.modelType = modelType;
        this.modelName = modelName;
        this.owner = owner;
        this.modelId = modelId;
        this.isLocal = isLocal;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public Loader loader() {
        return new Loader();
    }

    public void download(Optional<String> authToken) throws IOException {
        SafeTensorSupport.maybeDownloadModel((String)this.registry.getModelCachePath().toString(), this.owner, (String)this.modelName, Optional.empty(), authToken, Optional.empty());
    }

    public ModelSupport.ModelType getModelType() {
        return this.modelType;
    }

    public String getModelName() {
        return this.modelName;
    }

    public Optional<String> getOwner() {
        return this.owner;
    }

    public String getModelId() {
        return this.modelId;
    }

    public class Loader {
        private Path workingDirectory;
        private DType quantizationType;
        private Integer threadCount;
        private AbstractModel.InferenceType inferenceType = AbstractModel.InferenceType.FULL_GENERATION;

        private Loader() {
        }

        public Loader quantized() {
            this.quantizationType = DType.Q4;
            return this;
        }

        public Loader workingDirectory(Path workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Loader threadCount(Integer threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        public Loader inferenceType(AbstractModel.InferenceType inferenceType) {
            this.inferenceType = inferenceType;
            return this;
        }

        public AbstractModel load() {
            return ModelSupport.loadModel((AbstractModel.InferenceType)this.inferenceType, (File)new File(JlamaModel.this.registry.getModelCachePath().toFile(), JlamaModel.this.modelName), (File)(this.workingDirectory == null ? null : this.workingDirectory.toFile()), (DType)DType.F32, (DType)DType.I8, Optional.ofNullable(this.quantizationType), Optional.ofNullable(this.threadCount), Optional.empty());
        }
    }
}

