/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.jlama;

import com.github.tjake.jlama.model.AbstractModel;
import com.github.tjake.jlama.model.functions.Generator;
import com.github.tjake.jlama.safetensors.DType;
import com.github.tjake.jlama.safetensors.prompt.PromptContext;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.jlama.JlamaLanguageModel;
import dev.langchain4j.model.jlama.JlamaModel;
import dev.langchain4j.model.jlama.JlamaModelRegistry;
import dev.langchain4j.model.jlama.spi.JlamaStreamingLanguageModelBuilderFactory;
import dev.langchain4j.model.language.StreamingLanguageModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;

public class JlamaStreamingLanguageModel
implements StreamingLanguageModel {
    private final AbstractModel model;
    private final Float temperature;
    private final Integer maxTokens;
    private final UUID id = UUID.randomUUID();

    public JlamaStreamingLanguageModel(Path modelCachePath, String modelName, String authToken, Integer threadCount, Boolean quantizeModelAtRuntime, Path workingDirectory, DType workingQuantizedType, Float temperature, Integer maxTokens) {
        JlamaModelRegistry registry = JlamaModelRegistry.getOrCreate(modelCachePath);
        JlamaModel jlamaModel = (JlamaModel)RetryUtils.withRetry(() -> registry.downloadModel(modelName, Optional.ofNullable(authToken)), (int)3);
        JlamaModel.Loader loader = jlamaModel.loader();
        if (quantizeModelAtRuntime != null && quantizeModelAtRuntime.booleanValue()) {
            loader = loader.quantized();
        }
        if (workingQuantizedType != null) {
            loader = loader.workingQuantizationType(workingQuantizedType);
        }
        if (threadCount != null) {
            loader = loader.threadCount(threadCount);
        }
        if (workingDirectory != null) {
            loader = loader.workingDirectory(workingDirectory);
        }
        this.model = loader.load();
        this.temperature = Float.valueOf(temperature == null ? 0.7f : temperature.floatValue());
        this.maxTokens = maxTokens == null ? this.model.getConfig().contextLength : maxTokens;
    }

    public static JlamaStreamingLanguageModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(JlamaStreamingLanguageModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            JlamaStreamingLanguageModelBuilderFactory factory = (JlamaStreamingLanguageModelBuilderFactory)iterator.next();
            return (JlamaStreamingLanguageModelBuilder)factory.get();
        }
        return new JlamaStreamingLanguageModelBuilder();
    }

    public void generate(String prompt, StreamingResponseHandler<String> handler) {
        try {
            Generator.Response r = this.model.generate(this.id, PromptContext.of((String)prompt), this.temperature.floatValue(), this.maxTokens.intValue(), (token, time) -> handler.onNext(token));
            handler.onComplete(Response.from((Object)r.responseText, (TokenUsage)new TokenUsage(Integer.valueOf(r.promptTokens), Integer.valueOf(r.generatedTokens)), (FinishReason)JlamaLanguageModel.toFinishReason(r.finishReason)));
        }
        catch (Throwable t) {
            handler.onError(t);
        }
    }

    public static class JlamaStreamingLanguageModelBuilder {
        private Path modelCachePath;
        private String modelName;
        private String authToken;
        private Integer threadCount;
        private Boolean quantizeModelAtRuntime;
        private Path workingDirectory;
        private DType workingQuantizedType;
        private Float temperature;
        private Integer maxTokens;

        public JlamaStreamingLanguageModelBuilder modelCachePath(Path modelCachePath) {
            this.modelCachePath = modelCachePath;
            return this;
        }

        public JlamaStreamingLanguageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public JlamaStreamingLanguageModelBuilder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public JlamaStreamingLanguageModelBuilder threadCount(Integer threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        public JlamaStreamingLanguageModelBuilder quantizeModelAtRuntime(Boolean quantizeModelAtRuntime) {
            this.quantizeModelAtRuntime = quantizeModelAtRuntime;
            return this;
        }

        public JlamaStreamingLanguageModelBuilder workingDirectory(Path workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public JlamaStreamingLanguageModelBuilder workingQuantizedType(DType workingQuantizedType) {
            this.workingQuantizedType = workingQuantizedType;
            return this;
        }

        public JlamaStreamingLanguageModelBuilder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public JlamaStreamingLanguageModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public JlamaStreamingLanguageModel build() {
            return new JlamaStreamingLanguageModel(this.modelCachePath, this.modelName, this.authToken, this.threadCount, this.quantizeModelAtRuntime, this.workingDirectory, this.workingQuantizedType, this.temperature, this.maxTokens);
        }

        public String toString() {
            return "JlamaStreamingLanguageModel.JlamaStreamingLanguageModelBuilder(modelCachePath=" + String.valueOf(this.modelCachePath) + ", modelName=" + this.modelName + ", authToken=" + this.authToken + ", threadCount=" + this.threadCount + ", quantizeModelAtRuntime=" + this.quantizeModelAtRuntime + ", workingDirectory=" + String.valueOf(this.workingDirectory) + ", workingQuantizedType=" + String.valueOf(this.workingQuantizedType) + ", temperature=" + this.temperature + ", maxTokens=" + this.maxTokens + ")";
        }
    }
}

