/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.jlama;

import com.github.tjake.jlama.model.AbstractModel;
import com.github.tjake.jlama.model.ModelSupport;
import com.github.tjake.jlama.safetensors.DType;
import com.github.tjake.jlama.safetensors.SafeTensorSupport;
import com.github.tjake.jlama.safetensors.prompt.Function;
import com.github.tjake.jlama.safetensors.prompt.Tool;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonSchemaElementHelper;
import dev.langchain4j.model.jlama.JlamaModelRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;

class JlamaModel {
    private final JlamaModelRegistry registry;
    private final ModelSupport.ModelType modelType;
    private final String modelName;
    private final Optional<String> owner;
    private final String modelId;
    private final boolean isLocal;

    public JlamaModel(JlamaModelRegistry registry, ModelSupport.ModelType modelType, String modelName, Optional<String> owner, String modelId, boolean isLocal) {
        this.registry = registry;
        this.modelType = modelType;
        this.modelName = modelName;
        this.owner = owner;
        this.modelId = modelId;
        this.isLocal = isLocal;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public Loader loader() {
        return new Loader();
    }

    public void download(Optional<String> authToken) throws IOException {
        SafeTensorSupport.maybeDownloadModel((String)this.registry.getModelCachePath().toString(), this.owner, (String)this.modelName, (boolean)true, Optional.empty(), authToken, Optional.empty());
    }

    public ModelSupport.ModelType getModelType() {
        return this.modelType;
    }

    public String getModelName() {
        return this.modelName;
    }

    public Optional<String> getOwner() {
        return this.owner;
    }

    public String getModelId() {
        return this.modelId;
    }

    public static Tool toTool(ToolSpecification toolSpecification) {
        Function.Builder builder = Function.builder().name(toolSpecification.name());
        if (toolSpecification.description() != null) {
            builder.description(toolSpecification.description());
        }
        if (toolSpecification.parameters() != null) {
            JsonObjectSchema parameters = toolSpecification.parameters();
            for (Map.Entry p : parameters.properties().entrySet()) {
                builder.addParameter((String)p.getKey(), JsonSchemaElementHelper.toMap((JsonSchemaElement)((JsonSchemaElement)p.getValue())), parameters.required().contains(p.getKey()));
            }
        }
        return Tool.from((Function)builder.build());
    }

    public class Loader {
        private Path workingDirectory;
        private DType workingQuantizationType = DType.I8;
        private DType quantizationType;
        private Integer threadCount;
        private AbstractModel.InferenceType inferenceType = AbstractModel.InferenceType.FULL_GENERATION;

        private Loader() {
        }

        public Loader quantized() {
            this.quantizationType = DType.Q4;
            return this;
        }

        public Loader workingQuantizationType(DType workingQuantizationType) {
            this.workingQuantizationType = workingQuantizationType;
            return this;
        }

        public Loader workingDirectory(Path workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Loader threadCount(Integer threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        public Loader inferenceType(AbstractModel.InferenceType inferenceType) {
            this.inferenceType = inferenceType;
            return this;
        }

        public AbstractModel load() {
            return ModelSupport.loadModel((AbstractModel.InferenceType)this.inferenceType, (File)new File(JlamaModel.this.registry.getModelCachePath().toFile(), JlamaModel.this.modelName), (File)(this.workingDirectory == null ? null : this.workingDirectory.toFile()), (DType)DType.F32, (DType)this.workingQuantizationType, Optional.ofNullable(this.quantizationType), Optional.ofNullable(this.threadCount), Optional.empty(), SafeTensorSupport::loadWeights);
        }
    }
}

