/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.jlama;

import com.github.tjake.jlama.model.ModelSupport;
import com.github.tjake.jlama.safetensors.SafeTensorSupport;
import dev.langchain4j.model.jlama.JlamaModel;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JlamaModelRegistry {
    private static final Logger logger = LoggerFactory.getLogger(JlamaModelRegistry.class);
    private static final String DEFAULT_MODEL_CACHE_PATH = System.getProperty("user.home", "") + File.separator + ".jlama" + File.separator + "models";
    private final Path modelCachePath;

    private JlamaModelRegistry(Path modelCachePath) {
        this.modelCachePath = modelCachePath;
        if (!Files.exists(modelCachePath, new LinkOption[0])) {
            try {
                Files.createDirectories(modelCachePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    public static List<ModelSupport.ModelType> availableModelTypes() {
        return Arrays.stream(ModelSupport.ModelType.values()).toList();
    }

    public static JlamaModelRegistry getOrCreate(Path modelCachePath) {
        return new JlamaModelRegistry(modelCachePath == null ? Path.of(DEFAULT_MODEL_CACHE_PATH, new String[0]) : modelCachePath);
    }

    public Path getModelCachePath() {
        return this.modelCachePath;
    }

    public List<JlamaModel> listLocalModels() {
        ArrayList<JlamaModel> localModels = new ArrayList<JlamaModel>();
        for (File file : Objects.requireNonNull(this.modelCachePath.toFile().listFiles())) {
            File config;
            if (!file.isDirectory() || !(config = new File(file, "config.json")).exists()) continue;
            try {
                ModelSupport.ModelType type = SafeTensorSupport.detectModel((File)config);
                localModels.add(new JlamaModel(this, type, file.getName(), Optional.empty(), file.getName(), false));
            }
            catch (IOException e) {
                logger.warn("Error reading model config: " + config.getAbsolutePath(), (Throwable)e);
            }
        }
        return localModels;
    }

    public JlamaModel downloadModel(String modelName) throws IOException {
        return this.downloadModel(modelName, Optional.empty());
    }

    public JlamaModel downloadModel(String modelName, Optional<String> authToken) throws IOException {
        String name;
        String owner;
        String[] parts = modelName.split("/");
        if (parts.length == 0 || parts.length > 2) {
            throw new IllegalArgumentException("Model must be in the form owner/name");
        }
        if (parts.length == 1) {
            owner = null;
            name = modelName;
        } else {
            owner = parts[0];
            name = parts[1];
        }
        File modelDir = SafeTensorSupport.maybeDownloadModel((String)this.modelCachePath.toString(), Optional.ofNullable(owner), (String)name, (boolean)true, Optional.empty(), authToken, Optional.empty());
        File config = new File(modelDir, "config.json");
        ModelSupport.ModelType type = SafeTensorSupport.detectModel((File)config);
        return new JlamaModel(this, type, modelDir.getName(), Optional.empty(), modelName, true);
    }
}

