/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.mcp.client.transport;

import com.fasterxml.jackson.databind.JsonNode;
import dev.langchain4j.mcp.client.logging.McpLogMessage;
import dev.langchain4j.mcp.client.protocol.PingResponse;
import dev.langchain4j.mcp.client.transport.McpTransport;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpOperationHandler {
    private final Map<Long, CompletableFuture<JsonNode>> pendingOperations;
    private static final Logger log = LoggerFactory.getLogger(McpOperationHandler.class);
    private final McpTransport transport;
    private final Consumer<McpLogMessage> logMessageConsumer;

    public McpOperationHandler(Map<Long, CompletableFuture<JsonNode>> pendingOperations, McpTransport transport, Consumer<McpLogMessage> logMessageConsumer) {
        this.pendingOperations = pendingOperations;
        this.transport = transport;
        this.logMessageConsumer = logMessageConsumer;
    }

    public void handle(JsonNode message) {
        if (message.has("id")) {
            long messageId = message.get("id").asLong();
            CompletableFuture<JsonNode> op = this.pendingOperations.remove(messageId);
            if (op != null) {
                op.complete(message);
            } else {
                String method;
                if (message.has("method") && (method = message.get("method").asText()).equals("ping")) {
                    this.transport.executeOperationWithoutResponse(new PingResponse(messageId));
                    return;
                }
                log.warn("Received response for unknown message id: {}", (Object)messageId);
            }
        } else if (message.has("method") && message.get("method").asText().equals("notifications/message")) {
            if (message.has("params")) {
                if (this.logMessageConsumer != null) {
                    this.logMessageConsumer.accept(McpLogMessage.fromJson(message.get("params")));
                }
            } else {
                log.warn("Received log message without params: {}", (Object)message);
            }
        } else {
            log.warn("Received unknown message: {}", (Object)message);
        }
    }

    public void startOperation(Long id, CompletableFuture<JsonNode> future) {
        this.pendingOperations.put(id, future);
    }
}

