/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.milvus;

import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.comparison.IsEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThan;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsIn;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThan;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotIn;
import dev.langchain4j.store.embedding.filter.logical.And;
import dev.langchain4j.store.embedding.filter.logical.Not;
import dev.langchain4j.store.embedding.filter.logical.Or;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

class MilvusMetadataFilterMapper {
    MilvusMetadataFilterMapper() {
    }

    static String map(Filter filter) {
        if (filter instanceof IsEqualTo) {
            return MilvusMetadataFilterMapper.mapEqual((IsEqualTo)filter);
        }
        if (filter instanceof IsNotEqualTo) {
            return MilvusMetadataFilterMapper.mapNotEqual((IsNotEqualTo)filter);
        }
        if (filter instanceof IsGreaterThan) {
            return MilvusMetadataFilterMapper.mapGreaterThan((IsGreaterThan)filter);
        }
        if (filter instanceof IsGreaterThanOrEqualTo) {
            return MilvusMetadataFilterMapper.mapGreaterThanOrEqual((IsGreaterThanOrEqualTo)filter);
        }
        if (filter instanceof IsLessThan) {
            return MilvusMetadataFilterMapper.mapLessThan((IsLessThan)filter);
        }
        if (filter instanceof IsLessThanOrEqualTo) {
            return MilvusMetadataFilterMapper.mapLessThanOrEqual((IsLessThanOrEqualTo)filter);
        }
        if (filter instanceof IsIn) {
            return MilvusMetadataFilterMapper.mapIn((IsIn)filter);
        }
        if (filter instanceof IsNotIn) {
            return MilvusMetadataFilterMapper.mapNotIn((IsNotIn)filter);
        }
        if (filter instanceof And) {
            return MilvusMetadataFilterMapper.mapAnd((And)filter);
        }
        if (filter instanceof Not) {
            return MilvusMetadataFilterMapper.mapNot((Not)filter);
        }
        if (filter instanceof Or) {
            return MilvusMetadataFilterMapper.mapOr((Or)filter);
        }
        throw new UnsupportedOperationException("Unsupported filter type: " + filter.getClass().getName());
    }

    private static String mapEqual(IsEqualTo isEqualTo) {
        return String.format("%s == %s", MilvusMetadataFilterMapper.formatKey(isEqualTo.key()), MilvusMetadataFilterMapper.formatValue(isEqualTo.comparisonValue()));
    }

    private static String mapNotEqual(IsNotEqualTo isNotEqualTo) {
        return String.format("%s != %s", MilvusMetadataFilterMapper.formatKey(isNotEqualTo.key()), MilvusMetadataFilterMapper.formatValue(isNotEqualTo.comparisonValue()));
    }

    private static String mapGreaterThan(IsGreaterThan isGreaterThan) {
        return String.format("%s > %s", MilvusMetadataFilterMapper.formatKey(isGreaterThan.key()), MilvusMetadataFilterMapper.formatValue(isGreaterThan.comparisonValue()));
    }

    private static String mapGreaterThanOrEqual(IsGreaterThanOrEqualTo isGreaterThanOrEqualTo) {
        return String.format("%s >= %s", MilvusMetadataFilterMapper.formatKey(isGreaterThanOrEqualTo.key()), MilvusMetadataFilterMapper.formatValue(isGreaterThanOrEqualTo.comparisonValue()));
    }

    private static String mapLessThan(IsLessThan isLessThan) {
        return String.format("%s < %s", MilvusMetadataFilterMapper.formatKey(isLessThan.key()), MilvusMetadataFilterMapper.formatValue(isLessThan.comparisonValue()));
    }

    private static String mapLessThanOrEqual(IsLessThanOrEqualTo isLessThanOrEqualTo) {
        return String.format("%s <= %s", MilvusMetadataFilterMapper.formatKey(isLessThanOrEqualTo.key()), MilvusMetadataFilterMapper.formatValue(isLessThanOrEqualTo.comparisonValue()));
    }

    private static String mapIn(IsIn isIn) {
        return String.format("%s in %s", MilvusMetadataFilterMapper.formatKey(isIn.key()), MilvusMetadataFilterMapper.formatValues(isIn.comparisonValues()));
    }

    private static String mapNotIn(IsNotIn isNotIn) {
        return String.format("%s not in %s", MilvusMetadataFilterMapper.formatKey(isNotIn.key()), MilvusMetadataFilterMapper.formatValues(isNotIn.comparisonValues()));
    }

    private static String mapAnd(And and) {
        return String.format("%s and %s", MilvusMetadataFilterMapper.map(and.left()), MilvusMetadataFilterMapper.map(and.right()));
    }

    private static String mapNot(Not not) {
        return String.format("not(%s)", MilvusMetadataFilterMapper.map(not.expression()));
    }

    private static String mapOr(Or or) {
        return String.format("(%s or %s)", MilvusMetadataFilterMapper.map(or.left()), MilvusMetadataFilterMapper.map(or.right()));
    }

    private static String formatKey(String key) {
        return "metadata[\"" + key + "\"]";
    }

    private static String formatValue(Object value) {
        if (value instanceof String || value instanceof UUID) {
            return "\"" + value + "\"";
        }
        return value.toString();
    }

    protected static List<String> formatValues(Collection<?> values) {
        return values.stream().map(MilvusMetadataFilterMapper::formatValue).collect(Collectors.toList());
    }
}

