/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.mistralai;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.mistralai.internal.api.MistralAiCategories;
import dev.langchain4j.model.mistralai.internal.api.MistralAiModerationRequest;
import dev.langchain4j.model.mistralai.internal.api.MistralAiModerationResponse;
import dev.langchain4j.model.mistralai.internal.api.MistralAiModerationResult;
import dev.langchain4j.model.mistralai.internal.client.MistralAiClient;
import dev.langchain4j.model.moderation.Moderation;
import dev.langchain4j.model.moderation.ModerationModel;
import dev.langchain4j.model.output.Response;
import java.time.Duration;
import java.util.Collections;
import java.util.List;

public class MistralAiModerationModel
implements ModerationModel {
    private final MistralAiClient client;
    private final String modelName;
    private final Integer maxRetries;

    public MistralAiModerationModel(Builder builder) {
        this.client = ((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)MistralAiClient.builder().httpClientBuilder(builder.httpClientBuilder)).baseUrl((String)Utils.getOrDefault((Object)builder.baseUrl, (Object)"https://api.mistral.ai/v1"))).apiKey(builder.apiKey)).timeout(builder.timeout)).logRequests((Boolean)Utils.getOrDefault((Object)builder.logRequests, (Object)false))).logResponses((Boolean)Utils.getOrDefault((Object)builder.logResponses, (Object)false))).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)builder.modelName, (String)"modelName");
        this.maxRetries = (Integer)Utils.getOrDefault((Object)builder.maxRetries, (Object)2);
    }

    @Deprecated(forRemoval=true)
    public MistralAiModerationModel(HttpClientBuilder httpClientBuilder, String baseUrl, String apiKey, Duration timeout, Integer maxRetries, String modelName, Boolean logRequests, Boolean logResponses) {
        this.client = ((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)MistralAiClient.builder().httpClientBuilder(httpClientBuilder)).baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.mistral.ai/v1"))).apiKey(apiKey)).timeout(timeout)).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false))).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false))).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)2);
    }

    @Deprecated(forRemoval=true)
    public MistralAiModerationModel(String baseUrl, String apiKey, Duration timeout, Integer maxRetries, String modelName, Boolean logRequests, Boolean logResponses) {
        this(null, baseUrl, apiKey, timeout, maxRetries, modelName, logRequests, logResponses);
    }

    public Response<Moderation> moderate(String text) {
        return this.moderateInternal(Collections.singletonList(text));
    }

    public Response<Moderation> moderate(List<ChatMessage> messages) {
        return this.moderateInternal(messages.stream().map(MistralAiModerationModel::toText).toList());
    }

    private static String toText(ChatMessage chatMessage) {
        if (chatMessage instanceof SystemMessage) {
            SystemMessage systemMessage = (SystemMessage)chatMessage;
            return systemMessage.text();
        }
        if (chatMessage instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)chatMessage;
            return userMessage.singleText();
        }
        if (chatMessage instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)chatMessage;
            return aiMessage.text();
        }
        if (chatMessage instanceof ToolExecutionResultMessage) {
            ToolExecutionResultMessage toolExecutionResultMessage = (ToolExecutionResultMessage)chatMessage;
            return toolExecutionResultMessage.text();
        }
        throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(chatMessage.type()));
    }

    private Response<Moderation> moderateInternal(List<String> inputs) {
        MistralAiModerationRequest request = MistralAiModerationRequest.builder().model(this.modelName).input(inputs).build();
        MistralAiModerationResponse response = (MistralAiModerationResponse)RetryUtils.withRetryMappingExceptions(() -> this.client.moderation(request), (int)this.maxRetries);
        int i = 0;
        for (MistralAiModerationResult moderationResult : response.results()) {
            if (this.isAnyCategoryFlagged(moderationResult.getCategories())) {
                return Response.from((Object)Moderation.flagged((String)inputs.get(i)));
            }
            ++i;
        }
        return Response.from((Object)Moderation.notFlagged());
    }

    private boolean isAnyCategoryFlagged(MistralAiCategories categories) {
        return categories.getSexual() != null && categories.getSexual() != false || categories.getHateAndDiscrimination() != null && categories.getHateAndDiscrimination() != false || categories.getViolenceAndThreats() != null && categories.getViolenceAndThreats() != false || categories.getDangerousAndCriminalContent() != null && categories.getDangerousAndCriminalContent() != false || categories.getSelfHarm() != null && categories.getSelfHarm() != false || categories.getHealth() != null && categories.getHealth() != false || categories.getLaw() != null && categories.getLaw() != false || categories.getPii() != null && categories.getPii() != false;
    }

    public static class Builder {
        private HttpClientBuilder httpClientBuilder;
        private String baseUrl;
        private String apiKey;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;
        private String modelName;
        private Integer maxRetries;

        public Builder httpClientBuilder(HttpClientBuilder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public Builder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public MistralAiModerationModel build() {
            return new MistralAiModerationModel(this);
        }
    }
}

