/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.mongodb;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.mongodb.IndexMapping;
import dev.langchain4j.store.embedding.mongodb.MongoDbDocument;
import dev.langchain4j.store.embedding.mongodb.MongoDbMatchedDocument;
import java.util.Set;
import org.bson.Document;

class MappingUtils {
    private MappingUtils() throws InstantiationException {
        throw new InstantiationException("Can't instantiate this class");
    }

    static MongoDbDocument toMongoDbDocument(String id, Embedding embedding, TextSegment textSegment) {
        boolean hasTextSegment = textSegment != null;
        return MongoDbDocument.builder().id(id).embedding(embedding.vectorAsList()).text(hasTextSegment ? textSegment.text() : null).metadata(hasTextSegment ? textSegment.metadata().asMap() : null).build();
    }

    static EmbeddingMatch<TextSegment> toEmbeddingMatch(MongoDbMatchedDocument matchedDocument) {
        TextSegment textSegment = null;
        if (matchedDocument.getText() != null) {
            textSegment = matchedDocument.getMetadata() == null ? TextSegment.from((String)matchedDocument.getText()) : TextSegment.from((String)matchedDocument.getText(), (Metadata)Metadata.from(matchedDocument.getMetadata()));
        }
        return new EmbeddingMatch(matchedDocument.getScore(), matchedDocument.getId(), Embedding.from(matchedDocument.getEmbedding()), (Object)textSegment);
    }

    static Document fromIndexMapping(IndexMapping indexMapping) {
        Document mapping = new Document();
        mapping.append("dynamic", (Object)false);
        Document fields = new Document();
        MappingUtils.writeEmbedding(indexMapping.getDimension(), fields);
        Set<String> metadataFields = indexMapping.getMetadataFieldNames();
        if (metadataFields != null && !metadataFields.isEmpty()) {
            MappingUtils.writeMetadata(metadataFields, fields);
        }
        mapping.append("fields", (Object)fields);
        return new Document("mappings", (Object)mapping);
    }

    private static void writeMetadata(Set<String> metadataFields, Document fields) {
        Document metadata = new Document();
        metadata.append("dynamic", (Object)false);
        metadata.append("type", (Object)"document");
        Document metadataFieldDoc = new Document();
        metadataFields.forEach(field -> MappingUtils.writeMetadataField(metadataFieldDoc, field));
        metadata.append("fields", (Object)metadataFieldDoc);
        fields.append("metadata", (Object)metadata);
    }

    private static void writeMetadataField(Document metadataFieldDoc, String fieldName) {
        Document field = new Document();
        field.append("type", (Object)"token");
        metadataFieldDoc.append(fieldName, (Object)field);
    }

    private static void writeEmbedding(int dimensions, Document fields) {
        Document embedding = new Document();
        embedding.append("dimensions", (Object)dimensions);
        embedding.append("similarity", (Object)"cosine");
        embedding.append("type", (Object)"knnVector");
        fields.append("embedding", (Object)embedding);
    }
}

