/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.ollama.CompletionRequest;
import dev.langchain4j.model.ollama.CompletionResponse;
import dev.langchain4j.model.ollama.EmbeddingRequest;
import dev.langchain4j.model.ollama.EmbeddingResponse;
import dev.langchain4j.model.ollama.OllamaApi;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Optional;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class OllamaClient {
    private final OllamaApi ollamaApi;
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    public OllamaClient(String baseUrl, Duration timeout) {
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        OkHttpClient okHttpClient = new OkHttpClient.Builder().callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)GSON)).build();
        this.ollamaApi = (OllamaApi)retrofit.create(OllamaApi.class);
    }

    public CompletionResponse completion(CompletionRequest request) {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.completion(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (CompletionResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void streamingCompletion(CompletionRequest request, final StreamingResponseHandler<String> handler) {
        this.ollamaApi.streamingCompletion(request).enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, retrofit2.Response<ResponseBody> response) {
                try (InputStream inputStream = ((ResponseBody)response.body()).byteStream();){
                    StringBuilder content = new StringBuilder();
                    int inputTokenCount = 0;
                    int outputTokenCount = 0;
                    while (true) {
                        byte[] bytes = new byte[1024];
                        int len = inputStream.read(bytes);
                        String partialResponse = new String(bytes, 0, len);
                        CompletionResponse completionResponse = (CompletionResponse)GSON.fromJson(partialResponse, CompletionResponse.class);
                        if (Boolean.TRUE.equals(completionResponse.getDone())) {
                            handler.onComplete(Response.from((Object)content.toString(), (TokenUsage)new TokenUsage(Integer.valueOf(inputTokenCount), Integer.valueOf(outputTokenCount))));
                            break;
                        }
                        content.append(completionResponse.getResponse());
                        inputTokenCount += Optional.ofNullable(completionResponse.getPromptEvalCount()).orElse(0).intValue();
                        outputTokenCount += Optional.ofNullable(completionResponse.getEvalCount()).orElse(0).intValue();
                        handler.onNext(completionResponse.getResponse());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                handler.onError(throwable);
            }
        });
    }

    public EmbeddingResponse embed(EmbeddingRequest request) {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.embedd(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (EmbeddingResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RuntimeException toException(retrofit2.Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }

    public static OllamaClientBuilder builder() {
        return new OllamaClientBuilder();
    }

    public static class OllamaClientBuilder {
        private String baseUrl;
        private Duration timeout;

        OllamaClientBuilder() {
        }

        public OllamaClientBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OllamaClientBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OllamaClient build() {
            return new OllamaClient(this.baseUrl, this.timeout);
        }

        public String toString() {
            return "OllamaClient.OllamaClientBuilder(baseUrl=" + this.baseUrl + ", timeout=" + this.timeout + ")";
        }
    }
}

