/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

class OllamaDateDeserializer
extends JsonDeserializer<OffsetDateTime> {
    OllamaDateDeserializer() {
    }

    public OffsetDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String date = p.getText();
        if (date.contains(".")) {
            String[] parts = date.split("\\.");
            if (parts[1].contains("+")) {
                String nanoseconds = parts[1].substring(0, parts[1].indexOf(43));
                date = date.replaceAll(nanoseconds, "");
            } else {
                String nanoseconds = parts[1].substring(0, parts[1].indexOf(90));
                date = date.replaceAll(nanoseconds, "");
            }
        }
        return OffsetDateTime.parse(date, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }
}

