/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.ollama.ChatResponse;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;

class OllamaStreamingResponseBuilder {
    private StringBuffer contentBuilder = new StringBuffer();
    private volatile TokenUsage tokenUsage;

    OllamaStreamingResponseBuilder() {
    }

    void append(ChatResponse partialResponse) {
        String content;
        if (partialResponse == null) {
            return;
        }
        if (partialResponse.getEvalCount() != null && partialResponse.getPromptEvalCount() != null) {
            this.tokenUsage = new TokenUsage(partialResponse.getPromptEvalCount(), partialResponse.getEvalCount());
        }
        if ((content = partialResponse.getMessage().getContent()) != null) {
            this.contentBuilder.append(content);
        }
    }

    Response<AiMessage> build() {
        if (this.contentBuilder.toString().isEmpty()) {
            return null;
        }
        return Response.from((Object)AiMessage.from((String)this.contentBuilder.toString()), (TokenUsage)this.tokenUsage);
    }
}

