/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.ollama.ChatRequest;
import dev.langchain4j.model.ollama.ChatResponse;
import dev.langchain4j.model.ollama.OllamaChatModelListenerUtils;
import dev.langchain4j.model.ollama.OllamaClient;
import dev.langchain4j.model.ollama.OllamaMessagesUtils;
import dev.langchain4j.model.ollama.Options;
import dev.langchain4j.model.ollama.spi.OllamaChatModelBuilderFactory;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OllamaChatModel
implements ChatLanguageModel {
    private final OllamaClient client;
    private final String modelName;
    private final Options options;
    private final String format;
    private final Integer maxRetries;
    private final List<ChatModelListener> listeners;

    public OllamaChatModel(String baseUrl, String modelName, Double temperature, Integer topK, Double topP, Double repeatPenalty, Integer seed, Integer numPredict, Integer numCtx, List<String> stop, String format, Duration timeout, Integer maxRetries, Map<String, String> customHeaders, Boolean logRequests, Boolean logResponses, List<ChatModelListener> listeners) {
        this.client = OllamaClient.builder().baseUrl(baseUrl).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).customHeaders(customHeaders).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses(logResponses).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.options = Options.builder().temperature(temperature).topK(topK).topP(topP).repeatPenalty(repeatPenalty).seed(seed).numPredict(numPredict).numCtx(numCtx).stop(stop).build();
        this.format = format;
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.listeners = new ArrayList<ChatModelListener>((Collection)Utils.getOrDefault(listeners, Collections.emptyList()));
    }

    public static OllamaChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(OllamaChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            OllamaChatModelBuilderFactory factory = (OllamaChatModelBuilderFactory)iterator.next();
            return (OllamaChatModelBuilder)factory.get();
        }
        return new OllamaChatModelBuilder();
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        return this.doGenerate(messages, null);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        return this.doGenerate(messages, toolSpecifications);
    }

    private Response<AiMessage> doGenerate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        ChatRequest request = ChatRequest.builder().model(this.modelName).messages(OllamaMessagesUtils.toOllamaMessages(messages)).options(this.options).format(this.format).stream(false).tools(OllamaMessagesUtils.toOllamaTools(toolSpecifications)).build();
        ChatModelRequest modelListenerRequest = OllamaChatModelListenerUtils.createModelListenerRequest(request, messages, toolSpecifications);
        ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        OllamaChatModelListenerUtils.onListenRequest(this.listeners, modelListenerRequest, attributes);
        try {
            ChatResponse chatResponse = (ChatResponse)RetryUtils.withRetry(() -> this.client.chat(request), (int)this.maxRetries);
            Response response = Response.from((Object)(chatResponse.getMessage().getToolCalls() != null ? AiMessage.from(OllamaMessagesUtils.toToolExecutionRequest(chatResponse.getMessage().getToolCalls())) : AiMessage.from((String)chatResponse.getMessage().getContent())), (TokenUsage)new TokenUsage(chatResponse.getPromptEvalCount(), chatResponse.getEvalCount()));
            OllamaChatModelListenerUtils.onListenResponse(this.listeners, (Response<AiMessage>)response, modelListenerRequest, attributes);
            return response;
        }
        catch (Exception e) {
            OllamaChatModelListenerUtils.onListenError(this.listeners, e, modelListenerRequest, null, attributes);
            throw e;
        }
    }

    public static class OllamaChatModelBuilder {
        private String baseUrl;
        private String modelName;
        private Double temperature;
        private Integer topK;
        private Double topP;
        private Double repeatPenalty;
        private Integer seed;
        private Integer numPredict;
        private Integer numCtx;
        private List<String> stop;
        private String format;
        private Duration timeout;
        private Integer maxRetries;
        private Map<String, String> customHeaders;
        private Boolean logRequests;
        private Boolean logResponses;
        private List<ChatModelListener> listeners;

        public OllamaChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OllamaChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OllamaChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public OllamaChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public OllamaChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public OllamaChatModelBuilder repeatPenalty(Double repeatPenalty) {
            this.repeatPenalty = repeatPenalty;
            return this;
        }

        public OllamaChatModelBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public OllamaChatModelBuilder numPredict(Integer numPredict) {
            this.numPredict = numPredict;
            return this;
        }

        public OllamaChatModelBuilder numCtx(Integer numCtx) {
            this.numCtx = numCtx;
            return this;
        }

        public OllamaChatModelBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public OllamaChatModelBuilder format(String format) {
            this.format = format;
            return this;
        }

        public OllamaChatModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OllamaChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public OllamaChatModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public OllamaChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OllamaChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OllamaChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public OllamaChatModel build() {
            return new OllamaChatModel(this.baseUrl, this.modelName, this.temperature, this.topK, this.topP, this.repeatPenalty, this.seed, this.numPredict, this.numCtx, this.stop, this.format, this.timeout, this.maxRetries, this.customHeaders, this.logRequests, this.logResponses, this.listeners);
        }
    }
}

