/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.ollama.ChatRequest;
import dev.langchain4j.model.ollama.ChatResponse;
import dev.langchain4j.model.ollama.CompletionRequest;
import dev.langchain4j.model.ollama.CompletionResponse;
import dev.langchain4j.model.ollama.DeleteModelRequest;
import dev.langchain4j.model.ollama.EmbeddingRequest;
import dev.langchain4j.model.ollama.EmbeddingResponse;
import dev.langchain4j.model.ollama.ModelsListResponse;
import dev.langchain4j.model.ollama.OllamaApi;
import dev.langchain4j.model.ollama.OllamaChatModelListenerUtils;
import dev.langchain4j.model.ollama.OllamaJsonUtils;
import dev.langchain4j.model.ollama.OllamaModelCard;
import dev.langchain4j.model.ollama.OllamaRequestLoggingInterceptor;
import dev.langchain4j.model.ollama.OllamaResponseLoggingInterceptor;
import dev.langchain4j.model.ollama.OllamaStreamingResponseBuilder;
import dev.langchain4j.model.ollama.RunningModelsListResponse;
import dev.langchain4j.model.ollama.ShowModelInformationRequest;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

class OllamaClient {
    private static final Logger log = LoggerFactory.getLogger(OllamaClient.class);
    private final OllamaApi ollamaApi;
    private final boolean logStreamingResponses;

    public OllamaClient(String baseUrl, Duration timeout, Boolean logRequests, Boolean logResponses, Boolean logStreamingResponses, Map<String, String> customHeaders) {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout);
        if (logRequests != null && logRequests.booleanValue()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new OllamaRequestLoggingInterceptor());
        }
        if (logResponses != null && logResponses.booleanValue()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new OllamaResponseLoggingInterceptor());
        }
        boolean bl = this.logStreamingResponses = logStreamingResponses != null && logStreamingResponses != false;
        if (customHeaders != null && !customHeaders.isEmpty()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new GenericHeadersInterceptor(customHeaders));
        }
        OkHttpClient okHttpClient = okHttpClientBuilder.build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(Utils.ensureTrailingForwardSlash((String)baseUrl)).client(okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)OllamaJsonUtils.getObjectMapper())).build();
        this.ollamaApi = (OllamaApi)retrofit.create(OllamaApi.class);
    }

    static Builder builder() {
        return new Builder();
    }

    public CompletionResponse completion(CompletionRequest request) {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.completion(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (CompletionResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ChatResponse chat(ChatRequest request) {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.chat(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (ChatResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void streamingCompletion(CompletionRequest request, final StreamingResponseHandler<String> handler) {
        this.ollamaApi.streamingCompletion(request).enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, retrofit2.Response<ResponseBody> retrofitResponse) {
                try (InputStream inputStream = ((ResponseBody)retrofitResponse.body()).byteStream();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                    StringBuilder contentBuilder = new StringBuilder();
                    while (true) {
                        String partialResponse = reader.readLine();
                        if (OllamaClient.this.logStreamingResponses) {
                            log.debug("Streaming partial response: {}", (Object)partialResponse);
                        }
                        CompletionResponse completionResponse = OllamaJsonUtils.toObject(partialResponse, CompletionResponse.class);
                        contentBuilder.append(completionResponse.getResponse());
                        handler.onNext(completionResponse.getResponse());
                        if (!Boolean.TRUE.equals(completionResponse.getDone())) continue;
                        Response response = Response.from((Object)contentBuilder.toString(), (TokenUsage)new TokenUsage(completionResponse.getPromptEvalCount(), completionResponse.getEvalCount()));
                        handler.onComplete(response);
                        return;
                    }
                }
                catch (Exception e) {
                    handler.onError((Throwable)e);
                    return;
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                handler.onError(throwable);
            }
        });
    }

    public void streamingChat(ChatRequest request, final StreamingResponseHandler<AiMessage> handler, final List<ChatModelListener> listeners, List<ChatMessage> messages) {
        final ChatModelRequest modelListenerRequest = OllamaChatModelListenerUtils.createModelListenerRequest(request, messages, new ArrayList<ToolSpecification>());
        final ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        OllamaChatModelListenerUtils.onListenRequest(listeners, modelListenerRequest, attributes);
        final OllamaStreamingResponseBuilder responseBuilder = new OllamaStreamingResponseBuilder();
        this.ollamaApi.streamingChat(request).enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, retrofit2.Response<ResponseBody> retrofitResponse) {
                try (InputStream inputStream = ((ResponseBody)retrofitResponse.body()).byteStream();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                    while (true) {
                        String partialResponse = reader.readLine();
                        if (OllamaClient.this.logStreamingResponses) {
                            log.debug("Streaming partial response: {}", (Object)partialResponse);
                        }
                        ChatResponse chatResponse = OllamaJsonUtils.toObject(partialResponse, ChatResponse.class);
                        String content = chatResponse.getMessage().getContent();
                        responseBuilder.append(chatResponse);
                        handler.onNext(content);
                        if (!Boolean.TRUE.equals(chatResponse.getDone())) continue;
                        Response<AiMessage> response = responseBuilder.build();
                        handler.onComplete(response);
                        OllamaChatModelListenerUtils.onListenResponse(listeners, response, modelListenerRequest, attributes);
                        return;
                    }
                }
                catch (Exception e) {
                    OllamaChatModelListenerUtils.onListenError(listeners, e, modelListenerRequest, responseBuilder.build(), attributes);
                    handler.onError((Throwable)e);
                    return;
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                OllamaChatModelListenerUtils.onListenError(listeners, throwable, modelListenerRequest, responseBuilder.build(), attributes);
                handler.onError(throwable);
            }
        });
    }

    public EmbeddingResponse embed(EmbeddingRequest request) {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.embed(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (EmbeddingResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ModelsListResponse listModels() {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.listModels().execute();
            if (retrofitResponse.isSuccessful()) {
                return (ModelsListResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public OllamaModelCard showInformation(ShowModelInformationRequest showInformationRequest) {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.showInformation(showInformationRequest).execute();
            if (retrofitResponse.isSuccessful()) {
                return (OllamaModelCard)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RunningModelsListResponse listRunningModels() {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.listRunningModels().execute();
            if (retrofitResponse.isSuccessful()) {
                return (RunningModelsListResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Void deleteModel(DeleteModelRequest deleteModelRequest) {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.deleteModel(deleteModelRequest).execute();
            if (retrofitResponse.isSuccessful()) {
                return (Void)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RuntimeException toException(retrofit2.Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }

    static class GenericHeadersInterceptor
    implements Interceptor {
        private final Map<String, String> headers = new HashMap<String, String>();

        GenericHeadersInterceptor(Map<String, String> headers) {
            Optional.ofNullable(headers).ifPresent(this.headers::putAll);
        }

        @NotNull
        public okhttp3.Response intercept(Interceptor.Chain chain) throws IOException {
            Request.Builder builder = chain.request().newBuilder();
            this.headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
            return chain.proceed(builder.build());
        }
    }

    static class Builder {
        private String baseUrl;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;
        private Boolean logStreamingResponses;
        private Map<String, String> customHeaders;

        Builder() {
        }

        Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        Builder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        Builder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        Builder logStreamingResponses(Boolean logStreamingResponses) {
            this.logStreamingResponses = logStreamingResponses;
            return this;
        }

        Builder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        OllamaClient build() {
            return new OllamaClient(this.baseUrl, this.timeout, this.logRequests, this.logResponses, this.logStreamingResponses, this.customHeaders);
        }
    }
}

