/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.ollama.ChatRequest;
import dev.langchain4j.model.ollama.Options;
import dev.langchain4j.model.output.Response;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OllamaChatModelListenerUtils {
    private static final Logger log = LoggerFactory.getLogger(OllamaChatModelListenerUtils.class);

    private OllamaChatModelListenerUtils() throws InstantiationException {
        throw new InstantiationException("Can't instantiate this utility class.");
    }

    static void onListenRequest(List<ChatModelListener> listeners, ChatModelRequest modelListenerRequest, ModelProvider modelProvider, Map<Object, Object> attributes) {
        ChatModelRequestContext context = new ChatModelRequestContext(modelListenerRequest, modelProvider, attributes);
        listeners.forEach(listener -> {
            try {
                listener.onRequest(context);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", (Throwable)e);
            }
        });
    }

    static void onListenResponse(List<ChatModelListener> listeners, Response<AiMessage> response, ChatModelRequest modelListenerRequest, ModelProvider modelProvider, Map<Object, Object> attributes) {
        ChatModelResponse modelListenerResponse = OllamaChatModelListenerUtils.createModelListenerResponse(modelListenerRequest.model(), response);
        ChatModelResponseContext context = new ChatModelResponseContext(modelListenerResponse, modelListenerRequest, modelProvider, attributes);
        listeners.forEach(listener -> {
            try {
                listener.onResponse(context);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", (Throwable)e);
            }
        });
    }

    static void onListenError(List<ChatModelListener> listeners, Throwable error, ChatModelRequest modelListenerRequest, Response<AiMessage> partialResponse, ModelProvider modelProvider, Map<Object, Object> attributes) {
        ChatModelResponse partialModelListenerResponse = OllamaChatModelListenerUtils.createModelListenerResponse(modelListenerRequest.model(), partialResponse);
        ChatModelErrorContext context = new ChatModelErrorContext(error, modelListenerRequest, partialModelListenerResponse, modelProvider, attributes);
        listeners.forEach(listener -> {
            try {
                listener.onError(context);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", (Throwable)e);
            }
        });
    }

    static ChatModelRequest createModelListenerRequest(ChatRequest request, List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        Options options = request.getOptions();
        return ChatModelRequest.builder().model(request.getModel()).temperature(options.getTemperature()).topP(options.getTopP()).maxTokens(options.getNumPredict()).messages(messages).toolSpecifications(toolSpecifications).build();
    }

    static ChatModelResponse createModelListenerResponse(String responseModel, Response<AiMessage> response) {
        if (response == null) {
            return null;
        }
        return ChatModelResponse.builder().model(responseModel).tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).aiMessage((AiMessage)response.content()).build();
    }
}

