/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.ollama.ChatRequest;
import dev.langchain4j.model.ollama.Options;
import dev.langchain4j.model.output.Response;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OllamaChatModelListenerUtils {
    private static final Logger log = LoggerFactory.getLogger(OllamaChatModelListenerUtils.class);

    private OllamaChatModelListenerUtils() throws InstantiationException {
        throw new InstantiationException("Can't instantiate this utility class.");
    }

    static void onListenRequest(List<ChatModelListener> listeners, dev.langchain4j.model.chat.request.ChatRequest listenerRequest, ModelProvider modelProvider, Map<Object, Object> attributes) {
        ChatModelRequestContext context = new ChatModelRequestContext(listenerRequest, modelProvider, attributes);
        listeners.forEach(listener -> {
            try {
                listener.onRequest(context);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", (Throwable)e);
            }
        });
    }

    static void onListenResponse(List<ChatModelListener> listeners, Response<AiMessage> response, dev.langchain4j.model.chat.request.ChatRequest listenerRequest, ModelProvider modelProvider, Map<Object, Object> attributes) {
        ChatResponse listenerResponse = OllamaChatModelListenerUtils.createListenerResponse(listenerRequest.parameters().modelName(), response);
        ChatModelResponseContext context = new ChatModelResponseContext(listenerResponse, listenerRequest, modelProvider, attributes);
        listeners.forEach(listener -> {
            try {
                listener.onResponse(context);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", (Throwable)e);
            }
        });
    }

    static void onListenError(List<ChatModelListener> listeners, Throwable error, dev.langchain4j.model.chat.request.ChatRequest listenerRequest, ModelProvider modelProvider, Map<Object, Object> attributes) {
        ChatModelErrorContext context = new ChatModelErrorContext(error, listenerRequest, modelProvider, attributes);
        listeners.forEach(listener -> {
            try {
                listener.onError(context);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", (Throwable)e);
            }
        });
    }

    static dev.langchain4j.model.chat.request.ChatRequest createListenerRequest(ChatRequest request, List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        Options options = request.getOptions();
        return dev.langchain4j.model.chat.request.ChatRequest.builder().messages(messages).parameters(ChatRequestParameters.builder().modelName(request.getModel()).temperature(options.getTemperature()).topP(options.getTopP()).maxOutputTokens(options.getNumPredict()).toolSpecifications(toolSpecifications).build()).build();
    }

    static ChatResponse createListenerResponse(String responseModel, Response<AiMessage> response) {
        if (response == null) {
            return null;
        }
        return ChatResponse.builder().aiMessage((AiMessage)response.content()).metadata(ChatResponseMetadata.builder().modelName(responseModel).tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).build()).build();
    }
}

