/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import java.util.Objects;

public class OllamaChatRequestParameters
extends DefaultChatRequestParameters {
    public static final OllamaChatRequestParameters EMPTY = OllamaChatRequestParameters.builder().build();
    private final Integer mirostat;
    private final Double mirostatEta;
    private final Double mirostatTau;
    private final Integer numCtx;
    private final Integer repeatLastN;
    private final Double repeatPenalty;
    private final Integer seed;
    private final Double minP;
    private final Integer keepAlive;

    private OllamaChatRequestParameters(Builder builder) {
        super((DefaultChatRequestParameters.Builder)builder);
        this.mirostat = builder.mirostat;
        this.mirostatEta = builder.mirostatEta;
        this.mirostatTau = builder.mirostatTau;
        this.numCtx = builder.numCtx;
        this.repeatLastN = builder.repeatLastN;
        this.repeatPenalty = builder.repeatPenalty;
        this.seed = builder.seed;
        this.minP = builder.minP;
        this.keepAlive = builder.keepAlive;
    }

    public Integer mirostat() {
        return this.mirostat;
    }

    public Double mirostatEta() {
        return this.mirostatEta;
    }

    public Double mirostatTau() {
        return this.mirostatTau;
    }

    public Integer numCtx() {
        return this.numCtx;
    }

    public Integer repeatLastN() {
        return this.repeatLastN;
    }

    public Double repeatPenalty() {
        return this.repeatPenalty;
    }

    public Integer seed() {
        return this.seed;
    }

    public Double minP() {
        return this.minP;
    }

    public Integer keepAlive() {
        return this.keepAlive;
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OllamaChatRequestParameters that = (OllamaChatRequestParameters)((Object)o);
        return Objects.equals(this.mirostat, that.mirostat) && Objects.equals(this.mirostatEta, that.mirostatEta) && Objects.equals(this.mirostatTau, that.mirostatTau) && Objects.equals(this.numCtx, that.numCtx) && Objects.equals(this.repeatLastN, that.repeatLastN) && Objects.equals(this.repeatPenalty, that.repeatPenalty) && Objects.equals(this.seed, that.seed) && Objects.equals(this.minP, that.minP) && Objects.equals(this.keepAlive, that.keepAlive);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mirostat, this.mirostatEta, this.mirostatTau, this.numCtx, this.repeatLastN, this.repeatPenalty, this.seed, this.minP, this.keepAlive);
    }

    public String toString() {
        return "OllamaChatRequestParameters{modelName=" + Utils.quoted((Object)this.modelName()) + ", temperature=" + this.temperature() + ", topP=" + this.topP() + ", topK=" + this.topK() + ", frequencyPenalty=" + this.frequencyPenalty() + ", presencePenalty=" + this.presencePenalty() + ", maxOutputTokens=" + this.maxOutputTokens() + ", stopSequences=" + String.valueOf(this.stopSequences()) + ", toolSpecifications=" + String.valueOf(this.toolSpecifications()) + ", toolChoice=" + String.valueOf(this.toolChoice()) + ", responseFormat=" + String.valueOf(this.responseFormat()) + ", mirostat=" + this.mirostat + ", mirostatEta=" + this.mirostatEta + ", mirostatTau=" + this.mirostatTau + ", numCtx=" + this.numCtx + ", repeatLastN=" + this.repeatLastN + ", repeatPenalty=" + this.repeatPenalty + ", seed=" + this.seed + ", minP=" + this.minP + ", keepAlive=" + this.keepAlive + "}";
    }

    public OllamaChatRequestParameters overrideWith(ChatRequestParameters that) {
        return OllamaChatRequestParameters.builder().overrideWith((ChatRequestParameters)this).overrideWith(that).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DefaultChatRequestParameters.Builder<Builder> {
        private Integer mirostat;
        private Double mirostatEta;
        private Double mirostatTau;
        private Integer numCtx;
        private Integer repeatLastN;
        private Double repeatPenalty;
        private Integer seed;
        private Double minP;
        private Integer keepAlive;

        public Builder overrideWith(ChatRequestParameters parameters) {
            super.overrideWith(parameters);
            if (parameters instanceof OllamaChatRequestParameters) {
                OllamaChatRequestParameters ollamaChatRequestParameters = (OllamaChatRequestParameters)parameters;
                this.mirostat((Integer)Utils.getOrDefault((Object)ollamaChatRequestParameters.mirostat, (Object)this.mirostat));
                this.mirostatEta((Double)Utils.getOrDefault((Object)ollamaChatRequestParameters.mirostatEta, (Object)this.mirostatEta));
                this.mirostatTau((Double)Utils.getOrDefault((Object)ollamaChatRequestParameters.mirostatTau, (Object)this.mirostatTau));
                this.numCtx((Integer)Utils.getOrDefault((Object)ollamaChatRequestParameters.numCtx, (Object)this.numCtx));
                this.repeatLastN((Integer)Utils.getOrDefault((Object)ollamaChatRequestParameters.repeatLastN, (Object)this.repeatLastN));
                this.repeatPenalty((Double)Utils.getOrDefault((Object)ollamaChatRequestParameters.repeatPenalty, (Object)this.repeatPenalty));
                this.seed((Integer)Utils.getOrDefault((Object)ollamaChatRequestParameters.seed, (Object)this.seed));
                this.minP((Double)Utils.getOrDefault((Object)ollamaChatRequestParameters.minP, (Object)this.minP));
                this.keepAlive((Integer)Utils.getOrDefault((Object)ollamaChatRequestParameters.keepAlive, (Object)this.keepAlive));
            }
            return this;
        }

        public Builder mirostat(Integer mirostat) {
            this.mirostat = mirostat;
            return this;
        }

        public Builder mirostatEta(Double mirostatEta) {
            this.mirostatEta = mirostatEta;
            return this;
        }

        public Builder mirostatTau(Double mirostatTau) {
            this.mirostatTau = mirostatTau;
            return this;
        }

        public Builder numCtx(Integer numCtx) {
            this.numCtx = numCtx;
            return this;
        }

        public Builder repeatLastN(Integer repeatLastN) {
            this.repeatLastN = repeatLastN;
            return this;
        }

        public Builder repeatPenalty(Double repeatPenalty) {
            this.repeatPenalty = repeatPenalty;
            return this;
        }

        public Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public Builder minP(Double minP) {
            this.minP = minP;
            return this;
        }

        public Builder keepAlive(Integer keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public OllamaChatRequestParameters build() {
            return new OllamaChatRequestParameters(this);
        }
    }
}

