/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.openai.spring;

import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.spring.restclient.SpringRestClient;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiChatRequestParameters;
import dev.langchain4j.model.openai.OpenAiEmbeddingModel;
import dev.langchain4j.model.openai.OpenAiImageModel;
import dev.langchain4j.model.openai.OpenAiLanguageModel;
import dev.langchain4j.model.openai.OpenAiModerationModel;
import dev.langchain4j.model.openai.OpenAiStreamingChatModel;
import dev.langchain4j.model.openai.OpenAiStreamingLanguageModel;
import dev.langchain4j.openai.spring.ChatModelProperties;
import dev.langchain4j.openai.spring.EmbeddingModelProperties;
import dev.langchain4j.openai.spring.ImageModelProperties;
import dev.langchain4j.openai.spring.LanguageModelProperties;
import dev.langchain4j.openai.spring.ModerationModelProperties;
import dev.langchain4j.openai.spring.Properties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.support.ContextPropagatingTaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class})
@EnableConfigurationProperties(value={Properties.class})
public class AutoConfig {
    private static final String TASK_EXECUTOR_THREAD_NAME_PREFIX = "LangChain4j-OpenAI-";
    private static final String CHAT_MODEL_HTTP_CLIENT_BUILDER = "openAiChatModelHttpClientBuilder";
    private static final String STREAMING_CHAT_MODEL_HTTP_CLIENT_BUILDER = "openAiStreamingChatModelHttpClientBuilder";
    private static final String STREAMING_CHAT_MODEL_TASK_EXECUTOR = "openAiStreamingChatModelTaskExecutor";
    private static final String LANGUAGE_MODEL_HTTP_CLIENT_BUILDER = "openAiLanguageModelHttpClientBuilder";
    private static final String STREAMING_LANGUAGE_MODEL_HTTP_CLIENT_BUILDER = "openAiStreamingLanguageModelHttpClientBuilder";
    private static final String STREAMING_LANGUAGE_MODEL_TASK_EXECUTOR = "openAiStreamingLanguageModelTaskExecutor";
    private static final String EMBEDDING_MODEL_HTTP_CLIENT_BUILDER = "openAiEmbeddingModelHttpClientBuilder";
    private static final String MODERATION_MODEL_HTTP_CLIENT_BUILDER = "openAiModerationModelHttpClientBuilder";
    private static final String IMAGE_MODEL_HTTP_CLIENT_BUILDER = "openAiImageModelHttpClientBuilder";

    @Bean
    @ConditionalOnProperty(value={"langchain4j.open-ai.chat-model.api-key"})
    OpenAiChatModel openAiChatModel(@Qualifier(value="openAiChatModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties, ObjectProvider<ChatModelListener> listeners) {
        ChatModelProperties chatModelProperties = properties.chatModel();
        return OpenAiChatModel.builder().httpClientBuilder(httpClientBuilder).baseUrl(chatModelProperties.baseUrl()).apiKey(chatModelProperties.apiKey()).organizationId(chatModelProperties.organizationId()).projectId(chatModelProperties.projectId()).modelName(chatModelProperties.modelName()).temperature(chatModelProperties.temperature()).topP(chatModelProperties.topP()).stop(chatModelProperties.stop()).maxTokens(chatModelProperties.maxTokens()).maxCompletionTokens(chatModelProperties.maxCompletionTokens()).presencePenalty(chatModelProperties.presencePenalty()).frequencyPenalty(chatModelProperties.frequencyPenalty()).logitBias(chatModelProperties.logitBias()).responseFormat(chatModelProperties.responseFormat()).supportedCapabilities(chatModelProperties.supportedCapabilities()).strictJsonSchema(chatModelProperties.strictJsonSchema()).seed(chatModelProperties.seed()).user(chatModelProperties.user()).strictTools(chatModelProperties.strictTools()).parallelToolCalls(chatModelProperties.parallelToolCalls()).store(chatModelProperties.store()).metadata(chatModelProperties.metadata()).serviceTier(chatModelProperties.serviceTier()).defaultRequestParameters((ChatRequestParameters)OpenAiChatRequestParameters.builder().reasoningEffort(chatModelProperties.reasoningEffort()).build()).returnThinking(chatModelProperties.returnThinking()).timeout(chatModelProperties.timeout()).maxRetries(chatModelProperties.maxRetries()).logRequests(chatModelProperties.logRequests()).logResponses(chatModelProperties.logResponses()).customHeaders(chatModelProperties.customHeaders()).listeners(listeners.orderedStream().toList()).build();
    }

    @Bean(value={"openAiChatModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.open-ai.chat-model.api-key"})
    @ConditionalOnMissingBean(name={"openAiChatModelHttpClientBuilder"})
    HttpClientBuilder openAiChatModelHttpClientBuilder(ObjectProvider<RestClient.Builder> restClientBuilder) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).createDefaultStreamingRequestExecutor(Boolean.valueOf(false));
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.open-ai.streaming-chat-model.api-key"})
    OpenAiStreamingChatModel openAiStreamingChatModel(@Qualifier(value="openAiStreamingChatModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties, ObjectProvider<ChatModelListener> listeners) {
        ChatModelProperties chatModelProperties = properties.streamingChatModel();
        return OpenAiStreamingChatModel.builder().httpClientBuilder(httpClientBuilder).baseUrl(chatModelProperties.baseUrl()).apiKey(chatModelProperties.apiKey()).organizationId(chatModelProperties.organizationId()).projectId(chatModelProperties.projectId()).modelName(chatModelProperties.modelName()).temperature(chatModelProperties.temperature()).topP(chatModelProperties.topP()).stop(chatModelProperties.stop()).maxTokens(chatModelProperties.maxTokens()).maxCompletionTokens(chatModelProperties.maxCompletionTokens()).presencePenalty(chatModelProperties.presencePenalty()).frequencyPenalty(chatModelProperties.frequencyPenalty()).logitBias(chatModelProperties.logitBias()).responseFormat(chatModelProperties.responseFormat()).seed(chatModelProperties.seed()).user(chatModelProperties.user()).strictTools(chatModelProperties.strictTools()).parallelToolCalls(chatModelProperties.parallelToolCalls()).store(chatModelProperties.store()).metadata(chatModelProperties.metadata()).serviceTier(chatModelProperties.serviceTier()).defaultRequestParameters((ChatRequestParameters)OpenAiChatRequestParameters.builder().reasoningEffort(chatModelProperties.reasoningEffort()).build()).returnThinking(chatModelProperties.returnThinking()).timeout(chatModelProperties.timeout()).logRequests(chatModelProperties.logRequests()).logResponses(chatModelProperties.logResponses()).customHeaders(chatModelProperties.customHeaders()).listeners(listeners.orderedStream().toList()).build();
    }

    @Bean(value={"openAiStreamingChatModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.open-ai.streaming-chat-model.api-key"})
    @ConditionalOnMissingBean(name={"openAiStreamingChatModelHttpClientBuilder"})
    HttpClientBuilder openAiStreamingChatModelHttpClientBuilder(ObjectProvider<RestClient.Builder> restClientBuilder, @Qualifier(value="openAiStreamingChatModelTaskExecutor") AsyncTaskExecutor executor) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).streamingRequestExecutor(executor);
    }

    @Bean(value={"openAiStreamingChatModelTaskExecutor"})
    @ConditionalOnProperty(value={"langchain4j.open-ai.streaming-chat-model.api-key"})
    @ConditionalOnMissingBean(name={"openAiStreamingChatModelTaskExecutor"})
    @ConditionalOnClass(name={"io.micrometer.context.ContextSnapshotFactory"})
    AsyncTaskExecutor openAiStreamingChatModelTaskExecutorWithContextPropagation() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setThreadNamePrefix(TASK_EXECUTOR_THREAD_NAME_PREFIX);
        taskExecutor.setTaskDecorator((TaskDecorator)new ContextPropagatingTaskDecorator());
        return taskExecutor;
    }

    @Bean(value={"openAiStreamingChatModelTaskExecutor"})
    @ConditionalOnProperty(value={"langchain4j.open-ai.streaming-chat-model.api-key"})
    @ConditionalOnMissingBean(name={"openAiStreamingChatModelTaskExecutor"})
    @ConditionalOnMissingClass(value={"io.micrometer.context.ContextSnapshotFactory"})
    AsyncTaskExecutor openAiStreamingChatModelTaskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setThreadNamePrefix(TASK_EXECUTOR_THREAD_NAME_PREFIX);
        return taskExecutor;
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.open-ai.language-model.api-key"})
    OpenAiLanguageModel openAiLanguageModel(@Qualifier(value="openAiLanguageModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties) {
        LanguageModelProperties languageModelProperties = properties.languageModel();
        return OpenAiLanguageModel.builder().httpClientBuilder(httpClientBuilder).baseUrl(languageModelProperties.baseUrl()).apiKey(languageModelProperties.apiKey()).organizationId(languageModelProperties.organizationId()).projectId(languageModelProperties.projectId()).modelName(languageModelProperties.modelName()).temperature(languageModelProperties.temperature()).timeout(languageModelProperties.timeout()).maxRetries(languageModelProperties.maxRetries()).logRequests(languageModelProperties.logRequests()).logResponses(languageModelProperties.logResponses()).customHeaders(languageModelProperties.customHeaders()).build();
    }

    @Bean(value={"openAiLanguageModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.open-ai.language-model.api-key"})
    @ConditionalOnMissingBean(name={"openAiLanguageModelHttpClientBuilder"})
    HttpClientBuilder openAiLanguageModelHttpClientBuilder(ObjectProvider<RestClient.Builder> restClientBuilder) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).createDefaultStreamingRequestExecutor(Boolean.valueOf(false));
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.open-ai.streaming-language-model.api-key"})
    OpenAiStreamingLanguageModel openAiStreamingLanguageModel(@Qualifier(value="openAiStreamingLanguageModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties) {
        LanguageModelProperties languageModelProperties = properties.streamingLanguageModel();
        return OpenAiStreamingLanguageModel.builder().httpClientBuilder(httpClientBuilder).baseUrl(languageModelProperties.baseUrl()).apiKey(languageModelProperties.apiKey()).organizationId(languageModelProperties.organizationId()).projectId(languageModelProperties.projectId()).modelName(languageModelProperties.modelName()).temperature(languageModelProperties.temperature()).timeout(languageModelProperties.timeout()).logRequests(languageModelProperties.logRequests()).logResponses(languageModelProperties.logResponses()).customHeaders(languageModelProperties.customHeaders()).build();
    }

    @Bean(value={"openAiStreamingLanguageModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.open-ai.streaming-language-model.api-key"})
    @ConditionalOnMissingBean(name={"openAiStreamingLanguageModelHttpClientBuilder"})
    HttpClientBuilder openAiStreamingLanguageModelHttpClientBuilder(@Qualifier(value="openAiStreamingLanguageModelTaskExecutor") AsyncTaskExecutor executor, ObjectProvider<RestClient.Builder> restClientBuilder) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).streamingRequestExecutor(executor);
    }

    @Bean(value={"openAiStreamingLanguageModelTaskExecutor"})
    @ConditionalOnProperty(value={"langchain4j.open-ai.streaming-language-model.api-key"})
    @ConditionalOnMissingBean(name={"openAiStreamingLanguageModelTaskExecutor"})
    @ConditionalOnClass(name={"io.micrometer.context.ContextSnapshotFactory"})
    AsyncTaskExecutor openAiStreamingLanguageModelTaskExecutorWithContextPropagation() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setThreadNamePrefix(TASK_EXECUTOR_THREAD_NAME_PREFIX);
        taskExecutor.setTaskDecorator((TaskDecorator)new ContextPropagatingTaskDecorator());
        return taskExecutor;
    }

    @Bean(value={"openAiStreamingLanguageModelTaskExecutor"})
    @ConditionalOnProperty(value={"langchain4j.open-ai.streaming-language-model.api-key"})
    @ConditionalOnMissingBean(name={"openAiStreamingLanguageModelTaskExecutor"})
    @ConditionalOnMissingClass(value={"io.micrometer.context.ContextSnapshotFactory"})
    AsyncTaskExecutor openAiStreamingLanguageModelTaskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setThreadNamePrefix(TASK_EXECUTOR_THREAD_NAME_PREFIX);
        return taskExecutor;
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.open-ai.embedding-model.api-key"})
    OpenAiEmbeddingModel openAiEmbeddingModel(@Qualifier(value="openAiEmbeddingModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties) {
        EmbeddingModelProperties embeddingModelProperties = properties.embeddingModel();
        return OpenAiEmbeddingModel.builder().httpClientBuilder(httpClientBuilder).baseUrl(embeddingModelProperties.baseUrl()).apiKey(embeddingModelProperties.apiKey()).organizationId(embeddingModelProperties.organizationId()).projectId(embeddingModelProperties.projectId()).modelName(embeddingModelProperties.modelName()).dimensions(embeddingModelProperties.dimensions()).maxSegmentsPerBatch(embeddingModelProperties.maxSegmentsPerBatch()).user(embeddingModelProperties.user()).timeout(embeddingModelProperties.timeout()).maxRetries(embeddingModelProperties.maxRetries()).logRequests(embeddingModelProperties.logRequests()).logResponses(embeddingModelProperties.logResponses()).customHeaders(embeddingModelProperties.customHeaders()).build();
    }

    @Bean(value={"openAiEmbeddingModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.open-ai.embedding-model.api-key"})
    @ConditionalOnMissingBean(name={"openAiEmbeddingModelHttpClientBuilder"})
    HttpClientBuilder openAiEmbeddingModelHttpClientBuilder(ObjectProvider<RestClient.Builder> restClientBuilder) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).createDefaultStreamingRequestExecutor(Boolean.valueOf(false));
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.open-ai.moderation-model.api-key"})
    OpenAiModerationModel openAiModerationModel(@Qualifier(value="openAiModerationModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties) {
        ModerationModelProperties moderationModelProperties = properties.moderationModel();
        return OpenAiModerationModel.builder().httpClientBuilder(httpClientBuilder).baseUrl(moderationModelProperties.baseUrl()).apiKey(moderationModelProperties.apiKey()).organizationId(moderationModelProperties.organizationId()).projectId(moderationModelProperties.projectId()).modelName(moderationModelProperties.modelName()).timeout(moderationModelProperties.timeout()).maxRetries(moderationModelProperties.maxRetries()).logRequests(moderationModelProperties.logRequests()).logResponses(moderationModelProperties.logResponses()).customHeaders(moderationModelProperties.customHeaders()).build();
    }

    @Bean(value={"openAiModerationModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.open-ai.moderation-model.api-key"})
    @ConditionalOnMissingBean(name={"openAiModerationModelHttpClientBuilder"})
    HttpClientBuilder openAiModerationModelHttpClientBuilder(ObjectProvider<RestClient.Builder> restClientBuilder) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).createDefaultStreamingRequestExecutor(Boolean.valueOf(false));
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.open-ai.image-model.api-key"})
    OpenAiImageModel openAiImageModel(@Qualifier(value="openAiImageModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties) {
        ImageModelProperties imageModelProperties = properties.imageModel();
        return OpenAiImageModel.builder().httpClientBuilder(httpClientBuilder).baseUrl(imageModelProperties.baseUrl()).apiKey(imageModelProperties.apiKey()).organizationId(imageModelProperties.organizationId()).projectId(imageModelProperties.projectId()).modelName(imageModelProperties.modelName()).size(imageModelProperties.size()).quality(imageModelProperties.quality()).style(imageModelProperties.style()).user(imageModelProperties.user()).responseFormat(imageModelProperties.responseFormat()).timeout(imageModelProperties.timeout()).maxRetries(imageModelProperties.maxRetries()).logRequests(imageModelProperties.logRequests()).logResponses(imageModelProperties.logResponses()).customHeaders(imageModelProperties.customHeaders()).build();
    }

    @Bean(value={"openAiImageModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.open-ai.image-model.api-key"})
    @ConditionalOnMissingBean(name={"openAiImageModelHttpClientBuilder"})
    HttpClientBuilder openAiImageModelHttpClientBuilder(ObjectProvider<RestClient.Builder> restClientBuilder) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).createDefaultStreamingRequestExecutor(Boolean.valueOf(false));
    }
}

