/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.ai4j.openai4j.chat.ChatCompletionChoice;
import dev.ai4j.openai4j.chat.ChatCompletionResponse;
import dev.ai4j.openai4j.chat.Function;
import dev.ai4j.openai4j.chat.FunctionCall;
import dev.ai4j.openai4j.chat.Message;
import dev.ai4j.openai4j.chat.Parameters;
import dev.ai4j.openai4j.chat.Role;
import dev.ai4j.openai4j.shared.Usage;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolParameters;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class InternalOpenAiHelper {
    static final String OPENAI_URL = "https://api.openai.com/v1";
    static final String OPENAI_DEMO_API_KEY = "demo";
    static final String OPENAI_DEMO_URL = "http://langchain4j.dev/demo/openai/v1";

    static Duration defaultTimeoutFor(String modelName) {
        if (modelName.startsWith("gpt-3.5-turbo")) {
            return Duration.ofSeconds(7L);
        }
        if (modelName.startsWith("gpt-4")) {
            return Duration.ofSeconds(20L);
        }
        return Duration.ofSeconds(10L);
    }

    public static List<Message> toOpenAiMessages(List<ChatMessage> messages) {
        return messages.stream().map(InternalOpenAiHelper::toOpenAiMessage).collect(Collectors.toList());
    }

    public static Message toOpenAiMessage(ChatMessage message) {
        return Message.builder().role(InternalOpenAiHelper.roleFrom(message)).name(InternalOpenAiHelper.nameFrom(message)).content(message.text()).functionCall(InternalOpenAiHelper.functionCallFrom(message)).build();
    }

    private static String nameFrom(ChatMessage message) {
        if (message instanceof UserMessage) {
            return ((UserMessage)message).name();
        }
        if (message instanceof ToolExecutionResultMessage) {
            return ((ToolExecutionResultMessage)message).toolName();
        }
        return null;
    }

    private static FunctionCall functionCallFrom(ChatMessage message) {
        AiMessage aiMessage;
        if (message instanceof AiMessage && (aiMessage = (AiMessage)message).toolExecutionRequest() != null) {
            return FunctionCall.builder().name(aiMessage.toolExecutionRequest().name()).arguments(aiMessage.toolExecutionRequest().arguments()).build();
        }
        return null;
    }

    public static Role roleFrom(ChatMessage message) {
        if (message instanceof AiMessage) {
            return Role.ASSISTANT;
        }
        if (message instanceof ToolExecutionResultMessage) {
            return Role.FUNCTION;
        }
        if (message instanceof SystemMessage) {
            return Role.SYSTEM;
        }
        return Role.USER;
    }

    public static List<Function> toFunctions(Collection<ToolSpecification> toolSpecifications) {
        return toolSpecifications.stream().map(InternalOpenAiHelper::toFunction).collect(Collectors.toList());
    }

    private static Function toFunction(ToolSpecification toolSpecification) {
        return Function.builder().name(toolSpecification.name()).description(toolSpecification.description()).parameters(InternalOpenAiHelper.toOpenAiParameters(toolSpecification.parameters())).build();
    }

    private static Parameters toOpenAiParameters(ToolParameters toolParameters) {
        if (toolParameters == null) {
            return Parameters.builder().build();
        }
        return Parameters.builder().properties(toolParameters.properties()).required(toolParameters.required()).build();
    }

    public static AiMessage aiMessageFrom(ChatCompletionResponse response) {
        if (response.content() != null) {
            return AiMessage.aiMessage((String)response.content());
        }
        FunctionCall functionCall = ((ChatCompletionChoice)response.choices().get(0)).message().functionCall();
        ToolExecutionRequest toolExecutionRequest = ToolExecutionRequest.builder().name(functionCall.name()).arguments(functionCall.arguments()).build();
        return AiMessage.aiMessage((ToolExecutionRequest)toolExecutionRequest);
    }

    public static TokenUsage tokenUsageFrom(Usage openAiUsage) {
        if (openAiUsage == null) {
            return null;
        }
        return new TokenUsage(openAiUsage.promptTokens(), openAiUsage.completionTokens(), openAiUsage.totalTokens());
    }

    public static FinishReason finishReasonFrom(String openAiFinishReason) {
        switch (openAiFinishReason) {
            case "stop": {
                return FinishReason.STOP;
            }
            case "length": {
                return FinishReason.LENGTH;
            }
            case "function_call": {
                return FinishReason.TOOL_EXECUTION;
            }
            case "content_filter": {
                return FinishReason.CONTENT_FILTER;
            }
        }
        return null;
    }
}

