/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.ai4j.openai4j.chat.ChatCompletionChoice;
import dev.ai4j.openai4j.chat.ChatCompletionResponse;
import dev.ai4j.openai4j.chat.Delta;
import dev.ai4j.openai4j.chat.FunctionCall;
import dev.ai4j.openai4j.completion.CompletionChoice;
import dev.ai4j.openai4j.completion.CompletionResponse;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.openai.InternalOpenAiHelper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.util.List;

public class OpenAiStreamingResponseBuilder {
    private final StringBuilder contentBuilder = new StringBuilder();
    private final StringBuilder toolNameBuilder = new StringBuilder();
    private final StringBuilder toolArgumentsBuilder = new StringBuilder();
    private final Integer inputTokenCount;
    private int outputTokenCount;
    private String finishReason;

    public OpenAiStreamingResponseBuilder(Integer inputTokenCount) {
        this.inputTokenCount = inputTokenCount;
    }

    public void append(ChatCompletionResponse partialResponse) {
        Delta delta;
        if (partialResponse == null) {
            return;
        }
        List choices = partialResponse.choices();
        if (choices == null || choices.isEmpty()) {
            return;
        }
        ChatCompletionChoice chatCompletionChoice = (ChatCompletionChoice)choices.get(0);
        if (chatCompletionChoice == null) {
            return;
        }
        String finishReason = chatCompletionChoice.finishReason();
        if (finishReason != null) {
            this.finishReason = finishReason;
        }
        if ((delta = chatCompletionChoice.delta()) == null) {
            return;
        }
        String content = delta.content();
        if (content != null) {
            this.contentBuilder.append(content);
            ++this.outputTokenCount;
            return;
        }
        FunctionCall functionCall = delta.functionCall();
        if (functionCall != null) {
            if (functionCall.name() != null) {
                this.toolNameBuilder.append(functionCall.name());
                ++this.outputTokenCount;
            }
            if (functionCall.arguments() != null) {
                this.toolArgumentsBuilder.append(functionCall.arguments());
                ++this.outputTokenCount;
            }
        }
    }

    public void append(CompletionResponse partialResponse) {
        String token;
        if (partialResponse == null) {
            return;
        }
        List choices = partialResponse.choices();
        if (choices == null || choices.isEmpty()) {
            return;
        }
        CompletionChoice completionChoice = (CompletionChoice)choices.get(0);
        if (completionChoice == null) {
            return;
        }
        String finishReason = completionChoice.finishReason();
        if (finishReason != null) {
            this.finishReason = finishReason;
        }
        if ((token = completionChoice.text()) != null) {
            this.contentBuilder.append(token);
            ++this.outputTokenCount;
        }
    }

    public Response<AiMessage> build() {
        String content = this.contentBuilder.toString();
        if (!content.isEmpty()) {
            return Response.from((Object)AiMessage.from((String)content), (TokenUsage)new TokenUsage(this.inputTokenCount, Integer.valueOf(this.outputTokenCount)), (FinishReason)InternalOpenAiHelper.finishReasonFrom(this.finishReason));
        }
        String toolName = this.toolNameBuilder.toString();
        if (!toolName.isEmpty()) {
            return Response.from((Object)AiMessage.from((ToolExecutionRequest)ToolExecutionRequest.builder().name(toolName).arguments(this.toolArgumentsBuilder.toString()).build()), (TokenUsage)new TokenUsage(this.inputTokenCount, Integer.valueOf(this.outputTokenCount)), (FinishReason)InternalOpenAiHelper.finishReasonFrom(this.finishReason));
        }
        return null;
    }
}

