/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolParameters;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Json;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.Tokenizer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class OpenAiTokenizer
implements Tokenizer {
    private final String modelName;
    private final Optional<Encoding> encoding;

    public OpenAiTokenizer(String modelName) {
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.encoding = Encodings.newLazyEncodingRegistry().getEncodingForModel(modelName);
    }

    public int estimateTokenCountInText(String text) {
        return this.encoding.orElseThrow(this.unknownModelException()).countTokensOrdinary(text);
    }

    public int estimateTokenCountInMessage(ChatMessage message) {
        AiMessage aiMessage;
        UserMessage userMessage;
        int tokenCount = 1;
        tokenCount += this.extraTokensPerMessage();
        tokenCount += this.estimateTokenCountInText(message.text());
        if (message instanceof UserMessage && (userMessage = (UserMessage)message).name() != null && !this.modelName.equals("gpt-4-vision-preview")) {
            tokenCount += this.extraTokensPerName();
            tokenCount += this.estimateTokenCountInText(userMessage.name());
        }
        if (message instanceof AiMessage && (aiMessage = (AiMessage)message).toolExecutionRequests() != null) {
            tokenCount = this.modelName.contains("1106") ? (tokenCount += 6) : (tokenCount += 3);
            if (aiMessage.toolExecutionRequests().size() == 1) {
                --tokenCount;
                ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
                tokenCount += this.estimateTokenCountInText(toolExecutionRequest.name()) * 2;
                tokenCount += this.estimateTokenCountInText(toolExecutionRequest.arguments());
            } else {
                tokenCount += 15;
                for (ToolExecutionRequest toolExecutionRequest : aiMessage.toolExecutionRequests()) {
                    tokenCount += 7;
                    tokenCount += this.estimateTokenCountInText(toolExecutionRequest.name());
                    Map arguments = (Map)Json.fromJson((String)toolExecutionRequest.arguments(), Map.class);
                    for (Map.Entry argument : arguments.entrySet()) {
                        tokenCount += 2;
                        tokenCount += this.estimateTokenCountInText(argument.getKey().toString());
                        tokenCount += this.estimateTokenCountInText(argument.getValue().toString());
                    }
                }
            }
        }
        return tokenCount;
    }

    private int extraTokensPerMessage() {
        if (this.modelName.equals("gpt-3.5-turbo-0301")) {
            return 4;
        }
        return 3;
    }

    private int extraTokensPerName() {
        if (this.modelName.equals("gpt-3.5-turbo-0301")) {
            return -1;
        }
        return 1;
    }

    public int estimateTokenCountInMessages(Iterable<ChatMessage> messages) {
        int tokenCount = 3;
        for (ChatMessage message : messages) {
            tokenCount += this.estimateTokenCountInMessage(message);
        }
        return tokenCount;
    }

    public int estimateTokenCountInToolSpecifications(Iterable<ToolSpecification> toolSpecifications) {
        int tokenCount = 16;
        for (ToolSpecification toolSpecification : toolSpecifications) {
            tokenCount += 6;
            tokenCount += this.estimateTokenCountInText(toolSpecification.name());
            if (toolSpecification.description() != null) {
                tokenCount += 2;
                tokenCount += this.estimateTokenCountInText(toolSpecification.description());
            }
            tokenCount += this.estimateTokenCountInToolParameters(toolSpecification.parameters());
        }
        return tokenCount;
    }

    private int estimateTokenCountInToolParameters(ToolParameters parameters) {
        if (parameters == null) {
            return 0;
        }
        int tokenCount = 3;
        Map properties = parameters.properties();
        if (this.modelName.contains("1106")) {
            tokenCount += properties.size() - 1;
        }
        for (String property : properties.keySet()) {
            tokenCount = this.modelName.contains("1106") ? (tokenCount += 2) : (tokenCount += 3);
            tokenCount += this.estimateTokenCountInText(property);
            for (Map.Entry entry : ((Map)properties.get(property)).entrySet()) {
                if ("type".equals(entry.getKey())) {
                    if (!"array".equals(entry.getValue()) || !this.modelName.contains("1106")) continue;
                    ++tokenCount;
                    continue;
                }
                if ("description".equals(entry.getKey())) {
                    tokenCount += 2;
                    tokenCount += this.estimateTokenCountInText(entry.getValue().toString());
                    if (!this.modelName.contains("1106") || !parameters.required().contains(property)) continue;
                    ++tokenCount;
                    continue;
                }
                if (!"enum".equals(entry.getKey())) continue;
                tokenCount = this.modelName.contains("1106") ? (tokenCount -= 2) : (tokenCount -= 3);
                for (Object enumValue : (Object[])entry.getValue()) {
                    tokenCount += 3;
                    tokenCount += this.estimateTokenCountInText(enumValue.toString());
                }
            }
        }
        return tokenCount;
    }

    public int estimateTokenCountInForcefulToolSpecification(ToolSpecification toolSpecification) {
        int tokenCount = this.estimateTokenCountInToolSpecifications(Collections.singletonList(toolSpecification));
        tokenCount += 4;
        tokenCount += this.estimateTokenCountInText(toolSpecification.name());
        if (this.modelName.contains("1106")) {
            tokenCount += 3;
        }
        return tokenCount;
    }

    public List<Integer> encode(String text) {
        return this.encoding.orElseThrow(this.unknownModelException()).encodeOrdinary(text);
    }

    public List<Integer> encode(String text, int maxTokensToEncode) {
        return this.encoding.orElseThrow(this.unknownModelException()).encodeOrdinary(text, maxTokensToEncode).getTokens();
    }

    public String decode(List<Integer> tokens) {
        return this.encoding.orElseThrow(this.unknownModelException()).decode(tokens);
    }

    private Supplier<IllegalArgumentException> unknownModelException() {
        return () -> Exceptions.illegalArgument((String)"Model '%s' is unknown to jtokkit", (Object[])new Object[]{this.modelName});
    }

    public int estimateTokenCountInToolExecutionRequests(Iterable<ToolExecutionRequest> toolExecutionRequests) {
        int tokenCount = 0;
        int toolsCount = 0;
        int toolsWithArgumentsCount = 0;
        int toolsWithoutArgumentsCount = 0;
        int totalArgumentsCount = 0;
        for (ToolExecutionRequest toolExecutionRequest : toolExecutionRequests) {
            tokenCount += 4;
            tokenCount += this.estimateTokenCountInText(toolExecutionRequest.name());
            tokenCount += this.estimateTokenCountInText(toolExecutionRequest.arguments());
            int argumentCount = OpenAiTokenizer.countArguments(toolExecutionRequest.arguments());
            if (argumentCount == 0) {
                ++toolsWithoutArgumentsCount;
            } else {
                ++toolsWithArgumentsCount;
            }
            totalArgumentsCount += argumentCount;
            ++toolsCount;
        }
        if (this.modelName.equals("gpt-3.5-turbo-1106")) {
            tokenCount += 16;
            tokenCount += 3 * toolsWithoutArgumentsCount;
            tokenCount += toolsCount;
            if (totalArgumentsCount > 0) {
                --tokenCount;
                tokenCount -= 2 * totalArgumentsCount;
                tokenCount += 2 * toolsWithArgumentsCount;
                tokenCount += toolsCount;
            }
        }
        if (this.modelName.equals("gpt-4-1106-preview")) {
            tokenCount += 3;
            if (toolsCount > 1) {
                tokenCount += 18;
                tokenCount += 15 * toolsCount;
                tokenCount += totalArgumentsCount;
                tokenCount -= 3 * toolsWithoutArgumentsCount;
            }
        }
        return tokenCount;
    }

    public int estimateTokenCountInForcefulToolExecutionRequest(ToolExecutionRequest toolExecutionRequest) {
        if (this.modelName.equals("gpt-4-1106-preview")) {
            int argumentsCount = OpenAiTokenizer.countArguments(toolExecutionRequest.arguments());
            if (argumentsCount == 0) {
                return 1;
            }
            return this.estimateTokenCountInText(toolExecutionRequest.arguments());
        }
        int tokenCount = this.estimateTokenCountInToolExecutionRequests(Collections.singletonList(toolExecutionRequest));
        tokenCount -= 4;
        tokenCount -= this.estimateTokenCountInText(toolExecutionRequest.name());
        if (this.modelName.equals("gpt-3.5-turbo-1106")) {
            int argumentsCount = OpenAiTokenizer.countArguments(toolExecutionRequest.arguments());
            if (argumentsCount == 0) {
                return 1;
            }
            tokenCount -= 19;
            tokenCount += 2 * argumentsCount;
        }
        return tokenCount;
    }

    static int countArguments(String arguments) {
        if (Utils.isNullOrBlank((String)arguments)) {
            return 0;
        }
        Map argumentsMap = (Map)Json.fromJson((String)arguments, Map.class);
        return argumentsMap.size();
    }
}

