/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.OpenAiHttpException;
import dev.ai4j.openai4j.chat.ChatCompletionChoice;
import dev.ai4j.openai4j.chat.ChatCompletionRequest;
import dev.ai4j.openai4j.chat.ChatCompletionResponse;
import dev.ai4j.openai4j.chat.ResponseFormat;
import dev.ai4j.openai4j.chat.ResponseFormatType;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.TokenCountEstimator;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.openai.InternalOpenAiHelper;
import dev.langchain4j.model.openai.OpenAiChatModelName;
import dev.langchain4j.model.openai.OpenAiTokenizer;
import dev.langchain4j.model.openai.spi.OpenAiChatModelBuilderFactory;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAiChatModel
implements ChatLanguageModel,
TokenCountEstimator {
    private static final Logger log = LoggerFactory.getLogger(OpenAiChatModel.class);
    private final OpenAiClient client;
    private final String modelName;
    private final Double temperature;
    private final Double topP;
    private final List<String> stop;
    private final Integer maxTokens;
    private final Integer maxCompletionTokens;
    private final Double presencePenalty;
    private final Double frequencyPenalty;
    private final Map<String, Integer> logitBias;
    private final ResponseFormat responseFormat;
    private final Boolean strictJsonSchema;
    private final Integer seed;
    private final String user;
    private final Boolean strictTools;
    private final Boolean parallelToolCalls;
    private final Integer maxRetries;
    private final Tokenizer tokenizer;
    private final List<ChatModelListener> listeners;

    public OpenAiChatModel(String baseUrl, String apiKey, String organizationId, String modelName, Double temperature, Double topP, List<String> stop, Integer maxTokens, Integer maxCompletionTokens, Double presencePenalty, Double frequencyPenalty, Map<String, Integer> logitBias, String responseFormat, Boolean strictJsonSchema, Integer seed, String user, Boolean strictTools, Boolean parallelToolCalls, Duration timeout, Integer maxRetries, Proxy proxy, Boolean logRequests, Boolean logResponses, Tokenizer tokenizer, Map<String, String> customHeaders, List<ChatModelListener> listeners) {
        baseUrl = (String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.openai.com/v1");
        if ("demo".equals(apiKey)) {
            baseUrl = "http://langchain4j.dev/demo/openai/v1";
        }
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        this.client = OpenAiClient.builder().openAiApiKey(apiKey).baseUrl(baseUrl).organizationId(organizationId).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).proxy(proxy).logRequests(logRequests).logResponses(logResponses).userAgent("langchain4j-openai").customHeaders(customHeaders).build();
        this.modelName = (String)Utils.getOrDefault((Object)modelName, (Object)"gpt-3.5-turbo");
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
        this.topP = topP;
        this.stop = stop;
        this.maxTokens = maxTokens;
        this.maxCompletionTokens = maxCompletionTokens;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.responseFormat = responseFormat == null ? null : ResponseFormat.builder().type(ResponseFormatType.valueOf((String)responseFormat.toUpperCase(Locale.ROOT))).build();
        this.strictJsonSchema = (Boolean)Utils.getOrDefault((Object)strictJsonSchema, (Object)false);
        this.seed = seed;
        this.user = user;
        this.strictTools = (Boolean)Utils.getOrDefault((Object)strictTools, (Object)false);
        this.parallelToolCalls = parallelToolCalls;
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.tokenizer = (Tokenizer)Utils.getOrDefault((Object)tokenizer, OpenAiTokenizer::new);
        this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
    }

    public String modelName() {
        return this.modelName;
    }

    public Set<Capability> supportedCapabilities() {
        HashSet<Capability> capabilities = new HashSet<Capability>();
        if (this.responseFormat != null && this.responseFormat.type() == ResponseFormatType.JSON_SCHEMA) {
            capabilities.add(Capability.RESPONSE_FORMAT_JSON_SCHEMA);
        }
        return capabilities;
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        return this.generate(messages, null, null, this.responseFormat);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        return this.generate(messages, toolSpecifications, null, this.responseFormat);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        return this.generate(messages, Collections.singletonList(toolSpecification), toolSpecification, this.responseFormat);
    }

    public ChatResponse chat(ChatRequest request) {
        Response<AiMessage> response = this.generate(request.messages(), request.toolSpecifications(), null, (ResponseFormat)Utils.getOrDefault((Object)InternalOpenAiHelper.toOpenAiResponseFormat(request.responseFormat(), this.strictJsonSchema), (Object)this.responseFormat));
        return ChatResponse.builder().aiMessage((AiMessage)response.content()).tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).build();
    }

    private Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ToolSpecification toolThatMustBeExecuted, ResponseFormat responseFormat) {
        if (responseFormat != null && responseFormat.type() == ResponseFormatType.JSON_SCHEMA && responseFormat.jsonSchema() == null) {
            responseFormat = null;
        }
        ChatCompletionRequest.Builder requestBuilder = ChatCompletionRequest.builder().model(this.modelName).messages(InternalOpenAiHelper.toOpenAiMessages(messages)).temperature(this.temperature).topP(this.topP).stop(this.stop).maxTokens(this.maxTokens).maxCompletionTokens(this.maxCompletionTokens).presencePenalty(this.presencePenalty).frequencyPenalty(this.frequencyPenalty).logitBias(this.logitBias).responseFormat(responseFormat).seed(this.seed).user(this.user).parallelToolCalls(this.parallelToolCalls);
        if (toolSpecifications != null && !toolSpecifications.isEmpty()) {
            requestBuilder.tools(InternalOpenAiHelper.toTools(toolSpecifications, this.strictTools));
        }
        if (toolThatMustBeExecuted != null) {
            requestBuilder.toolChoice(toolThatMustBeExecuted.name());
        }
        ChatCompletionRequest request = requestBuilder.build();
        ChatModelRequest modelListenerRequest = InternalOpenAiHelper.createModelListenerRequest(request, messages, toolSpecifications);
        ConcurrentHashMap attributes = new ConcurrentHashMap();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(modelListenerRequest, attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(requestContext);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", (Throwable)e);
            }
        });
        try {
            ChatCompletionResponse chatCompletionResponse = (ChatCompletionResponse)RetryUtils.withRetry(() -> (ChatCompletionResponse)this.client.chatCompletion(request).execute(), (int)this.maxRetries);
            Response response = Response.from((Object)InternalOpenAiHelper.aiMessageFrom(chatCompletionResponse), (TokenUsage)InternalOpenAiHelper.tokenUsageFrom(chatCompletionResponse.usage()), (FinishReason)InternalOpenAiHelper.finishReasonFrom(((ChatCompletionChoice)chatCompletionResponse.choices().get(0)).finishReason()));
            ChatModelResponse modelListenerResponse = InternalOpenAiHelper.createModelListenerResponse(chatCompletionResponse.id(), chatCompletionResponse.model(), (Response<AiMessage>)response);
            ChatModelResponseContext responseContext = new ChatModelResponseContext(modelListenerResponse, modelListenerRequest, attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onResponse(responseContext);
                }
                catch (Exception e) {
                    log.warn("Exception while calling model listener", (Throwable)e);
                }
            });
            return response;
        }
        catch (RuntimeException e) {
            Throwable error = e.getCause() instanceof OpenAiHttpException ? e.getCause() : e;
            ChatModelErrorContext errorContext = new ChatModelErrorContext(error, modelListenerRequest, null, attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onError(errorContext);
                }
                catch (Exception e2) {
                    log.warn("Exception while calling model listener", (Throwable)e2);
                }
            });
            throw e;
        }
    }

    public int estimateTokenCount(List<ChatMessage> messages) {
        return this.tokenizer.estimateTokenCountInMessages(messages);
    }

    @Deprecated(forRemoval=true)
    public static OpenAiChatModel withApiKey(String apiKey) {
        return OpenAiChatModel.builder().apiKey(apiKey).build();
    }

    public static OpenAiChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(OpenAiChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            OpenAiChatModelBuilderFactory factory = (OpenAiChatModelBuilderFactory)iterator.next();
            return (OpenAiChatModelBuilder)factory.get();
        }
        return new OpenAiChatModelBuilder();
    }

    public static class OpenAiChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String organizationId;
        private String modelName;
        private Double temperature;
        private Double topP;
        private List<String> stop;
        private Integer maxTokens;
        private Integer maxCompletionTokens;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Map<String, Integer> logitBias;
        private String responseFormat;
        private Boolean strictJsonSchema;
        private Integer seed;
        private String user;
        private Boolean strictTools;
        private Boolean parallelToolCalls;
        private Duration timeout;
        private Integer maxRetries;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;
        private Tokenizer tokenizer;
        private Map<String, String> customHeaders;
        private List<ChatModelListener> listeners;

        public OpenAiChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OpenAiChatModelBuilder modelName(OpenAiChatModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public OpenAiChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OpenAiChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public OpenAiChatModelBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public OpenAiChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public OpenAiChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public OpenAiChatModelBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public OpenAiChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public OpenAiChatModelBuilder maxCompletionTokens(Integer maxCompletionTokens) {
            this.maxCompletionTokens = maxCompletionTokens;
            return this;
        }

        public OpenAiChatModelBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public OpenAiChatModelBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public OpenAiChatModelBuilder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public OpenAiChatModelBuilder responseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public OpenAiChatModelBuilder strictJsonSchema(Boolean strictJsonSchema) {
            this.strictJsonSchema = strictJsonSchema;
            return this;
        }

        public OpenAiChatModelBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public OpenAiChatModelBuilder user(String user) {
            this.user = user;
            return this;
        }

        public OpenAiChatModelBuilder strictTools(Boolean strictTools) {
            this.strictTools = strictTools;
            return this;
        }

        public OpenAiChatModelBuilder parallelToolCalls(Boolean parallelToolCalls) {
            this.parallelToolCalls = parallelToolCalls;
            return this;
        }

        public OpenAiChatModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OpenAiChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public OpenAiChatModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public OpenAiChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OpenAiChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OpenAiChatModelBuilder tokenizer(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public OpenAiChatModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public OpenAiChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public OpenAiChatModel build() {
            return new OpenAiChatModel(this.baseUrl, this.apiKey, this.organizationId, this.modelName, this.temperature, this.topP, this.stop, this.maxTokens, this.maxCompletionTokens, this.presencePenalty, this.frequencyPenalty, this.logitBias, this.responseFormat, this.strictJsonSchema, this.seed, this.user, this.strictTools, this.parallelToolCalls, this.timeout, this.maxRetries, this.proxy, this.logRequests, this.logResponses, this.tokenizer, this.customHeaders, this.listeners);
        }

        public String toString() {
            return new StringJoiner(", ", OpenAiChatModelBuilder.class.getSimpleName() + "[", "]").add("baseUrl='" + this.baseUrl + "'").add("organizationId='" + this.organizationId + "'").add("modelName='" + this.modelName + "'").add("temperature=" + this.temperature).add("topP=" + this.topP).add("stop=" + String.valueOf(this.stop)).add("maxTokens=" + this.maxTokens).add("maxCompletionTokens=" + this.maxCompletionTokens).add("presencePenalty=" + this.presencePenalty).add("frequencyPenalty=" + this.frequencyPenalty).add("logitBias=" + String.valueOf(this.logitBias)).add("responseFormat='" + this.responseFormat + "'").add("strictJsonSchema=" + this.strictJsonSchema).add("seed=" + this.seed).add("user='" + this.user + "'").add("strictTools=" + this.strictTools).add("parallelToolCalls=" + this.parallelToolCalls).add("timeout=" + String.valueOf(this.timeout)).add("maxRetries=" + this.maxRetries).add("proxy=" + String.valueOf(this.proxy)).add("logRequests=" + this.logRequests).add("logResponses=" + this.logResponses).add("tokenizer=" + String.valueOf(this.tokenizer)).add("customHeaders=" + String.valueOf(this.customHeaders)).add("listeners=" + String.valueOf(this.listeners)).toString();
        }
    }
}

