/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.chat.ChatCompletionChoice;
import dev.ai4j.openai4j.chat.ChatCompletionRequest;
import dev.ai4j.openai4j.chat.ChatCompletionResponse;
import dev.ai4j.openai4j.chat.Delta;
import dev.ai4j.openai4j.shared.StreamOptions;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.TokenCountEstimator;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.openai.InternalOpenAiHelper;
import dev.langchain4j.model.openai.OpenAiChatModelName;
import dev.langchain4j.model.openai.OpenAiChatRequestParameters;
import dev.langchain4j.model.openai.OpenAiStreamingResponseBuilder;
import dev.langchain4j.model.openai.OpenAiTokenizer;
import dev.langchain4j.model.openai.spi.OpenAiStreamingChatModelBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class OpenAiStreamingChatModel
implements StreamingChatLanguageModel,
TokenCountEstimator {
    private final OpenAiClient client;
    private final OpenAiChatRequestParameters defaultRequestParameters;
    private final Boolean strictJsonSchema;
    private final Boolean strictTools;
    private final Tokenizer tokenizer;
    private final List<ChatModelListener> listeners;

    public OpenAiStreamingChatModel(String baseUrl, String apiKey, String organizationId, ChatRequestParameters defaultRequestParameters, String modelName, Double temperature, Double topP, List<String> stop, Integer maxTokens, Integer maxCompletionTokens, Double presencePenalty, Double frequencyPenalty, Map<String, Integer> logitBias, String responseFormat, Boolean strictJsonSchema, Integer seed, String user, Boolean strictTools, Boolean parallelToolCalls, Boolean store, Map<String, String> metadata, String serviceTier, Duration timeout, Proxy proxy, Boolean logRequests, Boolean logResponses, Tokenizer tokenizer, Map<String, String> customHeaders, List<ChatModelListener> listeners) {
        OpenAiChatRequestParameters openAiChatRequestParameters;
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        this.client = OpenAiClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.openai.com/v1")).openAiApiKey(apiKey).organizationId(organizationId).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).proxy(proxy).logRequests(logRequests).logStreamingResponses(logResponses).userAgent("langchain4j-openai").customHeaders(customHeaders).build();
        ChatRequestParameters commonParameters = defaultRequestParameters != null ? defaultRequestParameters : DefaultChatRequestParameters.builder().build();
        OpenAiChatRequestParameters openAiParameters = defaultRequestParameters instanceof OpenAiChatRequestParameters ? (openAiChatRequestParameters = (OpenAiChatRequestParameters)defaultRequestParameters) : OpenAiChatRequestParameters.builder().build();
        this.defaultRequestParameters = ((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)OpenAiChatRequestParameters.builder().modelName((String)Utils.getOrDefault((Object)modelName, (Object)commonParameters.modelName()))).temperature((Double)Utils.getOrDefault((Object)temperature, (Object)commonParameters.temperature()))).topP((Double)Utils.getOrDefault((Object)topP, (Object)commonParameters.topP()))).frequencyPenalty((Double)Utils.getOrDefault((Object)frequencyPenalty, (Object)commonParameters.frequencyPenalty()))).presencePenalty((Double)Utils.getOrDefault((Object)presencePenalty, (Object)commonParameters.presencePenalty()))).maxOutputTokens((Integer)Utils.getOrDefault((Object)maxTokens, (Object)commonParameters.maxOutputTokens()))).stopSequences((List)Utils.getOrDefault(stop, () -> Utils.copyIfNotNull((List)commonParameters.stopSequences())))).toolSpecifications(Utils.copyIfNotNull((List)commonParameters.toolSpecifications()))).toolChoice(commonParameters.toolChoice())).responseFormat((ResponseFormat)Utils.getOrDefault((Object)InternalOpenAiHelper.fromOpenAiResponseFormat(responseFormat), (Object)commonParameters.responseFormat()))).maxCompletionTokens((Integer)Utils.getOrDefault((Object)maxCompletionTokens, (Object)openAiParameters.maxCompletionTokens())).logitBias((Map)Utils.getOrDefault(logitBias, () -> Utils.copyIfNotNull(openAiParameters.logitBias()))).parallelToolCalls((Boolean)Utils.getOrDefault((Object)parallelToolCalls, (Object)openAiParameters.parallelToolCalls())).seed((Integer)Utils.getOrDefault((Object)seed, (Object)openAiParameters.seed())).user((String)Utils.getOrDefault((Object)user, (Object)openAiParameters.user())).store((Boolean)Utils.getOrDefault((Object)store, (Object)openAiParameters.store())).metadata((Map)Utils.getOrDefault(metadata, () -> Utils.copyIfNotNull(openAiParameters.metadata()))).serviceTier((String)Utils.getOrDefault((Object)serviceTier, (Object)openAiParameters.serviceTier())).reasoningEffort(openAiParameters.reasoningEffort()).build();
        this.strictJsonSchema = (Boolean)Utils.getOrDefault((Object)strictJsonSchema, (Object)false);
        this.strictTools = (Boolean)Utils.getOrDefault((Object)strictTools, (Object)false);
        this.tokenizer = (Tokenizer)Utils.getOrDefault((Object)tokenizer, OpenAiTokenizer::new);
        this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
    }

    @Deprecated(forRemoval=true)
    public String modelName() {
        return this.defaultRequestParameters.modelName();
    }

    public OpenAiChatRequestParameters defaultRequestParameters() {
        return this.defaultRequestParameters;
    }

    public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
        ChatRequest chatRequest = ChatRequest.builder().messages(messages).build();
        this.chat(chatRequest, InternalOpenAiHelper.convertHandler(handler));
    }

    public void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, StreamingResponseHandler<AiMessage> handler) {
        ChatRequest chatRequest = ChatRequest.builder().messages(messages).parameters(ChatRequestParameters.builder().toolSpecifications(toolSpecifications).build()).build();
        this.chat(chatRequest, InternalOpenAiHelper.convertHandler(handler));
    }

    public void generate(List<ChatMessage> messages, ToolSpecification toolSpecification, StreamingResponseHandler<AiMessage> handler) {
        ChatRequest chatRequest = ChatRequest.builder().messages(messages).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{toolSpecification}).toolChoice(ToolChoice.REQUIRED).build()).build();
        this.chat(chatRequest, InternalOpenAiHelper.convertHandler(handler));
    }

    public void doChat(ChatRequest chatRequest, StreamingChatResponseHandler handler) {
        OpenAiChatRequestParameters parameters = (OpenAiChatRequestParameters)chatRequest.parameters();
        InternalOpenAiHelper.validate((ChatRequestParameters)parameters);
        ChatCompletionRequest openAiRequest = InternalOpenAiHelper.toOpenAiChatRequest(chatRequest, parameters, this.strictTools, this.strictJsonSchema).stream(Boolean.valueOf(true)).streamOptions(StreamOptions.builder().includeUsage(Boolean.valueOf(true)).build()).build();
        OpenAiStreamingResponseBuilder openAiResponseBuilder = new OpenAiStreamingResponseBuilder();
        this.client.chatCompletion(openAiRequest).onPartialResponse(partialResponse -> {
            openAiResponseBuilder.append((ChatCompletionResponse)partialResponse);
            OpenAiStreamingChatModel.handle(partialResponse, handler);
        }).onComplete(() -> {
            ChatResponse chatResponse = openAiResponseBuilder.build();
            handler.onCompleteResponse(chatResponse);
        }).onError(arg_0 -> ((StreamingChatResponseHandler)handler).onError(arg_0)).execute();
    }

    private static void handle(ChatCompletionResponse partialResponse, StreamingChatResponseHandler handler) {
        if (partialResponse == null) {
            return;
        }
        List choices = partialResponse.choices();
        if (choices == null || choices.isEmpty()) {
            return;
        }
        ChatCompletionChoice chatCompletionChoice = (ChatCompletionChoice)choices.get(0);
        if (chatCompletionChoice == null) {
            return;
        }
        Delta delta = chatCompletionChoice.delta();
        if (delta == null) {
            return;
        }
        String content = delta.content();
        if (!Utils.isNullOrEmpty((String)content)) {
            handler.onPartialResponse(content);
        }
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public int estimateTokenCount(List<ChatMessage> messages) {
        return this.tokenizer.estimateTokenCountInMessages(messages);
    }

    @Deprecated(forRemoval=true)
    public static OpenAiStreamingChatModel withApiKey(String apiKey) {
        return OpenAiStreamingChatModel.builder().apiKey(apiKey).build();
    }

    public static OpenAiStreamingChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(OpenAiStreamingChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            OpenAiStreamingChatModelBuilderFactory factory = (OpenAiStreamingChatModelBuilderFactory)iterator.next();
            return (OpenAiStreamingChatModelBuilder)factory.get();
        }
        return new OpenAiStreamingChatModelBuilder();
    }

    public static class OpenAiStreamingChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String organizationId;
        private ChatRequestParameters defaultRequestParameters;
        private String modelName;
        private Double temperature;
        private Double topP;
        private List<String> stop;
        private Integer maxTokens;
        private Integer maxCompletionTokens;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Map<String, Integer> logitBias;
        private String responseFormat;
        private Boolean strictJsonSchema;
        private Integer seed;
        private String user;
        private Boolean strictTools;
        private Boolean parallelToolCalls;
        private Boolean store;
        private Map<String, String> metadata;
        private String serviceTier;
        private Duration timeout;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;
        private Tokenizer tokenizer;
        private Map<String, String> customHeaders;
        private List<ChatModelListener> listeners;

        public OpenAiStreamingChatModelBuilder defaultRequestParameters(ChatRequestParameters parameters) {
            this.defaultRequestParameters = parameters;
            return this;
        }

        public OpenAiStreamingChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OpenAiStreamingChatModelBuilder modelName(OpenAiChatModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public OpenAiStreamingChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OpenAiStreamingChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public OpenAiStreamingChatModelBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public OpenAiStreamingChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public OpenAiStreamingChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public OpenAiStreamingChatModelBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public OpenAiStreamingChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public OpenAiStreamingChatModelBuilder maxCompletionTokens(Integer maxCompletionTokens) {
            this.maxCompletionTokens = maxCompletionTokens;
            return this;
        }

        public OpenAiStreamingChatModelBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public OpenAiStreamingChatModelBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public OpenAiStreamingChatModelBuilder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public OpenAiStreamingChatModelBuilder responseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public OpenAiStreamingChatModelBuilder strictJsonSchema(Boolean strictJsonSchema) {
            this.strictJsonSchema = strictJsonSchema;
            return this;
        }

        public OpenAiStreamingChatModelBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public OpenAiStreamingChatModelBuilder user(String user) {
            this.user = user;
            return this;
        }

        public OpenAiStreamingChatModelBuilder strictTools(Boolean strictTools) {
            this.strictTools = strictTools;
            return this;
        }

        public OpenAiStreamingChatModelBuilder parallelToolCalls(Boolean parallelToolCalls) {
            this.parallelToolCalls = parallelToolCalls;
            return this;
        }

        public OpenAiStreamingChatModelBuilder store(Boolean store) {
            this.store = store;
            return this;
        }

        public OpenAiStreamingChatModelBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public OpenAiStreamingChatModelBuilder serviceTier(String serviceTier) {
            this.serviceTier = serviceTier;
            return this;
        }

        public OpenAiStreamingChatModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OpenAiStreamingChatModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public OpenAiStreamingChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OpenAiStreamingChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OpenAiStreamingChatModelBuilder tokenizer(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public OpenAiStreamingChatModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public OpenAiStreamingChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public OpenAiStreamingChatModel build() {
            return new OpenAiStreamingChatModel(this.baseUrl, this.apiKey, this.organizationId, this.defaultRequestParameters, this.modelName, this.temperature, this.topP, this.stop, this.maxTokens, this.maxCompletionTokens, this.presencePenalty, this.frequencyPenalty, this.logitBias, this.responseFormat, this.strictJsonSchema, this.seed, this.user, this.strictTools, this.parallelToolCalls, this.store, this.metadata, this.serviceTier, this.timeout, this.proxy, this.logRequests, this.logResponses, this.tokenizer, this.customHeaders, this.listeners);
        }

        public String toString() {
            return new StringJoiner(", ", OpenAiStreamingChatModelBuilder.class.getSimpleName() + "[", "]").add("baseUrl='" + this.baseUrl + "'").add("organizationId='" + this.organizationId + "'").add("defaultRequestParameters='" + String.valueOf(this.defaultRequestParameters) + "'").add("modelName='" + this.modelName + "'").add("temperature=" + this.temperature).add("topP=" + this.topP).add("stop=" + String.valueOf(this.stop)).add("maxTokens=" + this.maxTokens).add("maxCompletionTokens=" + this.maxCompletionTokens).add("presencePenalty=" + this.presencePenalty).add("frequencyPenalty=" + this.frequencyPenalty).add("logitBias=" + String.valueOf(this.logitBias)).add("responseFormat='" + this.responseFormat + "'").add("strictJsonSchema=" + this.strictJsonSchema).add("seed=" + this.seed).add("user='" + this.user + "'").add("strictTools=" + this.strictTools).add("parallelToolCalls=" + this.parallelToolCalls).add("store=" + this.store).add("metadata=" + String.valueOf(this.metadata)).add("serviceTier=" + this.serviceTier).add("timeout=" + String.valueOf(this.timeout)).add("proxy=" + String.valueOf(this.proxy)).add("logRequests=" + this.logRequests).add("logResponses=" + this.logResponses).add("tokenizer=" + String.valueOf(this.tokenizer)).add("customHeaders=" + String.valueOf(this.customHeaders)).add("listeners=" + String.valueOf(this.listeners)).toString();
        }
    }
}

