/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai.internal;

import dev.langchain4j.Internal;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.AudioContent;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.PdfFileContent;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.exception.ContentFilteredException;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.JsonSchemaElementUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonRawSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.openai.OpenAiChatRequestParameters;
import dev.langchain4j.model.openai.OpenAiTokenUsage;
import dev.langchain4j.model.openai.internal.chat.AssistantMessage;
import dev.langchain4j.model.openai.internal.chat.ChatCompletionRequest;
import dev.langchain4j.model.openai.internal.chat.ChatCompletionResponse;
import dev.langchain4j.model.openai.internal.chat.Content;
import dev.langchain4j.model.openai.internal.chat.ContentType;
import dev.langchain4j.model.openai.internal.chat.Function;
import dev.langchain4j.model.openai.internal.chat.FunctionCall;
import dev.langchain4j.model.openai.internal.chat.FunctionMessage;
import dev.langchain4j.model.openai.internal.chat.ImageDetail;
import dev.langchain4j.model.openai.internal.chat.ImageUrl;
import dev.langchain4j.model.openai.internal.chat.InputAudio;
import dev.langchain4j.model.openai.internal.chat.JsonSchema;
import dev.langchain4j.model.openai.internal.chat.Message;
import dev.langchain4j.model.openai.internal.chat.PdfFile;
import dev.langchain4j.model.openai.internal.chat.ResponseFormat;
import dev.langchain4j.model.openai.internal.chat.ResponseFormatType;
import dev.langchain4j.model.openai.internal.chat.SystemMessage;
import dev.langchain4j.model.openai.internal.chat.Tool;
import dev.langchain4j.model.openai.internal.chat.ToolCall;
import dev.langchain4j.model.openai.internal.chat.ToolChoiceMode;
import dev.langchain4j.model.openai.internal.chat.ToolMessage;
import dev.langchain4j.model.openai.internal.chat.ToolType;
import dev.langchain4j.model.openai.internal.chat.UserMessage;
import dev.langchain4j.model.openai.internal.shared.CompletionTokensDetails;
import dev.langchain4j.model.openai.internal.shared.PromptTokensDetails;
import dev.langchain4j.model.openai.internal.shared.Usage;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Internal
public class OpenAiUtils {
    public static final String DEFAULT_OPENAI_URL = "https://api.openai.com/v1";
    public static final String DEFAULT_USER_AGENT = "langchain4j-openai";

    public static List<Message> toOpenAiMessages(List<ChatMessage> messages) {
        return messages.stream().map(OpenAiUtils::toOpenAiMessage).collect(Collectors.toList());
    }

    public static Message toOpenAiMessage(ChatMessage message) {
        if (message instanceof dev.langchain4j.data.message.SystemMessage) {
            return SystemMessage.from(((dev.langchain4j.data.message.SystemMessage)message).text());
        }
        if (message instanceof dev.langchain4j.data.message.UserMessage) {
            dev.langchain4j.data.message.UserMessage userMessage = (dev.langchain4j.data.message.UserMessage)message;
            if (userMessage.hasSingleText()) {
                return UserMessage.builder().content(userMessage.singleText()).name(userMessage.name()).build();
            }
            return UserMessage.builder().content(userMessage.contents().stream().map(OpenAiUtils::toOpenAiContent).collect(Collectors.toList())).name(userMessage.name()).build();
        }
        if (message instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)message;
            if (!aiMessage.hasToolExecutionRequests()) {
                return AssistantMessage.from(aiMessage.text());
            }
            ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
            if (toolExecutionRequest.id() == null) {
                FunctionCall functionCall = FunctionCall.builder().name(toolExecutionRequest.name()).arguments(toolExecutionRequest.arguments()).build();
                return AssistantMessage.builder().functionCall(functionCall).build();
            }
            List<ToolCall> toolCalls = aiMessage.toolExecutionRequests().stream().map(it -> ToolCall.builder().id(it.id()).type(ToolType.FUNCTION).function(FunctionCall.builder().name(it.name()).arguments(Utils.isNullOrBlank((String)it.arguments()) ? "{}" : it.arguments()).build()).build()).collect(Collectors.toList());
            return AssistantMessage.builder().content(aiMessage.text()).toolCalls(toolCalls).build();
        }
        if (message instanceof ToolExecutionResultMessage) {
            ToolExecutionResultMessage toolExecutionResultMessage = (ToolExecutionResultMessage)message;
            if (toolExecutionResultMessage.id() == null) {
                return FunctionMessage.from(toolExecutionResultMessage.toolName(), toolExecutionResultMessage.text());
            }
            return ToolMessage.from(toolExecutionResultMessage.id(), toolExecutionResultMessage.text());
        }
        throw Exceptions.illegalArgument((String)("Unknown message type: " + String.valueOf(message.type())), (Object[])new Object[0]);
    }

    private static Content toOpenAiContent(dev.langchain4j.data.message.Content content) {
        if (content instanceof TextContent) {
            return OpenAiUtils.toOpenAiContent((TextContent)content);
        }
        if (content instanceof ImageContent) {
            return OpenAiUtils.toOpenAiContent((ImageContent)content);
        }
        if (content instanceof AudioContent) {
            AudioContent audioContent = (AudioContent)content;
            return OpenAiUtils.toOpenAiContent(audioContent);
        }
        if (content instanceof PdfFileContent) {
            PdfFileContent pdfFileContent = (PdfFileContent)content;
            return OpenAiUtils.toOpenAiContent(pdfFileContent);
        }
        throw Exceptions.illegalArgument((String)("Unknown content type: " + String.valueOf(content)), (Object[])new Object[0]);
    }

    private static Content toOpenAiContent(TextContent content) {
        return Content.builder().type(ContentType.TEXT).text(content.text()).build();
    }

    private static Content toOpenAiContent(ImageContent content) {
        return Content.builder().type(ContentType.IMAGE_URL).imageUrl(ImageUrl.builder().url(OpenAiUtils.toUrl(content.image())).detail(OpenAiUtils.toDetail(content.detailLevel())).build()).build();
    }

    private static Content toOpenAiContent(AudioContent audioContent) {
        return Content.builder().type(ContentType.AUDIO).inputAudio(InputAudio.builder().data(ValidationUtils.ensureNotBlank((String)audioContent.audio().base64Data(), (String)"audio.base64Data")).format(OpenAiUtils.extractSubtype(ValidationUtils.ensureNotBlank((String)audioContent.audio().mimeType(), (String)"audio.mimeType"))).build()).build();
    }

    private static Content toOpenAiContent(PdfFileContent pdfFileContent) {
        String fileData = pdfFileContent.pdfFile().url() != null ? pdfFileContent.pdfFile().url().toString() : String.format("data:%s;base64,%s", pdfFileContent.pdfFile().mimeType(), pdfFileContent.pdfFile().base64Data());
        return Content.builder().type(ContentType.FILE).file(PdfFile.builder().fileData(fileData).filename("pdf_file").build()).build();
    }

    private static String extractSubtype(String mimetype) {
        return mimetype.split("/")[1];
    }

    private static String toUrl(Image image) {
        if (image.url() != null) {
            return image.url().toString();
        }
        return String.format("data:%s;base64,%s", image.mimeType(), image.base64Data());
    }

    private static ImageDetail toDetail(ImageContent.DetailLevel detailLevel) {
        if (detailLevel == null) {
            return null;
        }
        return ImageDetail.valueOf(detailLevel.name());
    }

    public static List<Tool> toTools(Collection<ToolSpecification> toolSpecifications, boolean strict) {
        return toolSpecifications.stream().map(toolSpecification -> OpenAiUtils.toTool(toolSpecification, strict)).collect(Collectors.toList());
    }

    private static Tool toTool(ToolSpecification toolSpecification, boolean strict) {
        Function.Builder functionBuilder = Function.builder().name(toolSpecification.name()).description(toolSpecification.description()).parameters(OpenAiUtils.toOpenAiParameters(toolSpecification.parameters(), strict));
        if (strict) {
            functionBuilder.strict(true);
        }
        Function function = functionBuilder.build();
        return Tool.from(function);
    }

    @Deprecated
    public static List<Function> toFunctions(Collection<ToolSpecification> toolSpecifications) {
        return toolSpecifications.stream().map(OpenAiUtils::toFunction).collect(Collectors.toList());
    }

    @Deprecated
    private static Function toFunction(ToolSpecification toolSpecification) {
        return Function.builder().name(toolSpecification.name()).description(toolSpecification.description()).parameters(OpenAiUtils.toOpenAiParameters(toolSpecification.parameters(), false)).build();
    }

    private static Map<String, Object> toOpenAiParameters(JsonObjectSchema parameters, boolean strict) {
        if (parameters != null) {
            return JsonSchemaElementUtils.toMap((JsonSchemaElement)parameters, (boolean)strict);
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", "object");
        map.put("properties", new HashMap());
        map.put("required", new ArrayList());
        if (strict) {
            map.put("additionalProperties", false);
        }
        return map;
    }

    public static AiMessage aiMessageFrom(ChatCompletionResponse response) {
        return OpenAiUtils.aiMessageFrom(response, false);
    }

    public static AiMessage aiMessageFrom(ChatCompletionResponse response, boolean returnThinking) {
        AssistantMessage assistantMessage = response.choices().get(0).message();
        String refusal = assistantMessage.refusal();
        if (Utils.isNotNullOrBlank((String)refusal)) {
            throw new ContentFilteredException(refusal);
        }
        String content = assistantMessage.content();
        String reasoningContent = null;
        if (returnThinking) {
            reasoningContent = assistantMessage.reasoningContent();
        }
        List toolExecutionRequests = Utils.getOrDefault(assistantMessage.toolCalls(), List.of()).stream().filter(toolCall -> toolCall.type() == ToolType.FUNCTION).map(OpenAiUtils::toToolExecutionRequest).collect(Collectors.toList());
        FunctionCall functionCall = assistantMessage.functionCall();
        if (functionCall != null) {
            ToolExecutionRequest toolExecutionRequest = ToolExecutionRequest.builder().name(functionCall.name()).arguments(functionCall.arguments()).build();
            toolExecutionRequests.add(toolExecutionRequest);
        }
        return AiMessage.builder().text(Utils.isNullOrEmpty((String)content) ? null : content).thinking(Utils.isNullOrEmpty((String)reasoningContent) ? null : reasoningContent).toolExecutionRequests(toolExecutionRequests).build();
    }

    private static ToolExecutionRequest toToolExecutionRequest(ToolCall toolCall) {
        FunctionCall functionCall = toolCall.function();
        return ToolExecutionRequest.builder().id(toolCall.id()).name(functionCall.name()).arguments(functionCall.arguments()).build();
    }

    public static OpenAiTokenUsage tokenUsageFrom(Usage openAiUsage) {
        if (openAiUsage == null) {
            return null;
        }
        PromptTokensDetails promptTokensDetails = openAiUsage.promptTokensDetails();
        OpenAiTokenUsage.InputTokensDetails inputTokensDetails = null;
        if (promptTokensDetails != null) {
            inputTokensDetails = OpenAiTokenUsage.InputTokensDetails.builder().cachedTokens(promptTokensDetails.cachedTokens()).build();
        }
        CompletionTokensDetails completionTokensDetails = openAiUsage.completionTokensDetails();
        OpenAiTokenUsage.OutputTokensDetails outputTokensDetails = null;
        if (completionTokensDetails != null) {
            outputTokensDetails = OpenAiTokenUsage.OutputTokensDetails.builder().reasoningTokens(completionTokensDetails.reasoningTokens()).build();
        }
        return OpenAiTokenUsage.builder().inputTokenCount(openAiUsage.promptTokens()).inputTokensDetails(inputTokensDetails).outputTokenCount(openAiUsage.completionTokens()).outputTokensDetails(outputTokensDetails).totalTokenCount(openAiUsage.totalTokens()).build();
    }

    public static FinishReason finishReasonFrom(String openAiFinishReason) {
        if (openAiFinishReason == null) {
            return null;
        }
        switch (openAiFinishReason) {
            case "stop": {
                return FinishReason.STOP;
            }
            case "length": {
                return FinishReason.LENGTH;
            }
            case "tool_calls": 
            case "function_call": {
                return FinishReason.TOOL_EXECUTION;
            }
            case "content_filter": {
                return FinishReason.CONTENT_FILTER;
            }
        }
        return null;
    }

    static ResponseFormat toOpenAiResponseFormat(dev.langchain4j.model.chat.request.ResponseFormat responseFormat, Boolean strict) {
        if (responseFormat == null || responseFormat.type() == dev.langchain4j.model.chat.request.ResponseFormatType.TEXT) {
            return null;
        }
        dev.langchain4j.model.chat.request.json.JsonSchema jsonSchema = responseFormat.jsonSchema();
        if (jsonSchema == null) {
            return ResponseFormat.builder().type(ResponseFormatType.JSON_OBJECT).build();
        }
        if (!(jsonSchema.rootElement() instanceof JsonObjectSchema) && !(jsonSchema.rootElement() instanceof JsonRawSchema)) {
            throw new IllegalArgumentException("For OpenAI, the root element of the JSON Schema must be either a JsonObjectSchema or a JsonRawSchema, but it was: " + String.valueOf(jsonSchema.rootElement().getClass()));
        }
        JsonSchema openAiJsonSchema = JsonSchema.builder().name(jsonSchema.name()).strict(strict).schema(JsonSchemaElementUtils.toMap((JsonSchemaElement)jsonSchema.rootElement(), (boolean)strict)).build();
        return ResponseFormat.builder().type(ResponseFormatType.JSON_SCHEMA).jsonSchema(openAiJsonSchema).build();
    }

    public static ToolChoiceMode toOpenAiToolChoice(ToolChoice toolChoice) {
        if (toolChoice == null) {
            return null;
        }
        return switch (toolChoice) {
            default -> throw new IncompatibleClassChangeError();
            case ToolChoice.AUTO -> ToolChoiceMode.AUTO;
            case ToolChoice.REQUIRED -> ToolChoiceMode.REQUIRED;
            case ToolChoice.NONE -> ToolChoiceMode.NONE;
        };
    }

    public static Response<AiMessage> convertResponse(ChatResponse chatResponse) {
        return Response.from((Object)chatResponse.aiMessage(), (TokenUsage)chatResponse.metadata().tokenUsage(), (FinishReason)chatResponse.metadata().finishReason());
    }

    public static void validate(ChatRequestParameters parameters) {
        if (parameters.topK() != null) {
            throw new UnsupportedFeatureException("'topK' parameter is not supported by OpenAI");
        }
    }

    public static dev.langchain4j.model.chat.request.ResponseFormat fromOpenAiResponseFormat(String responseFormat) {
        if ("json_object".equals(responseFormat)) {
            return dev.langchain4j.model.chat.request.ResponseFormat.JSON;
        }
        return null;
    }

    public static ChatCompletionRequest.Builder toOpenAiChatRequest(ChatRequest chatRequest, OpenAiChatRequestParameters parameters, Boolean strictTools, Boolean strictJsonSchema) {
        return ChatCompletionRequest.builder().messages(OpenAiUtils.toOpenAiMessages(chatRequest.messages())).model(parameters.modelName()).temperature(parameters.temperature()).topP(parameters.topP()).frequencyPenalty(parameters.frequencyPenalty()).presencePenalty(parameters.presencePenalty()).maxTokens(parameters.maxOutputTokens()).stop(parameters.stopSequences()).tools(OpenAiUtils.toTools(parameters.toolSpecifications(), strictTools)).toolChoice(OpenAiUtils.toOpenAiToolChoice(parameters.toolChoice())).responseFormat(OpenAiUtils.toOpenAiResponseFormat(parameters.responseFormat(), strictJsonSchema)).maxCompletionTokens(parameters.maxCompletionTokens()).logitBias(parameters.logitBias()).parallelToolCalls(parameters.parallelToolCalls()).seed(parameters.seed()).user(parameters.user()).store(parameters.store()).metadata(parameters.metadata()).serviceTier(parameters.serviceTier()).reasoningEffort(parameters.reasoningEffort()).customParameters(parameters.customParameters());
    }
}

