/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai.internal.embedding;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import dev.langchain4j.model.openai.internal.embedding.OpenAiEmbeddingDeserializer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public final class Embedding {
    @JsonProperty
    private final List<Float> embedding;
    @JsonProperty
    private final Integer index;

    public Embedding(Builder builder) {
        this.embedding = builder.embedding;
        this.index = builder.index;
    }

    public List<Float> embedding() {
        return this.embedding;
    }

    public Integer index() {
        return this.index;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Embedding && this.equalTo((Embedding)another);
    }

    private boolean equalTo(Embedding another) {
        return Objects.equals(this.embedding, another.embedding) && Objects.equals(this.index, another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.embedding);
        h += (h << 5) + Objects.hashCode(this.index);
        return h;
    }

    public String toString() {
        return "Embedding{embedding=" + String.valueOf(this.embedding) + ", index=" + this.index + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static final class Builder {
        private List<Float> embedding;
        private Integer index;

        @JsonDeserialize(using=OpenAiEmbeddingDeserializer.class)
        public Builder embedding(List<Float> embedding) {
            if (embedding != null) {
                this.embedding = Collections.unmodifiableList(embedding);
            }
            return this;
        }

        public Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public Embedding build() {
            return new Embedding(this);
        }
    }
}

